/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.util;

import com.bizunited.config.SmsConfig;
import com.bizunited.smsmsg.PhoneContentKey;
import com.bizunited.smsmsg.PhoneTemplateKey;
import com.bizunited.smsmsg.SMSReply;
import com.bizunited.smsmsg.SMSReport;
import com.bizunited.smsmsg.SmsStub;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.commons.lang.StringUtils;

public class SmsMessageUtil {
    private static SmsStub sms = null;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
    private static final SimpleDateFormat replaySdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Map<Object, Integer> smsSendLogMap = new HashMap<Object, Integer>();

    static {
        if (sms == null) {
            try {
                sms = new SmsStub();
            }
            catch (AxisFault e) {
                e.printStackTrace();
            }
        }
    }

    private SmsMessageUtil() {
    }

    @Deprecated
    public static String sendSMSMsg(String contentKey, String phonenum, String ... values) throws Exception {
        return SmsMessageUtil.sendSMSMsg(null, contentKey, phonenum, values);
    }

    @Deprecated
    public static String sendSMSMsg(Date sendTime, String contentKey, String phonenum, String ... values) throws Exception {
        ArrayList<String> phones = new ArrayList<String>();
        phones.add(phonenum);
        return SmsMessageUtil.sendSMSMsg(sendTime, contentKey, phones, values);
    }

    @Deprecated
    public static String sendSMSMsg(String contentKey, List<String> phonenums, String ... values) throws Exception {
        return SmsMessageUtil.sendSMSMsg(null, contentKey, phonenums, values);
    }

    @Deprecated
    public static String sendSMSMsg(Date sendTime, String contentKey, List<String> phonenums, String ... values) throws Exception {
        SmsStub.Sms sms0 = new SmsStub.Sms();
        sms0.setIn0(SmsConfig.SPCODE);
        sms0.setIn1(SmsConfig.LOGIN_NAME);
        sms0.setIn2(SmsConfig.PASSWORD);
        if (phonenums.size() > 1000) {
            throw new Exception("\u7535\u8bdd\u53f7\u7801\u6570\u91cf\u8fc7\u591a");
        }
        String content = SmsMessageUtil.buildSmsContent(contentKey, values);
        if (content.length() > 402) {
            throw new Exception("\u77ed\u4fe1\u5185\u5bb9\u8fc7\u957f");
        }
        if (SmsConfig.CLEAN_SEND_LOG.booleanValue()) {
            SmsMessageUtil.checkPhoneSendLog(contentKey, phonenums, content);
        }
        sms0.setIn3(content);
        sms0.setIn4(StringUtils.join(phonenums, (String)","));
        if (sendTime != null) {
            sms0.setIn6(sdf.format(sendTime));
        } else {
            sms0.setIn6("");
        }
        sms0.setIn5(SmsMessageUtil.getSerialNumber());
        sms0.setIn7("1");
        SmsStub.SmsResponse res = sms.sms(sms0);
        String result = res.getOut();
        if (SmsConfig.CLEAN_SEND_LOG.booleanValue() && result.indexOf("result=0") != -1) {
            SmsMessageUtil.addPhoneSendLog(contentKey, phonenums, content);
        }
        return result;
    }

    public static List<SMSReport> getReport() throws RemoteException {
        ArrayList<SMSReport> reports = new ArrayList<SMSReport>();
        SmsStub.Report report = new SmsStub.Report();
        report.setIn0(SmsConfig.SPCODE);
        report.setIn1(SmsConfig.LOGIN_NAME);
        report.setIn2(SmsConfig.PASSWORD);
        String info = sms.report(report).getOut();
        if (StringUtils.isNotEmpty((String)info)) {
            String[] stringArray = info.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                String[] re = str.split(",");
                reports.add(new SMSReport(re[0], re[1], re[2]));
                ++n2;
            }
        }
        return reports;
    }

    public static Set<SMSReply> getReplyInfo() throws RemoteException, ParseException {
        return SmsMessageUtil.getReplyInfo(new HashSet<SMSReply>());
    }

    private static Set<SMSReply> getReplyInfo(Set<SMSReply> smsreplay) throws RemoteException, ParseException {
        SmsStub.ReplyRequest replyRequest = new SmsStub.ReplyRequest();
        replyRequest.setIn0(SmsConfig.SPCODE);
        replyRequest.setIn1(SmsConfig.LOGIN_NAME);
        replyRequest.setIn2(SmsConfig.PASSWORD);
        SmsStub.ReplyResponse resp1 = sms.reply(replyRequest);
        String lastId = resp1.getId();
        SmsStub.Reply[] replys = resp1.getReplys();
        if (replys != null && replys.length > 0) {
            SmsStub.Reply[] replyArray = replys;
            int n = replys.length;
            int n2 = 0;
            while (n2 < n) {
                SmsStub.Reply reply = replyArray[n2];
                smsreplay.add(new SMSReply(reply.getCallMdn(), reply.getMdn(), reply.getContent(), replaySdf.parse(reply.getReply_time())));
                ++n2;
            }
            SmsMessageUtil.replyConfirm(lastId);
            return SmsMessageUtil.getReplyInfo(smsreplay);
        }
        return smsreplay;
    }

    private static String replyConfirm(String id) throws RemoteException {
        SmsStub.ReplyConfirmRequest confirm = new SmsStub.ReplyConfirmRequest();
        confirm.setIn0(SmsConfig.SPCODE);
        confirm.setIn1(SmsConfig.LOGIN_NAME);
        confirm.setIn2(SmsConfig.PASSWORD);
        confirm.setIn4(id);
        SmsStub.ReplyConfirmResponse res = sms.replyConfirm(confirm);
        System.out.println(res.getResult());
        return res.getResult();
    }

    protected static String buildSmsContent(String contentKey, String ... values) {
        String msg = SmsConfig.resb.getString(contentKey);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            msg = msg.replaceFirst("\\{\\?\\}", value);
            ++n2;
        }
        return msg;
    }

    private static String getSerialNumber() {
        return new StringBuffer(SmsConfig.SPCODE).append(System.currentTimeMillis()).append(SmsConfig.resb.getString("serial_number_append")).toString();
    }

    private static void checkPhoneSendLog(String template, List<String> phones, String content) {
        for (String phone : phones) {
            PhoneContentKey contentkey = new PhoneContentKey(phone, content);
            if (smsSendLogMap.containsKey(contentkey) && smsSendLogMap.get(contentkey) >= SmsConfig.SAME_CONTENT_LIMIT) {
                phones.remove(phone);
                continue;
            }
            PhoneTemplateKey templateKey = new PhoneTemplateKey(phone, template);
            if (SmsConfig.EXCEPTION_PHONES.contains(phone)) {
                if (!smsSendLogMap.containsKey(templateKey) || smsSendLogMap.get(templateKey) < SmsConfig.SAME_KEY_WORDS_LIMIT) continue;
                phones.remove(phone);
                continue;
            }
            if (!smsSendLogMap.containsKey(templateKey) || smsSendLogMap.get(templateKey) < SmsConfig.EXCEPTION_KEY_WORDS_LIMIT) continue;
            phones.remove(phone);
        }
    }

    private static void addPhoneSendLog(String template, List<String> phones, String content) {
        for (String phone : phones) {
            PhoneContentKey contentkey = new PhoneContentKey(phone, content);
            PhoneTemplateKey templateKey = new PhoneTemplateKey(phone, template);
            if (smsSendLogMap.containsKey(contentkey)) {
                smsSendLogMap.put(contentkey, smsSendLogMap.get(contentkey) + 1);
            } else {
                smsSendLogMap.put(contentkey, 1);
            }
            if (smsSendLogMap.containsKey(templateKey)) {
                smsSendLogMap.put(templateKey, smsSendLogMap.get(templateKey) + 1);
                continue;
            }
            smsSendLogMap.put(templateKey, 1);
        }
    }

    public static void cleanPhoneSendLog() {
        smsSendLogMap.clear();
    }
}

