package com.bizunited.smsmsg;

import java.io.Serializable;

/**
 * 电话号码，模版key
 * @author bruce.qin
 *
 */
public class PhoneTemplateKey implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = -3997177481481747799L;
	/**电话号码*/
	private String phone;
	/**模版key*/
	private String templateKey;
	
	
	public String getPhone() {
		return phone;
	}
	public void setPhone(String phone) {
		this.phone = phone;
	}
	public String getTemplateKey() {
		return templateKey;
	}
	public void setTemplateKey(String templateKey) {
		this.templateKey = templateKey;
	}
	public PhoneTemplateKey(String phone, String templateKey) {
		super();
		this.phone = phone;
		this.templateKey = templateKey;
	}
	public PhoneTemplateKey() {
		super();
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((phone == null) ? 0 : phone.hashCode());
		result = prime * result
				+ ((templateKey == null) ? 0 : templateKey.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PhoneTemplateKey other = (PhoneTemplateKey) obj;
		if (phone == null) {
			if (other.phone != null)
				return false;
		} else if (!phone.equals(other.phone))
			return false;
		if (templateKey == null) {
			if (other.templateKey != null)
				return false;
		} else if (!templateKey.equals(other.templateKey))
			return false;
		return true;
	}
	
	
}
