package com.bizunited.util;

import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.axis2.AxisFault;
import org.apache.commons.lang.StringUtils;

import com.bizunited.config.SmsConfig;
import com.bizunited.smsmsg.PhoneContentKey;
import com.bizunited.smsmsg.PhoneTemplateKey;
import com.bizunited.smsmsg.SMSReply;
import com.bizunited.smsmsg.SMSReport;
import com.bizunited.smsmsg.SmsStub;
import com.bizunited.smsmsg.SmsStub.ReplyConfirmRequest;
import com.bizunited.smsmsg.SmsStub.ReplyConfirmResponse;
import com.bizunited.smsmsg.SmsStub.Report;
import com.bizunited.smsmsg.SmsStub.Sms;
import com.bizunited.smsmsg.SmsStub.SmsResponse;

public class SmsMessageUtil {

	private SmsMessageUtil(){
		
	}
	
	/**
	 * webService
	 */
	private static SmsStub sms = null;
	
	/**
	 * 发送时间格式化
	 */
	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
	
	/**
	 * 回复时间格式化
	 */
	private static final SimpleDateFormat replaySdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	/**
	 * 记录号码发送记录的map 
	 */
	private static Map<Object,Integer> smsSendLogMap = new HashMap<Object, Integer>();
	
	/**
	 * 初始化webservice
	 */
	static{
		if(sms==null){
			try {
				sms = new SmsStub();
			} catch (AxisFault e) {
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * 立即发送短信 单个发送
	 * @param contentKey smsconfig配置文件的短信模版key
	 * @param phonenum 单个电话号码 
	 * @param sendTime 发送时间
	 * @param values 短信补全占位符信息(按照{?}先后顺序)
	 * @throws Exception
	 */
	public static String sendSMSMsg(String contentKey,String phonenum,String... values) throws Exception{
		return sendSMSMsg(null, contentKey, phonenum, values);
	}
	
	/**
	 * 按时发送短信 单个发送
	 * @param contentKey smsconfig配置文件的短信模版key
	 * @param phonenum 单个电话号码 
	 * @param sendTime 发送时间
	 * @param values 短信补全占位符信息(按照{?}先后顺序)
	 * @throws Exception
	 */
	public static String sendSMSMsg(Date sendTime,String contentKey,String phonenum,String... values) throws Exception{
		List<String> phones = new ArrayList<String>();
		phones.add(phonenum);
		return sendSMSMsg(sendTime, contentKey, phones, values);
	}
	/**
	 * 立即发送短信 批量发送
	 * @param contentKey smsconfig配置文件的短信模版key
	 * @param phonenums 电话号码 最长1000条
	 * @param values 短信补全占位符信息(按照{?}先后顺序)
	 * @throws Exception
	 */
	public static String sendSMSMsg(String contentKey,List<String> phonenums,String... values) throws Exception{
		return sendSMSMsg(null,contentKey, phonenums,values);
	}
	/**
	 * 按时发送短信 批量发送 	--没有同步锁
	 * @param contentKey smsconfig配置文件的短信模版key
	 * @param phonenums 电话号码 最长1000条
	 * @param sendTime 发送时间
	 * @param values 短信补全占位符信息(按照{?}先后顺序)
	 * @throws Exception
	 */
	public static String sendSMSMsg(Date sendTime,String contentKey,List<String> phonenums,String... values) throws Exception{
		Sms sms0 = new Sms();
		sms0.setIn0(SmsConfig.SPCODE);
		sms0.setIn1(SmsConfig.LOGIN_NAME);
		sms0.setIn2(SmsConfig.PASSWORD);
		if(phonenums.size()>1000){
			throw new Exception("电话号码数量过多");
		}
		String content = buildSmsContent(contentKey, values);
		if(content.length()>402){
			throw new Exception("短信内容过长");
		}
		if(SmsConfig.CLEAN_SEND_LOG)
			checkPhoneSendLog(contentKey, phonenums, content);
		sms0.setIn3(content);
		sms0.setIn4(StringUtils.join(phonenums, ","));
		if(sendTime!=null){
			sms0.setIn6(sdf.format(sendTime));
		}else{
			sms0.setIn6("");
		}
		//流水号
		sms0.setIn5(getSerialNumber());
		sms0.setIn7("1");
		SmsResponse res =  sms.sms(sms0);
		String result = res.getOut();
		if(SmsConfig.CLEAN_SEND_LOG&&result.indexOf("result=0")!=-1)
			addPhoneSendLog(contentKey, phonenums, content);
		return result;
	}
	
	/**
	 * 获取发送回执
	 * @return
	 * @throws RemoteException 
	 */
	public static List<SMSReport> getReport() throws RemoteException{
		List<SMSReport> reports = new ArrayList<SMSReport>();
		Report report = new Report();
		report.setIn0(SmsConfig.SPCODE);
		report.setIn1(SmsConfig.LOGIN_NAME);
		report.setIn2(SmsConfig.PASSWORD);
		String info = sms.report(report).getOut();
		if(StringUtils.isNotEmpty(info)){
			for(String str : info.split(";")){
				String[] re = str.split(",");
				reports.add(new SMSReport(re[0], re[1], re[2]));
			}
		}
		return reports;	
	}
	
	/**
	 * 获取回复信息，建议保存到共用数据库，因为有回复确认接口，得以保证是获取到最新的回复信息。
	 * 如果多个项目调用此方法，没有保存到数据库或者保存到不是公共的数据库，将不能有效的获取回复信息，
	 * 所以建议将回复信息保存在统一的公用的数据库
	 * @return	回复信息集合
	 * @throws RemoteException
	 * @throws ParseException
	 */
	public static Set<SMSReply>getReplyInfo() throws RemoteException, ParseException{
		return getReplyInfo(new HashSet<SMSReply>());
	}
	
	/**
	 * 获取回复信息递归方法
	 * @param smsreplay 
	 * @return
	 * @throws RemoteException
	 * @throws ParseException
	 */
	private static Set<SMSReply> getReplyInfo(Set<SMSReply> smsreplay) throws RemoteException, ParseException{
		 SmsStub.ReplyRequest replyRequest = new SmsStub.ReplyRequest();
		 replyRequest.setIn0(SmsConfig.SPCODE);//企业编号
		 replyRequest.setIn1(SmsConfig.LOGIN_NAME);//登录名
		 replyRequest.setIn2(SmsConfig.PASSWORD);//密码
		 SmsStub.ReplyResponse resp1 = sms.reply(replyRequest);
		 String lastId = resp1.getId();//最后一条回复信息ID
		 SmsStub.Reply[] replys = resp1.getReplys();
		 if(replys!=null&&replys.length>0){
			 for(SmsStub.Reply reply : replys){
				 smsreplay.add(new SMSReply(reply.getCallMdn(), reply.getMdn(), reply.getContent(), replaySdf.parse(reply.getReply_time())));
			 }
			 replyConfirm(lastId);
			 return getReplyInfo(smsreplay);
		 }else{
			 return smsreplay;
		 }
	}
	
	/**
	 *	确认上行回复接口 
	 * @param id 最后回复信息的id
	 * @return
	 * @throws RemoteException
	 */
	private static String replyConfirm(String id) throws RemoteException{
		ReplyConfirmRequest confirm = new ReplyConfirmRequest();
		confirm.setIn0(SmsConfig.SPCODE);
		confirm.setIn1(SmsConfig.LOGIN_NAME);
		confirm.setIn2(SmsConfig.PASSWORD);
		confirm.setIn4(id);
		ReplyConfirmResponse res = sms.replyConfirm(confirm);
		System.out.println(res.getResult());
		return res.getResult();
	}
	
	/**
	 * 根据smsconfig配置文件的短信模版key和补全信息生成发送内容
	 * @param contentKey	smsconfig配置文件的短信模版key
	 * @param values 		短信补全信息
	 * @return
	 */
	protected static String buildSmsContent(String contentKey,String... values){
		String msg = SmsConfig.resb.getString(contentKey);
		for(String value : values){
			msg = msg.replaceFirst("\\{\\?\\}", value);
		}
		return msg;
	}
	
	/**
	 * 获取流水号 20位数字
	 * @return
	 */
	private static String getSerialNumber(){
		return new StringBuffer(SmsConfig.SPCODE).append(System.currentTimeMillis()).append(SmsConfig.resb.getString("serial_number_append")).toString();
	}
	
	/**
	 * 检测电话短信发送记录
	 * @param template 配置文件模版key
	 * @param phones	电话号码集合
	 * @param content	内容
	 */
	private static void checkPhoneSendLog(String template, List<String> phones, String content){
		for(String phone : phones){
			PhoneContentKey contentkey = new PhoneContentKey(phone, content);
			if(smsSendLogMap.containsKey(contentkey)&&smsSendLogMap.get(contentkey)>=SmsConfig.SAME_CONTENT_LIMIT){
				phones.remove(phone);
				continue;
			}
			PhoneTemplateKey templateKey = new PhoneTemplateKey(phone, template);
			if(SmsConfig.EXCEPTION_PHONES.contains(phone)){
				if(smsSendLogMap.containsKey(templateKey)&&smsSendLogMap.get(templateKey)>=SmsConfig.SAME_KEY_WORDS_LIMIT){
					phones.remove(phone);
				}
			}else{
				if(smsSendLogMap.containsKey(templateKey)&&smsSendLogMap.get(templateKey)>=SmsConfig.EXCEPTION_KEY_WORDS_LIMIT){
					phones.remove(phone);
				}
			}
		}
	}
	
	/**
	 * 添加电话短信发送记录
	 * @param template 配置文件模版key
	 * @param phones	电话号码集合
	 * @param content	内容
	 */
	private static void addPhoneSendLog(String template, List<String> phones, String content){
		for(String phone : phones){
			PhoneContentKey contentkey = new PhoneContentKey(phone, content);
			PhoneTemplateKey templateKey = new PhoneTemplateKey(phone, template);
			if(smsSendLogMap.containsKey(contentkey)){
				smsSendLogMap.put(contentkey, smsSendLogMap.get(contentkey)+1);
			}else{
				smsSendLogMap.put(contentkey, 1);
			}
			if(smsSendLogMap.containsKey(templateKey)){
				smsSendLogMap.put(templateKey, smsSendLogMap.get(templateKey)+1);
			}else{
				smsSendLogMap.put(templateKey, 1);
			}
		}
	}
	
	/**
	 * 清空短信发送记录，需要spring每天凌晨定时调用此方法
	 */
	public static void cleanPhoneSendLog(){
		smsSendLogMap.clear();
	}
}
