/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.test;

import com.esms.MessageData;
import com.esms.PostMsg;
import com.esms.common.entity.Account;
import com.esms.common.entity.GsmsResponse;
import com.esms.common.entity.MTPack;
import com.esms.common.entity.MTReport;
import com.esms.common.entity.MTResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class PostMsgSpeedTest {
    private static AtomicLong totalReqCount = new AtomicLong(0L);
    private static AtomicLong totalSpendTime = new AtomicLong(0L);
    private static AtomicLong totalMsgCount = new AtomicLong(0L);
    private static int perPackSize = 1;
    private static int perGetSize = 500;
    private static int findMethod = 0;
    private static String[] phoneHeads = new String[]{"180", "135", "186"};
    private static String content = "\u6027\u80fd\u6d4b\u8bd5\u77ed\u4fe1";
    private static int acCount = 0;

    private void detailTest(PostMsg pm, Account ac) throws Exception {
        while (true) {
            this.doSendMsg(pm, ac);
        }
    }

    public void speedTest() throws Exception {
        UUID.randomUUID();
        ExecutorService executor = Executors.newCachedThreadPool();
        List<Account> acs = this.getAccounts();
        for (final Account ac : acs) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    PostMsg pm = new PostMsg();
                    pm.getCmHost().setHost("192.168.0.20", 8080);
                    pm.getWsHost().setHost("192.168.0.20", 8088);
                    try {
                        PostMsgSpeedTest.this.detailTest(pm, ac);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long reqCount = totalReqCount.get();
                    long spendTime = totalSpendTime.get();
                    long msgCount = totalMsgCount.get();
                    if (reqCount > 0L) {
                        System.out.println("\u7528\u6237\u6570:" + acCount + ", \u603b\u8bf7\u6c42\u6570:" + reqCount + ", \u5e73\u5747\u54cd\u5e94(ms):" + spendTime / reqCount + ", \u603b\u8bb0\u5f55\u6570:" + msgCount);
                        continue;
                    }
                    System.out.println("\u603b\u8bf7\u6c42\u6570:" + reqCount + "\t\u5e73\u5747\u54cd\u5e94(ms):" + 0);
                }
            }
        });
        Thread.sleep(60000L);
    }

    private List<Account> getAccounts() {
        ArrayList<Account> acs = new ArrayList<Account>();
        acCount = acs.size();
        return acs;
    }

    private List<UUID> getBatchIDs() {
        ArrayList<UUID> batchIDs = new ArrayList<UUID>();
        batchIDs.add(UUID.fromString("00cf9673-c8c8-48e4-904c-081f6f73ed61"));
        return batchIDs;
    }

    private void doFindResp(PostMsg pm, Account ac, UUID batchID) throws Exception {
        MTResponse[] resps;
        long startTime = 0L;
        int pageIndex = 0;
        do {
            startTime = System.currentTimeMillis();
            resps = pm.findResps(ac, pageIndex, batchID, "", findMethod);
            totalSpendTime.addAndGet(System.currentTimeMillis() - startTime);
            totalReqCount.incrementAndGet();
            if (resps != null && resps.length > 0) {
                totalMsgCount.addAndGet(resps.length);
            }
            ++pageIndex;
        } while (resps != null && resps.length == 100);
    }

    private void doFindReport(PostMsg pm, Account ac, UUID batchID) throws Exception {
        MTReport[] reports;
        long startTime = 0L;
        int pageIndex = 0;
        do {
            startTime = System.currentTimeMillis();
            reports = pm.findReports(ac, pageIndex, batchID, "", findMethod);
            totalSpendTime.addAndGet(System.currentTimeMillis() - startTime);
            totalReqCount.incrementAndGet();
            if (reports != null && reports.length > 0) {
                totalMsgCount.addAndGet(reports.length);
            }
            ++pageIndex;
        } while (reports != null && reports.length == 100);
    }

    private void doGetResp(PostMsg pm, Account ac) throws Exception {
        MTResponse[] resps;
        long startTime = 0L;
        do {
            startTime = System.currentTimeMillis();
            resps = pm.getResps(ac, perGetSize);
            totalSpendTime.addAndGet(System.currentTimeMillis() - startTime);
            totalReqCount.incrementAndGet();
            if (resps == null || resps.length <= 0) continue;
            totalMsgCount.addAndGet(resps.length);
        } while (resps != null && resps.length == perGetSize);
    }

    private void doGetReport(PostMsg pm, Account ac) throws Exception {
        MTReport[] reports;
        long startTime = 0L;
        do {
            startTime = System.currentTimeMillis();
            reports = pm.getReports(ac, perGetSize);
            totalSpendTime.addAndGet(System.currentTimeMillis() - startTime);
            totalReqCount.incrementAndGet();
            if (reports == null || reports.length <= 0) continue;
            totalMsgCount.addAndGet(reports.length);
        } while (reports != null && reports.length == perGetSize);
    }

    private void doSendMsg(PostMsg pm, Account ac) throws Exception {
        UUID uuid = UUID.randomUUID();
        MTPack pack = this.getPack(true, phoneHeads, perPackSize, uuid);
        long startTime = System.currentTimeMillis();
        GsmsResponse resp = pm.post(ac, pack);
        if (resp != null && resp.getResult() == 0) {
            totalMsgCount.addAndGet(pack.getMsgs().size());
        }
        totalSpendTime.addAndGet(System.currentTimeMillis() - startTime);
        totalReqCount.incrementAndGet();
    }

    private MTPack getPack(boolean isMass, String[] phoneHeads, int msgCount, UUID batchID) {
        MTPack pack = new MTPack();
        pack.setBatchID(batchID);
        pack.setMsgType(MTPack.MsgType.SMS);
        pack.setSendType(isMass ? MTPack.SendType.MASS : MTPack.SendType.GROUP);
        pack.setBizType(1);
        pack.setMsgs(this.msgsGen(isMass, phoneHeads, msgCount));
        return pack;
    }

    private List<MessageData> msgsGen(boolean isMass, String[] phoneHeads, int msgCount) {
        ArrayList<MessageData> msgs = new ArrayList<MessageData>();
        if (msgCount < 1) {
            return msgs;
        }
        int headSize = phoneHeads.length;
        int init = 10000000;
        int i = 0;
        while (i < msgCount) {
            msgs.add(new MessageData(String.valueOf(phoneHeads[i % headSize]) + (init + i), isMass ? content : String.valueOf(content) + i));
            ++i;
        }
        return msgs;
    }

    private String getSms(int length) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length) {
            sb.append(i % 10);
            ++i;
        }
        return sb.toString();
    }
}

