/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.common;

import cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class PKCS7AttachSourceFile
extends ASN1Primitive {
    private static final long MAX_FILE_LENGTH = 0x7D000000L;
    private File file;
    private long fileLength;

    public PKCS7AttachSourceFile() {
    }

    public static PKCS7AttachSourceFile getInstance(Object obj) {
        if (obj != null && obj instanceof PKCS7AttachSourceFile) {
            return (PKCS7AttachSourceFile)obj;
        }
        return null;
    }

    public PKCS7AttachSourceFile(File file) {
        this.file = file;
        this.fileLength = file.length();
    }

    public int hashCode() {
        return 0;
    }

    public boolean isConstructed() {
        return false;
    }

    public int encodedLength() throws IOException {
        return 1 + StreamUtil.calculateBodyLength((int)this.fileLength) + (int)this.fileLength;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encode(ASN1OutputStream out) {
        if (this.fileLength < 0L) {
            throw new SecurityException("PKCS7AttachSourceFile sign failed: fileLength < 0");
        }
        if (this.fileLength > 0x7D000000L) {
            throw new SecurityException("PKCS7AttachSourceFile sign failed: fileLength > 2097152000");
        }
        int buffersize = 65536;
        FileInputStream fis = null;
        try {
            try {
                out.write(4);
                out.writeLength((int)this.fileLength);
                fis = new FileInputStream(this.file);
                int finishedLength = 0;
                byte[] temp = new byte[65536];
                int len = fis.read(temp);
                while (len != -1) {
                    finishedLength += len;
                    out.write(temp, 0, len);
                    len = fis.read(temp);
                }
                if ((long)finishedLength != this.fileLength) {
                    throw new SecurityException("PKCS7AttachSourceFile sign failed: finishedLength!=fileLength,finishedLength=" + finishedLength + ",fileLength=" + this.fileLength);
                }
                Object var8_9 = null;
                if (fis == null) return;
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SecurityException("PKCS7AttachSourceFile sign failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SecurityException("PKCS7AttachSourceFile sign failed when closed file", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new SecurityException("PKCS7AttachSourceFile sign failed when closed file", e);
        }
        fis.close();
    }

    public boolean asn1Equals(ASN1Primitive o) {
        throw new UnsupportedOperationException("PKCS7AttachSourceFile@asn1Equals");
    }
}

