/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.util;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.system.SecureRandoms;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public final class SymmetricParams {
    private static final Map<String, Integer> MECH_NIDTYPE = new HashMap<String, Integer>(8);
    private static final Map<String, Integer> MECH_BLOCKSIZE = new HashMap<String, Integer>(8);
    private static final Map<String, ASN1ObjectIdentifier> ENVELOPE_MECH_OID = new HashMap<String, ASN1ObjectIdentifier>(16);
    private static final Map<ASN1ObjectIdentifier, String> ENVELOPE_OID_MECH = new HashMap<ASN1ObjectIdentifier, String>(16);
    public final String mechanismType;
    public final int nidType;
    public final byte[] symmetricKey;
    public final byte[] iv;
    public final Mechanism mechanism;
    public final AlgorithmIdentifier algorithmId;

    public static final SymmetricParams build(String mechanismType, byte[] symmetricKey, byte[] iv) {
        return new SymmetricParams(mechanismType, symmetricKey, iv);
    }

    SymmetricParams(String mechanismType, byte[] symmetricKey) {
        this(mechanismType, symmetricKey, null);
    }

    public SymmetricParams(String mechanismType, byte[] symmetricKey, byte[] iv) {
        ASN1ObjectIdentifier oid = ENVELOPE_MECH_OID.get(mechanismType);
        Integer encType = MECH_NIDTYPE.get(mechanismType);
        this.mechanismType = mechanismType;
        this.nidType = encType == null ? 0 : encType;
        this.symmetricKey = symmetricKey;
        this.iv = iv;
        this.mechanism = new Mechanism(mechanismType, iv == null ? null : new CBCParam(iv));
        ASN1Primitive param = iv == null ? DERNull.INSTANCE : new DEROctetString(iv);
        this.algorithmId = oid == null ? null : new AlgorithmIdentifier(oid, param);
    }

    CipherParameters buildCipherParameters(boolean forIV) throws PKIException {
        if (this.symmetricKey == null) {
            throw new PKIException("symmetricBlockEncryptInit symmetricKey required not null!");
        }
        CipherParameters params = null;
        if (forIV) {
            if (this.iv == null) {
                throw new PKIException("symmetricBlockEncryptInit iv required not null!");
            }
            params = new ParametersWithIV(new KeyParameter(this.symmetricKey), this.iv);
        } else {
            params = new KeyParameter(this.symmetricKey);
        }
        return params;
    }

    public static final String getSymmetricAlgorithmName(ASN1ObjectIdentifier symmetricAlgorithm) {
        return ENVELOPE_OID_MECH.get(symmetricAlgorithm);
    }

    public static final ASN1ObjectIdentifier getSymmetricAlgorithmOID(String symmetricAlgorithm) {
        return ENVELOPE_MECH_OID.get(symmetricAlgorithm);
    }

    public static final SymmetricParams generateSecretKey(String symmetricAlgorithm) throws PKIException {
        if (symmetricAlgorithm == null) {
            throw new PKIException("required symmetricAlgorithm");
        }
        ASN1ObjectIdentifier tOID = ENVELOPE_MECH_OID.get(symmetricAlgorithm);
        if (tOID == null) {
            throw new PKIException("invalid [PKCS7Enveloped]symmetricAlgorithm: " + symmetricAlgorithm);
        }
        String contentEncryptionAlg = symmetricAlgorithm.toUpperCase();
        int ivLength = 0;
        int keyLength = 0;
        if (contentEncryptionAlg.indexOf("RC4") != -1) {
            ivLength = 0;
            keyLength = 16;
        } else if (contentEncryptionAlg.indexOf("SM4") != -1) {
            ivLength = contentEncryptionAlg.indexOf("CBC") == -1 ? 0 : 16;
            keyLength = 16;
        } else if (contentEncryptionAlg.indexOf("DESEDE") != -1) {
            ivLength = contentEncryptionAlg.indexOf("CBC") == -1 ? 0 : 8;
            keyLength = 24;
        } else if (contentEncryptionAlg.indexOf("AES") != -1) {
            ivLength = contentEncryptionAlg.indexOf("CBC") == -1 ? 0 : 16;
            keyLength = 32;
        } else {
            throw new PKIException("invalid symmetricAlgorithm: " + symmetricAlgorithm);
        }
        byte[] buffer = new byte[ivLength + keyLength];
        SecureRandom random = SecureRandoms.getInstance().newSecureRandom();
        random.nextBytes(buffer);
        byte[] key = new byte[keyLength];
        System.arraycopy(buffer, 0, key, 0, key.length);
        byte[] iv = null;
        if (ivLength > 0) {
            iv = new byte[ivLength];
            System.arraycopy(buffer, key.length, iv, 0, iv.length);
        }
        return new SymmetricParams(symmetricAlgorithm, key, iv);
    }

    public static final int getBlockSize(String mechanismType) throws PKIException {
        Integer value = MECH_BLOCKSIZE.get(mechanismType);
        if (value == null) {
            throw new PKIException("GetBlockSize@do not support mechanismType=" + mechanismType);
        }
        return value;
    }

    static {
        MECH_NIDTYPE.put("SM4/CBC/PKCS7Padding", 923);
        MECH_NIDTYPE.put("SM4/ECB/PKCS7Padding", 0);
        MECH_NIDTYPE.put("DESede/CBC/PKCS7Padding", 44);
        MECH_NIDTYPE.put("DESede/ECB/PKCS7Padding", 33);
        MECH_NIDTYPE.put("RC4", 5);
        MECH_BLOCKSIZE.put("SM4/CBC/PKCS7Padding", 16);
        MECH_BLOCKSIZE.put("SM4/ECB/PKCS7Padding", 16);
        MECH_BLOCKSIZE.put("AES/CBC/PKCS7Padding", 16);
        MECH_BLOCKSIZE.put("AES/ECB/PKCS7Padding", 16);
        MECH_BLOCKSIZE.put("DESede/CBC/PKCS7Padding", 8);
        MECH_BLOCKSIZE.put("DESede/ECB/PKCS7Padding", 8);
        MECH_BLOCKSIZE.put("RC4", 0);
        ENVELOPE_MECH_OID.put("SM4/CBC/PKCS7Padding", PKCSObjectIdentifiers.SM4_CBC);
        ENVELOPE_MECH_OID.put("SM4/ECB/PKCS7Padding", PKCSObjectIdentifiers.SM4_ECB);
        ENVELOPE_MECH_OID.put("AES/ECB/PKCS7Padding", PKCSObjectIdentifiers.AES_ECB);
        ENVELOPE_MECH_OID.put("AES/CBC/PKCS7Padding", PKCSObjectIdentifiers.AES_CBC);
        ENVELOPE_MECH_OID.put("DESede/CBC/PKCS7Padding", PKCSObjectIdentifiers.des3CBCEncryption);
        ENVELOPE_MECH_OID.put("DESede/ECB/PKCS7Padding", PKCSObjectIdentifiers.des3Encryption);
        ENVELOPE_MECH_OID.put("RC4", PKCSObjectIdentifiers.rc4Encryption);
        ENVELOPE_MECH_OID.put("PBEWithMD5AndDES", PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        ENVELOPE_MECH_OID.put("PBEWithSHA1AndDES", PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        ENVELOPE_MECH_OID.put("PBEWITHSHAAND2-KEYTRIPLEDES-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd2DESCBC);
        ENVELOPE_MECH_OID.put("PBEWITHSHAAND3-KEYTRIPLEDES-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC);
        for (Map.Entry<String, ASN1ObjectIdentifier> value : ENVELOPE_MECH_OID.entrySet()) {
            ENVELOPE_OID_MECH.put(value.getValue(), value.getKey());
        }
    }
}

