/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.envelope;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.algorithm.util.SymmetricParams;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.envelope.FileEncryptedContentInfo;
import cfca.sadk.envelope.FileEncryptedInputStream;
import cfca.sadk.envelope.FileEnvelopedData;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.BEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sadk.org.bouncycastle.gmt.GMTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.gmt.GMTPKCSObjectIdentifiers;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileOutputStream;

public final class EnvelopeEncryptHelper {
    public static final int MAX_ENVELOPE_SOURCE_FILE_LENGTH = 0x7D000000;
    private static final int policy = 0;
    private final ASN1ObjectIdentifier oid_data;
    private final ASN1ObjectIdentifier oid_envelopedData;
    private final ASN1ObjectIdentifier oid_publicKeyEncrypt;
    private final boolean isSM2Envelope;

    public EnvelopeEncryptHelper(boolean isSM2Envelope) {
        if (isSM2Envelope) {
            this.oid_publicKeyEncrypt = GMTPKCSObjectIdentifiers.SM2_pubKey_encrypt;
            this.oid_data = GMTObjectIdentifiers.sm2Data;
            this.oid_envelopedData = GMTObjectIdentifiers.sm2EnvelopedData;
        } else {
            this.oid_publicKeyEncrypt = PKCSObjectIdentifiers.rsaEncryption;
            this.oid_data = PKCSObjectIdentifiers.data;
            this.oid_envelopedData = PKCSObjectIdentifiers.envelopedData;
        }
        this.isSM2Envelope = isSM2Envelope;
    }

    final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        return this.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        return this.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session, 0);
    }

    public final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicy) throws Exception {
        if (receiverCerts == null) {
            throw new PKIException("missing receiverCerts!");
        }
        if (receiverCerts.length > 1) {
            throw new PKIException("receiverCerts more than one cert!");
        }
        this.checkAlgorithm(symmetricAlgorithm, receiverCerts);
        SymmetricParams symmetricParams = SymmetricParams.generateSecretKey(symmetricAlgorithm);
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (int i = 0; i < receiverCerts.length; ++i) {
            recipientInfos.add(this.toRecipientInfo(receiverCerts[i], symmetricParams.symmetricKey, session, recipientPolicy));
        }
        boolean useJNI = session != null && session.useJniNativeOperation();
        byte[] encryptedData = SymmetricHelper.dataEncrypt(useJNI, symmetricParams, sourceData);
        BEROctetString encryptedOctet = new BEROctetString(encryptedData);
        AlgorithmIdentifier algId = symmetricParams.algorithmId;
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(this.oid_data, algId, encryptedOctet);
        EnvelopedData envData = new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), encryptedContentInfo, ASN1Set.getInstance(null));
        ContentInfo contentInfo = new ContentInfo(this.oid_envelopedData, envData);
        byte[] cmsEnvelopedData = ASN1Parser.parseDERObj2Bytes(new CMSEnvelopedData(contentInfo).toASN1Structure());
        return Base64.encode(cmsEnvelopedData);
    }

    final void envelopeFile(String sourceFilePath, String envelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        this.envelopeFile(sourceFilePath, envelopedFilePath, symmetricAlgorithm, receiverCerts, BCSoftLib.INSTANCE(), 0);
    }

    final void envelopeFile(String sourceFilePath, String envelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        this.envelopeFile(sourceFilePath, envelopedFilePath, symmetricAlgorithm, receiverCerts, session, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void envelopeFile(String sourceFilePath, String envelopedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session, int recipientPolicy) throws Exception {
        if (sourceFilePath == null) {
            throw new PKIException("sourceFilePath is null");
        }
        if (receiverCerts == null) {
            throw new PKIException("missing receiverCerts!");
        }
        if (receiverCerts.length > 1) {
            throw new PKIException("receiverCerts more than one cert!");
        }
        this.checkAlgorithm(symmetricAlgorithm, receiverCerts);
        ASN1OutputStream dos = null;
        try {
            try {
                File sourceFile = new File(sourceFilePath);
                if (!sourceFile.exists()) {
                    throw new PKIException("sourceFile is not exists");
                }
                if (!sourceFile.isFile()) {
                    throw new PKIException("sourceFile is not file");
                }
                int maxLength = 0x7D000000;
                if (sourceFile.length() > 0x7D000000L) {
                    throw new PKIException("MEncryptedInputStream@sourceFileLength more than 2097152000");
                }
                SymmetricParams symmetricParams = SymmetricParams.generateSecretKey(symmetricAlgorithm);
                ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
                for (int i = 0; i < receiverCerts.length; ++i) {
                    recipientInfos.add(this.toRecipientInfo(receiverCerts[i], symmetricParams.symmetricKey, session, recipientPolicy));
                }
                AlgorithmIdentifier algId = symmetricParams.algorithmId;
                boolean useJNIFlag = session != null && session.useJniNativeOperation();
                FileEncryptedInputStream encryptStream = new FileEncryptedInputStream(useJNIFlag, sourceFile, symmetricParams.symmetricKey, symmetricParams.mechanism);
                FileEncryptedContentInfo eci = new FileEncryptedContentInfo(this.oid_data, algId, encryptStream);
                FileEnvelopedData enData = new FileEnvelopedData(null, new DERSet(recipientInfos), eci, null);
                ContentInfo contentInfo = new ContentInfo(this.oid_envelopedData, enData);
                File envelopedFile = new File(envelopedFilePath);
                if (!envelopedFile.exists()) {
                    envelopedFile.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(envelopedFile);
                dos = new DEROutputStream(fos);
                ((DEROutputStream)dos).writeObject(contentInfo);
            }
            catch (Exception e) {
                throw new Exception("envelopeFile failed:", e);
            }
            Object var21_22 = null;
            if (dos == null) return;
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            if (dos == null) throw throwable;
            try {
                dos.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new Exception("envelopeFile failed:", e);
            }
        }
        try {}
        catch (Exception e) {
            throw new Exception("envelopeFile failed:", e);
        }
        dos.close();
    }

    private RecipientInfo toRecipientInfo(X509Cert cert, byte[] symmetricKey, Session session, int recipientPolicy) throws Exception {
        AlgorithmIdentifier keyEncAlg;
        Mechanism mechanism;
        byte[] encryptedKey = null;
        if (cert.isSM2Cert()) {
            mechanism = new Mechanism("SM2");
            keyEncAlg = new AlgorithmIdentifier(this.oid_publicKeyEncrypt, DERNull.INSTANCE);
        } else {
            mechanism = new Mechanism("RSA/ECB/PKCS1PADDING");
            keyEncAlg = new AlgorithmIdentifier(new ASN1ObjectIdentifier(cert.getPublicKeyAlgorithmOID()), DERNull.INSTANCE);
        }
        boolean useJNI = session != null && session.useJniNativeOperation();
        encryptedKey = useJNI ? session.encrypt(mechanism, cert.getPublicKey(), symmetricKey) : BCSoftLib.INSTANCE().encrypt(mechanism, cert.getPublicKey(), symmetricKey);
        DEROctetString encKey = new DEROctetString(encryptedKey);
        RecipientIdentifier recipientIdentifier = cert.generateRecipientIdentifier(recipientPolicy);
        KeyTransRecipientInfo ktr = new KeyTransRecipientInfo(recipientIdentifier, keyEncAlg, encKey);
        return new RecipientInfo(ktr);
    }

    private final boolean checkAlgorithm(String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        if (receiverCerts == null || receiverCerts.length < 1) {
            throw new PKIException("receiverCerts is null!");
        }
        boolean isSM2Cert = receiverCerts[0].isSM2Cert();
        if (this.isSM2Envelope && !isSM2Cert) {
            throw new PKIException("receiverCerts[0] required SM2!");
        }
        if (!this.isSM2Envelope && isSM2Cert) {
            throw new PKIException("receiverCerts[0] required RSA!");
        }
        String certType = isSM2Cert ? "SM2" : "RSA";
        for (int i = 1; i < receiverCerts.length; ++i) {
            if (receiverCerts[i] == null || isSM2Cert == receiverCerts[i].isSM2Cert()) continue;
            throw new PKIException("receiverCerts[" + i + "] required " + certType);
        }
        return this.checkSymmetricAlgorithm(symmetricAlgorithm, isSM2Cert);
    }

    private final boolean checkSymmetricAlgorithm(String symmetricAlgorithm, boolean isSM2Cert) throws PKIException {
        boolean isSM4;
        if (symmetricAlgorithm == null) {
            throw new PKIException("symmetricAlgorithm is null!");
        }
        String contentEncryptionAlg = symmetricAlgorithm.toUpperCase();
        boolean bl = isSM4 = contentEncryptionAlg.indexOf("SM4") >= 0;
        if (isSM2Cert && !isSM4) {
            throw new PKIException("symmetricAlgorithm required SM4!");
        }
        if (!isSM2Cert && isSM4) {
            throw new PKIException("symmetricAlgorithm required not SM4!");
        }
        return true;
    }
}

