/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoInfo;
import cfca.sadk.extend.session.CryptoInfoFactory;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.extend.session.ExtendLibHelper;
import cfca.sadk.extend.session.IExtendECC;
import cfca.sadk.extend.session.IExtendRSA;
import cfca.sadk.extend.session.IExtendSM2;
import cfca.sadk.extend.session.bridge.impl.CryptoBridgeImpl;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCard;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardDummy;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACard;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardDummy;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2Card;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardDummy;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.ECCSuportedCurves;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.system.CompatibleAlgorithm;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNIInit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class ExtendLib
implements Session {
    private static final int SM2_MAX_PLAIN_LENGTH = 4096;
    private static final int SM2_MAX_CIPHER_LENGTH = 8320;
    private static final int SM2_MIN_CIPHER_LENGTH = 96;
    private static final int SM2_SIGN_RAW_LENGTH = 64;
    private static final int SM3_HASH_LENGTH = 32;
    private final IExtendSM2 sm2Card;
    private final IExtendRSA rsaCard;
    private final IExtendECC eccCard;
    private final Session softLib;
    private final long warningTimeThreshold;
    private static volatile ExtendLib SINGLETON = null;

    public static Session getSingleton(String cryptoInfoFilePath) throws PKIException {
        try {
            JNIInit.initOpenSSL();
            return ExtendLib.getSingleton(CryptoInfoFactory.buildWithConfigFile(cryptoInfoFilePath));
        }
        catch (CryptoException e) {
            LoggerManager.exceptionLogger.error("ExtendLib build session instance failure: {}", (Object)cryptoInfoFilePath, (Object)e);
            throw new PKIException("ExtendLib build session instance failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("ExtendLib build session instance failure: {}", (Object)cryptoInfoFilePath, (Object)e);
            throw new PKIException("ExtendLib build session instance failure", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Session getSingleton(CryptoInfo cryptoInfo) throws PKIException {
        if (SINGLETON != null) return SINGLETON;
        Class<ExtendLib> clazz = ExtendLib.class;
        synchronized (ExtendLib.class) {
            if (SINGLETON != null) return SINGLETON;
            SADKDebugger.setDebugger();
            ExtendLib manager = new ExtendLib(cryptoInfo);
            LoggerManager.systemLogger.info("ExtendLib build session instance {}", (Object)manager);
            SINGLETON = manager;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SINGLETON;
        }
    }

    private ExtendLib(CryptoInfo cryptoInfo) throws PKIException {
        LoggerManager.systemLogger.info("ExtendLib beginning: {}", (Object)cryptoInfo);
        CryptoInfo cardInfo = cryptoInfo == null ? CryptoInfoFactory.buildDefaultCryptoInfo() : cryptoInfo;
        try {
            CryptoBridgeImpl cryptoAPI = cardInfo.isEnableCard() ? new CryptoBridgeImpl(cardInfo) : null;
            this.sm2Card = cardInfo.isEnableSM2Card() ? new SM2Card(cryptoAPI) : SM2CardDummy.Dummy.INSTANCE;
            this.rsaCard = cardInfo.isEnableRSACard() ? new RSACard(cryptoAPI) : RSACardDummy.Dummy.INSTANCE;
            this.eccCard = cardInfo.isEnableECCCard() ? new ECCCard(cryptoAPI) : ECCCardDummy.Dummy.INSTANCE;
            this.warningTimeThreshold = cardInfo.getWarningLongTimeThreshold();
            this.softLib = BCSoftLib.INSTANCE();
        }
        catch (CryptoException e) {
            LoggerManager.exceptionLogger.error("ExtendLib build failure: {}", (Object)cardInfo, (Object)e);
            throw new PKIException("ExtendLib build failure", e);
        }
    }

    public final Key generateKey(Mechanism mechanism) throws PKIException {
        return this.softLib.generateKey(mechanism);
    }

    public final Key generateKey(Mechanism mechanism, byte[] keyData) throws PKIException {
        return this.softLib.generateKey(mechanism, keyData);
    }

    public final KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        KeyPair keypair;
        long strTime;
        block14: {
            int keyUsage;
            int keyIndex;
            boolean isExport;
            strTime = System.currentTimeMillis();
            LoggerManager.systemLogger.info("generateKeyPair beginning: mechanism={},keyLength={}", (Object)mechanism, (Object)keyLength);
            keypair = null;
            Object param = mechanism.getParam();
            if (param == null) {
                isExport = true;
                keyIndex = -1;
                keyUsage = 0;
            } else if (param instanceof GenKeyAttribute) {
                GenKeyAttribute attr = (GenKeyAttribute)param;
                isExport = attr.isExport;
                keyIndex = attr.keyNum;
                keyUsage = attr.keyUsage;
            } else {
                isExport = true;
                keyIndex = -1;
                keyUsage = 0;
            }
            try {
                if (ExtendLibHelper.isSM2Type(mechanism)) {
                    keypair = this.sm2Card.generateKeyPair(isExport, keyIndex, keyUsage);
                    break block14;
                }
                if (ExtendLibHelper.isECCType(mechanism)) {
                    String curveName = mechanism.getCurveName();
                    ECCCurveId curveId = null;
                    if (curveName == null) {
                        curveId = ECCCurveId.NIST_P256;
                    } else {
                        if (!ECCSuportedCurves.isSupportedCurve(curveName)) {
                            throw new PKIException("generateKeyPair failure with exception: " + curveName + " is not support!");
                        }
                        curveId = ECCCurveId.findECCCurveId(curveName);
                    }
                    keypair = this.eccCard.generateKeyPair(isExport, keyLength, keyUsage, curveId.getCurveId());
                    break block14;
                }
                if (ExtendLibHelper.isRSAType(mechanism)) {
                    keypair = this.rsaCard.generateKeyPair(isExport, keyLength, keyIndex, keyUsage);
                    break block14;
                }
                throw new PKIException("generateKeyPair failure: invalid mechanism=" + mechanism);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("generateKeyPair mechanism={},isExport={},keyLength={},keyIndex={},keyUsage={}", new Object[]{mechanism, isExport, keyLength, keyIndex, keyUsage, e});
                throw new PKIException("generateKeyPair failure", e);
            }
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("generateKeyPair finished, costTime={}", (Object)costTime);
        } else {
            LoggerManager.systemLogger.info("generateKeyPair accomplished, costTime={}", (Object)costTime);
        }
        return keypair;
    }

    public final byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] hashValue) throws PKIException {
        long strTime = System.currentTimeMillis();
        if (LoggerManager.systemLogger.isInfoEnabled()) {
            LoggerManager.systemLogger.info("signByHash beginning: mechanism={},hashValue={}", (Object)mechanism, (Object)DataHelper.dump4KPartData(hashValue));
        }
        byte[] signData = null;
        try {
            if (ExtendLibHelper.isSM2SignType(mechanism)) {
                byte[] sm3HashValue = this.confirmSM3HashValueLength(hashValue);
                signData = this.confirmSM2SignValueLength(this.sm2Card.signByHash(priKey, sm3HashValue));
            } else if (ExtendLibHelper.isECCSignType(mechanism)) {
                signData = this.eccCard.signByHash(priKey, hashValue);
            } else {
                byte[] digestInfoBytes = this.rsaCard.buildDigestInfo(mechanism, hashValue);
                signData = this.rsaCard.signByHash(priKey, digestInfoBytes);
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("signByHash failure: mechanism={},hashValue={}", (Object)mechanism, (Object)DataHelper.dump4KPartData(hashValue));
            throw new PKIException("signByHash failure", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("signByHash finished,mechanism={},hashValue={}, costTime={}", new Object[]{mechanism, DataHelper.dump4KPartData(hashValue), costTime});
        } else {
            LoggerManager.systemLogger.info("signByHash accomplished, costTime={}", (Object)costTime);
        }
        return signData;
    }

    public final boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] hashValue, byte[] signData) throws PKIException {
        long costTime;
        boolean verifyResult;
        long strTime = System.currentTimeMillis();
        if (LoggerManager.systemLogger.isInfoEnabled()) {
            LoggerManager.systemLogger.info("verifyByHash beginning: mechanism={},hashValue={}", (Object)mechanism, (Object)DataHelper.dump4KPartData(hashValue));
        }
        try {
            if (ExtendLibHelper.isSM2SignType(mechanism)) {
                byte[] sm3HashValue = this.confirmSM3HashValueLength(hashValue);
                byte[] sm2SignValue = this.confirmSM2SignWithRawRS(signData);
                verifyResult = this.sm2Card.verifyByHash(pubKey, sm3HashValue, sm2SignValue);
            } else if (ExtendLibHelper.isECCSignType(mechanism)) {
                byte[] signValue = this.buildECCSignValueToASN1(signData);
                verifyResult = this.eccCard.verifyByHash(pubKey, hashValue, signValue);
            } else {
                byte[] digestInfoBytes = this.rsaCard.buildDigestInfo(mechanism, hashValue);
                verifyResult = this.rsaCard.verifyByHash(pubKey, digestInfoBytes, signData);
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verifyByHash failure: mechanism={},hashValue={},signData={}", new Object[]{mechanism, DataHelper.dump4KPartData(hashValue), DataHelper.dump4KPartData(signData)});
            throw new PKIException("verifyByHash failure", e);
        }
        if (!verifyResult) {
            LoggerManager.timeoutLogger.error("verifyByHash failure,mechanism={},hashValue={},signData={},verifyResult={} ", new Object[]{mechanism, DataHelper.dump4KPartData(hashValue), DataHelper.dump4KPartData(signData), verifyResult});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("verifyByHash finished,mechanism={},hashValue={},signData={}, costTime={}", new Object[]{mechanism, DataHelper.dump4KPartData(hashValue), DataHelper.dump4KPartData(signData), costTime});
        } else {
            LoggerManager.systemLogger.info("verifyByHash accomplished, costTime={},verifyResult={}", (Object)costTime, (Object)verifyResult);
        }
        return verifyResult;
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        int sourceDataLength = DataHelper.dataLength(sourceData);
        long strTime = System.currentTimeMillis();
        if (LoggerManager.systemLogger.isInfoEnabled()) {
            LoggerManager.systemLogger.info("signMessage beginning: mechanism={},sourceDataLength={}", (Object)mechanism, (Object)sourceDataLength);
        }
        byte[] signData = null;
        try {
            if (ExtendLibHelper.isSM2SignType(mechanism)) {
                GMTKey cardKey = this.buildSM2PrivateKey(priKey);
                byte[] sm3HashValue = this.confirmSM3HashValueLength(this.sm2Card.sm3(cardKey, sourceData));
                signData = this.confirmSM2SignValueLength(this.sm2Card.signByHash((PrivateKey)((Object)cardKey), sm3HashValue));
            } else if (ExtendLibHelper.isRSASignType(mechanism)) {
                byte[] digestInfoBytes = this.rsaCard.hashDigestInfo(mechanism, sourceData);
                signData = this.rsaCard.signByHash(priKey, digestInfoBytes);
            } else {
                byte[] hashValue = this.eccCard.hash(mechanism, sourceData);
                signData = this.eccCard.signByHash(priKey, hashValue);
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("signMessage failure: mechanism={},sourceDataLength={}", (Object)mechanism, (Object)sourceDataLength);
            throw new PKIException("sign failure", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("signMessage finished,mechanism={},sourceDataLength={}, costTime={}", new Object[]{mechanism, sourceDataLength, costTime});
        } else {
            LoggerManager.systemLogger.info("signMessage accomplished, costTime={}", (Object)costTime);
        }
        return signData;
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        int sourceStreamLength = DataHelper.dataLength(sourceStream);
        long strTime = System.currentTimeMillis();
        if (LoggerManager.systemLogger.isInfoEnabled()) {
            LoggerManager.systemLogger.info("signStream beginning: mechanism={},sourceStreamLength={}", (Object)mechanism, (Object)sourceStreamLength);
        }
        byte[] signData = null;
        try {
            if (ExtendLibHelper.isSM2SignType(mechanism)) {
                GMTKey cardKey = this.buildSM2PrivateKey(priKey);
                byte[] sm3HashValue = this.confirmSM3HashValueLength(this.sm2Card.sm3(cardKey, sourceStream));
                signData = this.confirmSM2SignValueLength(this.sm2Card.signByHash((PrivateKey)((Object)cardKey), sm3HashValue));
            } else if (ExtendLibHelper.isRSASignType(mechanism)) {
                byte[] digestInfoBytes = this.rsaCard.hashDigestInfo(mechanism, sourceStream);
                signData = this.rsaCard.signByHash(priKey, digestInfoBytes);
            } else {
                byte[] hashValue = this.eccCard.hash(mechanism, sourceStream);
                signData = this.eccCard.signByHash(priKey, hashValue);
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("signStream failure: mechanism={},sourceStreamLength={}", (Object)mechanism, (Object)sourceStreamLength);
            throw new PKIException("signStream failure", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("signStream finished,mechanism={},sourceStreamLength={}, costTime={}", new Object[]{mechanism, sourceStreamLength, costTime});
        } else {
            LoggerManager.systemLogger.info("signStream accomplished, costTime={}", (Object)costTime);
        }
        return signData;
    }

    public final boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        long costTime;
        boolean verifyResult;
        int sourceDataLength = DataHelper.dataLength(sourceData);
        long strTime = System.currentTimeMillis();
        if (LoggerManager.systemLogger.isInfoEnabled()) {
            LoggerManager.systemLogger.info("verifyMessage beginning: mechanism={},sourceDataLength={}", (Object)mechanism, (Object)sourceDataLength);
        }
        try {
            if (ExtendLibHelper.isSM2SignType(mechanism)) {
                GMTKey cardKey = this.buildSM2PublicKey(pubKey);
                byte[] sm2SignValue = this.confirmSM2SignWithRawRS(signData);
                byte[] sm3HashValue = this.confirmSM3HashValueLength(this.sm2Card.sm3(cardKey, sourceData));
                verifyResult = this.sm2Card.verifyByHash((PublicKey)((Object)cardKey), sm3HashValue, sm2SignValue);
                boolean compatibleWithoutZ = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                if (compatibleWithoutZ && !verifyResult) {
                    byte[] sm3HashWithoutZ = this.confirmSM3HashValueLength(this.sm2Card.sm3(null, sourceData));
                    verifyResult = this.sm2Card.verifyByHash(pubKey, sm3HashWithoutZ, sm2SignValue);
                }
            } else if (ExtendLibHelper.isECCSignType(mechanism)) {
                byte[] hashValue = this.eccCard.hash(mechanism, sourceData);
                byte[] signValue = this.buildECCSignValueToASN1(signData);
                verifyResult = this.eccCard.verifyByHash(pubKey, hashValue, signValue);
            } else {
                byte[] digestInfoBytes = this.rsaCard.hashDigestInfo(mechanism, sourceData);
                verifyResult = this.rsaCard.verifyByHash(pubKey, digestInfoBytes, signData);
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verifyMessage failure: mechanism={},sourceDataLength={},signData={}", new Object[]{mechanism, sourceDataLength, DataHelper.dump4KPartData(signData)});
            throw new PKIException("verifyMessage failure", e);
        }
        if (!verifyResult) {
            LoggerManager.timeoutLogger.error("verifyMessage failure,mechanism={},sourceDataLength={},signData={},verifyResult={}", new Object[]{mechanism, sourceDataLength, DataHelper.dump4KPartData(signData), verifyResult});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("verifyMessage finished,mechanism={},sourceDataLength={},signData={}, costTime={}", new Object[]{mechanism, sourceDataLength, DataHelper.dump4KPartData(signData), costTime});
        } else {
            LoggerManager.systemLogger.info("verifyMessage accomplished, costTime={}", (Object)costTime);
        }
        return verifyResult;
    }

    public final boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        long costTime;
        boolean verifyResult;
        int sourceStreamLength = DataHelper.dataLength(sourceStream);
        long strTime = System.currentTimeMillis();
        if (LoggerManager.systemLogger.isInfoEnabled()) {
            LoggerManager.systemLogger.info("verifyStream beginning: mechanism={},sourceStreamLength={}", (Object)mechanism, (Object)sourceStreamLength);
        }
        try {
            if (ExtendLibHelper.isSM2SignType(mechanism)) {
                GMTKey cardKey = this.buildSM2PublicKey(pubKey);
                byte[] sm2SignValue = this.confirmSM2SignWithRawRS(signData);
                byte[] sm3HashValue = this.confirmSM3HashValueLength(this.sm2Card.sm3(cardKey, sourceStream));
                verifyResult = this.sm2Card.verifyByHash((PublicKey)((Object)cardKey), sm3HashValue, sm2SignValue);
                boolean compatibleWithoutZ = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                if (compatibleWithoutZ && !verifyResult) {
                    byte[] sm3HashWithoutZ = this.confirmSM3HashValueLength(this.sm2Card.sm3(null, sourceStream));
                    verifyResult = this.sm2Card.verifyByHash(pubKey, sm3HashWithoutZ, sm2SignValue);
                }
            } else if (ExtendLibHelper.isECCSignType(mechanism)) {
                byte[] hashValue = this.eccCard.hash(mechanism, sourceStream);
                byte[] signValue = this.buildECCSignValueToASN1(signData);
                verifyResult = this.eccCard.verifyByHash(pubKey, hashValue, signValue);
            } else {
                byte[] digestInfoBytes = this.rsaCard.hashDigestInfo(mechanism, sourceStream);
                verifyResult = this.rsaCard.verifyByHash(pubKey, digestInfoBytes, signData);
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verifyStream failure: mechanism={},sourceStreamLength={},signData={}", new Object[]{mechanism, sourceStreamLength, DataHelper.dump4KPartData(signData)});
            throw new PKIException("verifyStream failure", e);
        }
        if (!verifyResult) {
            LoggerManager.timeoutLogger.error("verifyStream failure,mechanism={},sourceStreamLength={},signData={},verifyResult={}", new Object[]{mechanism, sourceStreamLength, DataHelper.dump4KPartData(signData), verifyResult});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("verifyStream finished,mechanism={},sourceStreamLength={},signData={}, costTime={}", new Object[]{mechanism, sourceStreamLength, DataHelper.dump4KPartData(signData), costTime});
        } else {
            LoggerManager.systemLogger.info("verifyStream accomplished, costTime={}", (Object)costTime);
        }
        return verifyResult;
    }

    private GMTKey buildSM2PrivateKey(PrivateKey priKey) throws CryptoException {
        if (priKey == null) {
            throw new CryptoException("buildSM2PrivateKey failed: priKey is null");
        }
        GMTKey cardKey = null;
        if (priKey instanceof GMTKey) {
            cardKey = (GMTKey)((Object)priKey);
        } else {
            try {
                cardKey = new SM2PrivateKey(priKey.getEncoded());
            }
            catch (Exception e) {
                throw new CryptoException("buildSM2PrivateKey failed: encoding is invalid SM2PrivateKey", e);
            }
        }
        return cardKey;
    }

    private GMTKey buildSM2PublicKey(PublicKey pubKey) throws CryptoException {
        if (pubKey == null) {
            throw new CryptoException("buildSM2PublicKey failed with pubKey is null");
        }
        GMTKey cardKey = null;
        if (pubKey instanceof GMTKey) {
            cardKey = (GMTKey)((Object)pubKey);
        } else {
            try {
                cardKey = new SM2PublicKey(pubKey.getEncoded());
            }
            catch (Exception e) {
                throw new CryptoException("buildSM2PublicKey failed: encoding is invalid SM2PublicKey", e);
            }
        }
        return cardKey;
    }

    private byte[] buildECCSignValueToASN1(byte[] signData) throws CryptoException {
        if (signData == null) {
            throw new CryptoException("buildECCSignData failed with signData is null");
        }
        byte[] asn1SignData = null;
        int rsLength = 64;
        if (signData.length == 64) {
            try {
                int rLength = 32;
                ASN1Integer rInt = new ASN1Integer(Arrays.copyOfRange(signData, 0, 32));
                ASN1Integer sInt = new ASN1Integer(Arrays.copyOfRange(signData, 32, 64));
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add(rInt.formatToPositive(32));
                v.add(sInt.formatToPositive(32));
                DERSequence asn1 = new DERSequence(v);
                asn1SignData = asn1.getEncoded("DER");
            }
            catch (IOException e) {
                throw new CryptoException("buildECCSignData failed", e);
            }
        } else {
            asn1SignData = signData;
        }
        return asn1SignData;
    }

    public final byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        int sourceDataLength = DataHelper.dataLength(sourceData);
        long strTime = System.currentTimeMillis();
        if (LoggerManager.systemLogger.isInfoEnabled()) {
            LoggerManager.systemLogger.info("encryptMessage beginning: mechanism={},sourceDataLength={}", (Object)mechanism, (Object)sourceDataLength);
        }
        byte[] encryptData = null;
        try {
            if (ExtendLibHelper.isSM2EncryptType(mechanism)) {
                if (!(key instanceof PublicKey)) {
                    throw new PKIException("encryptMessage failure: required PublicKey");
                }
                encryptData = this.confirmSM2EncryptDataLength(this.sm2Card.encrypt((PublicKey)key, sourceData), sourceData);
            } else if (ExtendLibHelper.isRSAEncryptType(mechanism)) {
                if (!(key instanceof RSAPublicKey)) {
                    throw new PKIException("encryptMessage failure: required RSAPublicKey");
                }
                encryptData = this.rsaCard.encrypt((RSAPublicKey)key, sourceData);
            } else {
                if (ExtendLibHelper.isECCEncryptType(mechanism)) {
                    throw new PKIException("encryptMessage failure: do not support ECC");
                }
                encryptData = this.softLib.encrypt(mechanism, key, sourceData);
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encryptMessage failure: mechanism={},sourceDataLength={},sourceData={}", new Object[]{mechanism, sourceDataLength, DataHelper.dump4KPartData(sourceData)});
            throw new PKIException("encryptMessage failure", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("encryptMessage finished,mechanism={},sourceDataLength={},sourceData={},costTime={}", new Object[]{mechanism, sourceDataLength, DataHelper.dump4KPartData(sourceData), costTime});
        } else {
            LoggerManager.systemLogger.info("encryptMessage accomplished, costTime={}", (Object)costTime);
        }
        return encryptData;
    }

    public final byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        int encryptDataLength = DataHelper.dataLength(encryptData);
        long strTime = System.currentTimeMillis();
        if (LoggerManager.systemLogger.isInfoEnabled()) {
            LoggerManager.systemLogger.info("decryptMessage beginning: mechanism={},encryptDataLength={}", (Object)mechanism, (Object)encryptDataLength);
        }
        byte[] decryptData = null;
        try {
            if (ExtendLibHelper.isSM2EncryptType(mechanism)) {
                if (!(key instanceof PrivateKey)) {
                    throw new PKIException("decryptMessage failure: required PrivateKey");
                }
                decryptData = this.trySM2Decrypt(mechanism, (PrivateKey)key, encryptData);
            } else if (ExtendLibHelper.isRSAEncryptType(mechanism)) {
                if (!(key instanceof RSAPrivateKey)) {
                    throw new PKIException("decryptMessage failure: required RSAPrivateKey");
                }
                decryptData = this.rsaCard.decrypt((RSAPrivateKey)key, encryptData);
            } else {
                if (ExtendLibHelper.isECCEncryptType(mechanism)) {
                    throw new PKIException("decryptMessage failure: do not support ECC");
                }
                decryptData = this.softLib.decrypt(mechanism, key, encryptData);
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("decryptMessage failure: mechanism={},encryptDataLength={},encryptData={}", new Object[]{mechanism, encryptDataLength, DataHelper.dump4KPartData(encryptData)});
            throw new PKIException("decryptMessage failure", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("decryptMessage finished,mechanism={},encryptDataLength={},encryptData={},costTime={}", new Object[]{mechanism, encryptDataLength, DataHelper.dump4KPartData(encryptData), costTime});
        } else {
            LoggerManager.systemLogger.info("decryptMessage accomplished, costTime={}", (Object)costTime);
        }
        return decryptData;
    }

    public final void encrypt(Mechanism mechanism, Key key, InputStream sourceStream, OutputStream out) throws PKIException {
        long strTime;
        int sourceStreamLength;
        block13: {
            sourceStreamLength = DataHelper.dataLength(sourceStream);
            strTime = System.currentTimeMillis();
            if (LoggerManager.systemLogger.isInfoEnabled()) {
                LoggerManager.systemLogger.info("encryptStream beginning: mechanism={},sourceStreamLength={}", (Object)mechanism, (Object)sourceStreamLength);
            }
            try {
                byte[] sourceData;
                if (ExtendLibHelper.isSM2EncryptType(mechanism)) {
                    if (!(key instanceof PublicKey)) {
                        throw new PKIException("encryptStream failure: required PublicKey");
                    }
                    sourceData = this.readSM2PlainData(sourceStream);
                    byte[] encryptData = this.confirmSM2EncryptDataLength(this.sm2Card.encrypt((PublicKey)key, sourceData), sourceData);
                    try {
                        out.write(encryptData, 0, encryptData.length);
                        break block13;
                    }
                    catch (Exception e) {
                        throw new PKIException("encryptStream stream failure: file write error", e);
                    }
                }
                if (ExtendLibHelper.isRSAEncryptType(mechanism)) {
                    if (!(key instanceof RSAPublicKey)) {
                        throw new PKIException("encryptStream failure: required RSAPublicKey");
                    }
                    sourceData = FileHelper.read(sourceStream);
                    byte[] encryptData = this.rsaCard.encrypt((RSAPublicKey)key, sourceData);
                    out.write(encryptData, 0, encryptData.length);
                } else {
                    if (ExtendLibHelper.isECCEncryptType(mechanism)) {
                        throw new PKIException("encryptStream failure: do not support ECC");
                    }
                    this.softLib.encrypt(mechanism, key, sourceStream, out);
                }
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("encryptStream failure: mechanism={},sourceStreamLength={}", (Object)mechanism, (Object)sourceStreamLength);
                throw new PKIException("encryptStream failure", e);
            }
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("encryptStream finished,mechanism={},sourceStreamLength={},costTime={}", new Object[]{mechanism, sourceStreamLength, costTime});
        } else {
            LoggerManager.systemLogger.info("encryptStream accomplished, costTime={}", (Object)costTime);
        }
    }

    public final void decrypt(Mechanism mechanism, Key key, InputStream encryptStream, OutputStream out) throws PKIException {
        long strTime;
        int encryptStreamLength;
        block13: {
            encryptStreamLength = DataHelper.dataLength(encryptStream);
            strTime = System.currentTimeMillis();
            if (LoggerManager.systemLogger.isInfoEnabled()) {
                LoggerManager.systemLogger.info("decryptStream beginning: mechanism={},encryptStreamLength={}", (Object)mechanism, (Object)encryptStreamLength);
            }
            try {
                byte[] encryptData;
                if (ExtendLibHelper.isSM2EncryptType(mechanism)) {
                    if (!(key instanceof PrivateKey)) {
                        throw new PKIException("decryptStream failure: required PrivateKey");
                    }
                    encryptData = this.readSM2CipherData(encryptStream);
                    byte[] decryptData = this.trySM2Decrypt(mechanism, (PrivateKey)key, encryptData);
                    try {
                        out.write(decryptData, 0, decryptData.length);
                        break block13;
                    }
                    catch (Exception e) {
                        throw new PKIException("decryptStream stream failure: file write error", e);
                    }
                }
                if (ExtendLibHelper.isRSAEncryptType(mechanism)) {
                    if (!(key instanceof RSAPrivateKey)) {
                        throw new PKIException("decryptStream failure: required RSAPrivateKey");
                    }
                    encryptData = FileHelper.read(encryptStream);
                    byte[] decryptData = this.rsaCard.decrypt((RSAPrivateKey)key, encryptData);
                    out.write(decryptData, 0, decryptData.length);
                } else {
                    if (ExtendLibHelper.isECCEncryptType(mechanism)) {
                        throw new PKIException("decryptStream failure: do not support ECC");
                    }
                    this.softLib.decrypt(mechanism, key, encryptStream, out);
                }
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("decryptStream failure: mechanism={},encryptStreamLength={}", (Object)mechanism, (Object)encryptStreamLength);
                throw new PKIException("decryptStream failure", e);
            }
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("decryptStream finished,mechanism={},encryptStreamLength={},costTime={}", new Object[]{mechanism, encryptStreamLength, costTime});
        } else {
            LoggerManager.systemLogger.info("decryptStream accomplished, costTime={}", (Object)costTime);
        }
    }

    public final PublicKey exportEncPublicKey() throws PKIException {
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("exportEncPublicKey beginning");
        PublicKey pubKey = null;
        try {
            pubKey = this.sm2Card.exportSM2ProtectKey();
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("exportEncPublicKey failure", e);
            throw new PKIException("exportEncPublicKey failure", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("exportEncPublicKey finished,costTime={}", (Object)costTime);
        } else {
            LoggerManager.systemLogger.info("exportEncPublicKey accomplished, costTime={}", (Object)costTime);
        }
        return pubKey;
    }

    public final boolean importSM2KeyPair(byte[] encryptKeyData, int keyIndex) throws PKIException {
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("importSM2KeyPair beginning");
        boolean result = false;
        try {
            if (encryptKeyData == null || encryptKeyData.length != 192) {
                throw new PKIException("importSM2KeyPair failure encryptKeyData is not 192 bytes!");
            }
            result = this.sm2Card.importSM2EncryptKeyPair(keyIndex, encryptKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("importSM2KeyPair failure", e);
            throw new PKIException("importSM2KeyPair failure", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("importSM2KeyPair finished,costTime={}", (Object)costTime);
        } else {
            LoggerManager.systemLogger.info("importSM2KeyPair accomplished, costTime={}", (Object)costTime);
        }
        return result;
    }

    public boolean checkIdleTest() throws PKIException {
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("checkIdleTest beginning");
        int chekeyIndexleError = 0;
        try {
            if (this.sm2Card != null && !this.sm2Card.idleTest()) {
                LoggerManager.exceptionLogger.error("checkIdleTest[sm2Card] failure");
                ++chekeyIndexleError;
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("checkIdleTest[sm2Card] failure", e);
            throw new PKIException("checkIdleTest[sm2Card] failure", e);
        }
        try {
            if (this.rsaCard != null && !this.rsaCard.idleTest()) {
                LoggerManager.exceptionLogger.error("checkIdleTest[rsaCard] failure");
                ++chekeyIndexleError;
            }
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("checkIdleTest[rsaCard] failure", e);
            throw new PKIException("checkIdleTest[rsaCard] failure", e);
        }
        long costTime = System.currentTimeMillis() - strTime;
        if (costTime > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("checkIdleTest finished,costTime={}", (Object)costTime);
        } else {
            LoggerManager.systemLogger.info("checkIdleTest accomplished, costTime={}", (Object)costTime);
        }
        return chekeyIndexleError == 0;
    }

    public final Provider getProvider() {
        return this.softLib.getProvider();
    }

    public final String getProviderName() {
        return this.softLib.getProviderName();
    }

    final byte[] trySM2Decrypt(Mechanism mechanism, PrivateKey privateKey, byte[] encryptData) throws PKIException, CryptoException {
        if (encryptData == null || encryptData.length < 96) {
            throw new PKIException("SM2Decrypt Failure with encryptData shortage");
        }
        int cardRAWC1C3C2Format = 4;
        byte[] decryptBytes = null;
        if (ASN1SM2Cipher.isASN1EncryptType(encryptData)) {
            LoggerManager.systemLogger.info("SM2Decrypt::::::::ASN1(C1C3C2): Running");
            byte[] cardEncryptData = new ASN1SM2Cipher(encryptData, 1).getEncryptedBytes(4);
            decryptBytes = this.SM2CardDecrypt(privateKey, cardEncryptData);
            LoggerManager.systemLogger.info("SM2Decrypt::::::::ASN1(C1C3C2): Finished");
        } else {
            try {
                LoggerManager.systemLogger.info("SM2Decrypt:::::::: RAW(C1C3C2): Running");
                byte[] cardEncryptData = encryptData;
                decryptBytes = this.SM2CardDecrypt(privateKey, cardEncryptData);
                LoggerManager.systemLogger.info("SM2Decrypt:::::::: RAW(C1C3C2): Finished");
            }
            catch (Exception e) {
                LoggerManager.systemLogger.info("SM2Decrypt:::::::: RAW(C1C2C3): Running");
                byte[] cardEncryptData = new ASN1SM2Cipher(encryptData, 16).getEncryptedBytes(4);
                decryptBytes = this.SM2CardDecrypt(privateKey, cardEncryptData);
                LoggerManager.systemLogger.info("SM2Decrypt:::::::: RAW(C1C2C3): Finished");
            }
        }
        return decryptBytes;
    }

    final byte[] SM2CardDecrypt(PrivateKey privateKey, byte[] sm2EncryptData) throws PKIException, CryptoException {
        if (sm2EncryptData == null || sm2EncryptData.length < 96) {
            throw new PKIException("SM2Decrypt Failure with sm2EncryptData shortage");
        }
        byte[] decryptBytes = this.sm2Card.decrypt(privateKey, sm2EncryptData);
        return decryptBytes;
    }

    private final byte[] confirmSM3HashValueLength(byte[] sm3HashValue) throws CryptoException {
        if (sm3HashValue == null || sm3HashValue.length == 0) {
            throw new CryptoException("Missing SM3HashValue");
        }
        if (sm3HashValue.length != 32) {
            throw new CryptoException("Require SM3HashValueLength=32");
        }
        return sm3HashValue;
    }

    private final byte[] confirmSM2SignWithRawRS(byte[] sm2SignValue) throws CryptoException {
        if (sm2SignValue == null || sm2SignValue.length == 0) {
            throw new CryptoException("SM2SignValue missing");
        }
        if (sm2SignValue.length < 64) {
            throw new CryptoException("SM2SignValue less than 64");
        }
        byte[] rawRSSignValue = null;
        if (sm2SignValue != null && sm2SignValue.length == 64) {
            rawRSSignValue = sm2SignValue;
        } else if (ASN1SM2Signature.isASN1SignType(sm2SignValue)) {
            ASN1SM2Signature signature = new ASN1SM2Signature(sm2SignValue);
            rawRSSignValue = new byte[64];
            int rsLength = 32;
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, signature.getR().getPositiveValue()), 0, rawRSSignValue, 0, 32);
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, signature.getS().getPositiveValue()), 0, rawRSSignValue, 32, 32);
        } else {
            throw new CryptoException("SM2Signature data is null or neither asn1 nor 64 bytes!");
        }
        return rawRSSignValue;
    }

    private final byte[] confirmSM2SignValueLength(byte[] sm2SignValue) throws CryptoException {
        if (sm2SignValue == null || sm2SignValue.length == 0) {
            throw new CryptoException("SM2SignValue missing");
        }
        if (sm2SignValue.length != 64) {
            throw new CryptoException("SM2SignValue not equal with 64");
        }
        return sm2SignValue;
    }

    private final byte[] confirmSM2EncryptDataLength(byte[] encryptData, byte[] sourceData) throws CryptoException {
        if (sourceData == null || sourceData.length == 0) {
            throw new CryptoException("Missing sourceData");
        }
        if (encryptData == null || encryptData.length == 0) {
            throw new CryptoException("Missing encryptData");
        }
        if (encryptData.length - sourceData.length != 96) {
            throw new CryptoException("Require encryptDataLength-sourceDatalength=96<<<<<<" + encryptData.length + "," + sourceData.length + ">>>>>>");
        }
        ASN1SM2Cipher asn1 = new ASN1SM2Cipher(encryptData, 4);
        byte[] outEncryptData = asn1.getEncryptedBytes(CompatibleConfig.SM2OutputFormatEncryptedBytes);
        return outEncryptData;
    }

    private final byte[] readSM2PlainData(InputStream sourceStream) throws PKIException {
        int rLength;
        byte[] buffer;
        if (sourceStream == null) {
            throw new PKIException("SM2EncryptStream stream failure: sourceStream is null");
        }
        try {
            buffer = new byte[4224];
            rLength = sourceStream.read(buffer);
        }
        catch (Exception e) {
            throw new PKIException("SM2EncryptStream stream failure: stream read error", e);
        }
        if (rLength > 4096) {
            throw new PKIException("SM2EncryptStream stream failure: stream more than 4096");
        }
        byte[] sourceData = new byte[rLength];
        System.arraycopy(buffer, 0, sourceData, 0, sourceData.length);
        return sourceData;
    }

    private final byte[] readSM2CipherData(InputStream encryptStream) throws PKIException {
        int rLength;
        byte[] buffer;
        if (encryptStream == null) {
            throw new PKIException("SM2DecryptStream stream failure: encryptStream is null");
        }
        try {
            buffer = new byte[8448];
            rLength = encryptStream.read(buffer);
        }
        catch (Exception e) {
            throw new PKIException("SM2DecryptStream stream failure: file read error", e);
        }
        if (rLength > 8320) {
            throw new PKIException("SM2DecryptStream stream failure: message more than 8320");
        }
        byte[] encryptData = new byte[rLength];
        System.arraycopy(buffer, 0, encryptData, 0, encryptData.length);
        return encryptData;
    }

    public final String getDeviceName() {
        return "JCARD_LIB";
    }

    public final int getDeviceType() {
        return 3;
    }

    public final boolean useJniNativeOperation() throws PKIException {
        return true;
    }
}

