/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardCurveHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKeyHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardPublicKey;
import cfca.sadk.extend.session.util.Args;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;

public final class ECCCardExternalPrivateKey
extends BCECPrivateKey
implements ECCCardKey {
    private static final long serialVersionUID = 6668848308980508543L;
    private final int curveId;
    private final int bitLength;
    private String pubKeyInfo;
    private final ECCCardPublicKey eccPublicKey;

    public ECCCardExternalPrivateKey(BCECPrivateKey key, int curveId) {
        super("EC", Args.notNull(key, "ECPrivateKey"));
        this.curveId = curveId;
        this.bitLength = ECCCardCurveHelper.bitLength(this.getParameters());
        this.eccPublicKey = this.buildPublicKey(this.getD(), this.getDomainParameters(), curveId);
    }

    public ECCCardExternalPrivateKey(BCECPrivateKey key) throws CryptoException {
        super("EC", Args.notNull(key, "ECPrivateKey"));
        this.curveId = ECCCardCurveHelper.getCurveId(this.getParameters());
        this.bitLength = ECCCardCurveHelper.bitLength(this.getParameters());
        this.eccPublicKey = this.buildPublicKey(this.getD(), this.getDomainParameters(), this.curveId);
    }

    public ECCCardExternalPrivateKey(ECPrivateKeyParameters ecParams, int curveId) {
        super("EC", ecParams, ECCCardCurveHelper.buildECParameterSpec(ecParams));
        this.curveId = curveId;
        this.bitLength = ECCCardCurveHelper.bitLength(ecParams.getParameters());
        this.eccPublicKey = this.buildPublicKey(this.getD(), ecParams.getParameters(), curveId);
    }

    public final boolean isInternalKey() {
        return false;
    }

    public final int getKeyIndex() {
        return 0;
    }

    public int getKeyUsage() {
        return 0;
    }

    public final int modulusBitsLength() {
        return this.bitLength;
    }

    public final int modulusByteLength() {
        return this.bitLength >> 3;
    }

    private final ECDomainParameters getDomainParameters() {
        return ECCCardCurveHelper.buildECDomainParameters(this.getParameters());
    }

    private final ECCCardPublicKey buildPublicKey(BigInteger d, ECDomainParameters params, int curveId) {
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        ECPoint Q = multiplier.multiply(params.getG(), d).normalize();
        return new ECCCardPublicKey(new ECPublicKeyParameters(Q, params), curveId);
    }

    public final ECCCardPublicKey getECCPublicKey() {
        return this.eccPublicKey;
    }

    public final String dumpPublicKey() {
        ECCCardPublicKey pubKey;
        if (this.pubKeyInfo == null && (pubKey = this.getECCPublicKey()) != null) {
            this.pubKeyInfo = ECCCardKeyHelper.dumpPublicKey(pubKey.getPubX(), pubKey.getPubY(), pubKey.getPubH());
        }
        return this.pubKeyInfo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ECCCardExternalPrivateKey [bitLength=").append(this.bitLength);
        builder.append(",curveId=").append(this.curveId);
        builder.append(",isInternalKey=").append(this.isInternalKey());
        builder.append(",pubX=").append(DataHelper.toHexString(this.getPubX()));
        builder.append(",pubY=").append(DataHelper.toHexString(this.getPubY()));
        builder.append(",pubH=").append(DataHelper.toHexString(this.getPubH()));
        builder.append(",md5D=").append(NumberHelper.md5(this.getSecD()));
        builder.append("]");
        return builder.toString();
    }

    public byte[] getPubX() {
        ECCCardPublicKey pubKey = this.getECCPublicKey();
        byte[] pubX = null;
        if (pubKey != null) {
            pubX = pubKey.getPubX();
        }
        return pubX;
    }

    public byte[] getPubY() {
        ECCCardPublicKey pubKey = this.getECCPublicKey();
        byte[] pubY = null;
        if (pubKey != null) {
            pubY = pubKey.getPubY();
        }
        return pubY;
    }

    public byte[] getSecD() {
        ECCCardPublicKey pubKey = this.getECCPublicKey();
        byte[] pubY = null;
        if (pubKey != null) {
            pubY = pubKey.getPubY();
        }
        return pubY;
    }

    public byte[] getPubH() {
        ECCCardPublicKey pubKey = this.getECCPublicKey();
        byte[] pubH = null;
        if (pubKey != null) {
            pubH = pubKey.getPubH();
        }
        return pubH;
    }

    public byte[] keyData() throws CryptoException {
        throw new CryptoException("do not support");
    }
}

