/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardExternalPrivateKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardPublicKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class ECCCardKeyHelper {
    private ECCCardKeyHelper() {
    }

    public static final PublicKey buildPublicKey(PublicKey publicKey) throws CryptoException {
        ECCCardPublicKey pubKey;
        if (publicKey == null) {
            throw new CryptoParameterException("ECCCard buildExternalPublicKey failure with null publicKey");
        }
        if (publicKey instanceof ECCCardPublicKey) {
            pubKey = (ECCCardPublicKey)publicKey;
        } else if (publicKey instanceof BCECPublicKey) {
            pubKey = new ECCCardPublicKey((BCECPublicKey)publicKey);
        } else {
            throw new CryptoException("ECCCard buildExternalPublicKey failure with not support key: " + publicKey.getClass());
        }
        return pubKey;
    }

    public static final PrivateKey buildPrivateKey(PrivateKey privateKey) throws CryptoException {
        ECCCardExternalPrivateKey privKey;
        if (privateKey == null) {
            throw new CryptoParameterException("ECCCard buildExternalPrivateKey failure with null privateKey");
        }
        if (privateKey instanceof ECCCardExternalPrivateKey) {
            privKey = (ECCCardExternalPrivateKey)privateKey;
        } else if (privateKey instanceof BCECPrivateKey) {
            privKey = new ECCCardExternalPrivateKey((BCECPrivateKey)privateKey);
        } else {
            throw new CryptoException("ECCCard buildExternalPrivateKey failure with not support key: " + privateKey.getClass());
        }
        return privKey;
    }

    public static final String dumpPublicKey(byte[] pubX, byte[] pubY, byte[] pubH) {
        return String.format("X|Y|H=%s|%s|%s", DataHelper.toHexString(pubX), DataHelper.toHexString(pubY), DataHelper.toHexString(pubH));
    }
}

