/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardRefPublicKeyParams;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;

public final class RSACardInternalPrivateKey
implements RSAPrivateKey,
RSACardKey {
    private static final long serialVersionUID = -3958659078118796232L;
    private final int bitLength;
    private final int keyUsage;
    private final int keyIndex;
    private final byte[] pubKeyData;
    private final RSAKeyParameters pubKeyParam;

    RSACardInternalPrivateKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        if (keyIndex <= 0) {
            throw new CryptoParameterException("RSACardInternalPrivateKey invalid keyIndex = " + keyIndex);
        }
        RSACardRefPublicKeyParams params = new RSACardRefPublicKeyParams(pubKeyData);
        this.bitLength = params.bitLength;
        this.keyUsage = keyUsage;
        this.keyIndex = keyIndex;
        this.pubKeyParam = params.params;
        this.pubKeyData = (byte[])params.keyData.clone();
    }

    public final String getAlgorithm() {
        return "RSA";
    }

    public final String getFormat() {
        return "C200R";
    }

    public final byte[] getEncoded() {
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new DERUTF8String("RSA"));
            v.add(new ASN1Integer(this.keyIndex));
            v.add(new ASN1Integer(this.keyUsage));
            v.add(new ASN1Integer(this.pubKeyParam.getModulus()));
            v.add(new ASN1Integer(this.pubKeyParam.getExponent()));
            DERSequence value = new DERSequence(v);
            return value.getEncoded();
        }
        catch (IOException e) {
            throw new RuntimeException("RSACardInternalPrivateKey getEncoded() failed", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RSACardInternalPrivateKey [bitLength=").append(this.bitLength);
        builder.append(",keyIndex=").append(this.keyIndex);
        builder.append(",keyUsage=").append(this.keyUsage);
        builder.append(",pubKeyData=").append(DataHelper.toHexString(this.pubKeyData));
        builder.append("]");
        return builder.toString();
    }

    public final boolean isInternalKey() {
        return true;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public final int getKeyIndex() {
        return this.keyIndex;
    }

    public final int modulusBitsLength() {
        return this.bitLength;
    }

    public final int modulusByteLength() {
        return this.bitLength >> 3;
    }

    public final byte[] keyData() throws CryptoException {
        throw new CryptoException("RSACardInternalPrivateKey not support keyData()");
    }

    public final String dumpPublicKey() {
        return "pubKeyData=" + Hex.toHexString(this.pubKeyData, 0, 1028);
    }

    public final BigInteger getModulus() {
        return this.pubKeyParam.getModulus();
    }

    public BigInteger getPrivateExponent() {
        throw new UnsupportedOperationException("RSACardInternalPrivateKey not support getPrivateExponent(): keyIndex=" + this.keyIndex);
    }
}

