/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.IExtendSM2;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardHashHelper;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardKeyHelper;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.lib.crypto.jni.JNISM2;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.system.logging.LoggerManager;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class SM2CardDummy
implements IExtendSM2 {
    private final int SM3_LENGTH = 32;
    private final int SM2_XY_LENGTH = 32;
    private final int SM2_SIGN_LENGTH = 64;
    private final int SM2_CIPHER_MIN_LENGTH = 96;
    private final int SM2_GENKEY_TRIES_MAX = 6;

    public KeyPair generateKeyPair(boolean isExport, int keyIndex, int keyUsage) throws CryptoException {
        try {
            byte[] dBytes = new byte[32];
            byte[] xBytes = new byte[32];
            byte[] yBytes = new byte[32];
            for (int i = 0; i < 6; ++i) {
                boolean operationResult = JNISM2.generateKeypair(dBytes, xBytes, yBytes);
                if (!operationResult) {
                    LoggerManager.exceptionLogger.error("SM2CardDummy generateKeypair failure: operationResult=" + operationResult);
                    throw new CryptoException("SM2CardDummy generateKeypair failure: operationResult=" + operationResult);
                }
                if (dBytes[0] != 0 && xBytes[0] != 0 && yBytes[0] != 0) continue;
            }
            ECDomainParameters spec = SM2Params.sm2DomainParameters;
            ECPoint pubPoint = spec.getCurve().createPoint(new BigInteger(1, xBytes), new BigInteger(1, yBytes));
            ECPublicKeyParameters pubParams = new ECPublicKeyParameters(pubPoint, spec);
            SM2PublicKey pubKey = new SM2PublicKey(pubParams);
            SM2PrivateKey priKey = new SM2PrivateKey(new ECPrivateKeyParameters(new BigInteger(1, dBytes), spec), pubParams);
            return new KeyPair(pubKey, priKey);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("SM2CardDummy generateKeypair failure", (Throwable)e);
            throw new CryptoException("SM2CardDummy generateKeypair failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("SM2CardDummy generateKeypair failure", e);
            throw new CryptoException("SM2CardDummy generateKeypair failure", e);
        }
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] sm3HashValue) throws CryptoException {
        boolean operationResult;
        if (sm3HashValue == null || sm3HashValue.length == 0) {
            throw new CryptoParameterException("SM2CardDummy signByHash missing hashValue");
        }
        if (sm3HashValue.length != 32) {
            throw new CryptoParameterException("SM2CardDummy signByHash invalid hashValueLength: " + sm3HashValue.length);
        }
        GMTPrivateKey cardKey = SM2CardDummy.convertPrivateKey(privateKey);
        byte[] signData = new byte[64];
        byte[] rBytes = new byte[32];
        byte[] sBytes = new byte[32];
        try {
            operationResult = JNISM2.sign(sm3HashValue, cardKey.getDByBytes(), rBytes, sBytes);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2CardDummy signByHash failure,sm3HashValue={},privateKey={}", new Object[]{DataHelper.dump4KPartData(sm3HashValue), SM2CardKeyHelper.dumpPublicKey(cardKey), e});
            throw new CryptoException("SM2CardDummy signByHash failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("SM2CardDummy signByHash failure,operationResult={},sm3HashValue={},privateKey={}", new Object[]{operationResult, DataHelper.dump4KPartData(sm3HashValue), SM2CardKeyHelper.dumpPublicKey(cardKey)});
            throw new CryptoException("SM2CardDummy signByHash failure: operationResult=" + operationResult);
        }
        System.arraycopy(rBytes, 0, signData, 0, 32);
        System.arraycopy(sBytes, 0, signData, 32, 32);
        return signData;
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] sm3HashValue, byte[] signData) throws CryptoException {
        boolean operationResult;
        if (sm3HashValue == null || sm3HashValue.length == 0) {
            throw new CryptoParameterException("SM2CardDummy verifyByHash missing hashValue");
        }
        if (sm3HashValue.length != 32) {
            throw new CryptoParameterException("SM2CardDummy verifyByHash invalid HashLength: " + sm3HashValue.length);
        }
        if (signData == null || signData.length == 0) {
            throw new CryptoParameterException("SM2CardDummy verifyByHash missing signData");
        }
        if (signData.length != 64) {
            throw new CryptoParameterException("SM2CardDummy verifyByHash invalid signLength: " + signData.length);
        }
        GMTPublicKey cardKey = this.convertPublicKey(publicKey);
        try {
            byte[] rBytes = new byte[32];
            byte[] sBytes = new byte[32];
            System.arraycopy(signData, 0, rBytes, 0, 32);
            System.arraycopy(signData, 32, sBytes, 0, 32);
            operationResult = JNISM2.verify(rBytes, sBytes, cardKey.getPubXByBytes(), cardKey.getPubYByBytes(), sm3HashValue);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2CardDummy verifyByHash failure,sm3HashValue={},signData={},publicKey={}", new Object[]{DataHelper.dump4KPartData(sm3HashValue), DataHelper.dump4KPartData(signData), SM2CardKeyHelper.dumpPublicKey(cardKey), e});
            throw new CryptoException("SM2CardDummy verifyByHash failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("SM2CardDummy verifyByHash failure,operationResult={},sm3HashValue={},signData={},publicKey={}", new Object[]{operationResult, DataHelper.dump4KPartData(sm3HashValue), DataHelper.dump4KPartData(signData), SM2CardKeyHelper.dumpPublicKey(cardKey)});
            throw new CryptoException("SM2CardDummy verifyByHash failure: operationResult=" + operationResult);
        }
        return operationResult;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CryptoException {
        boolean operationResult;
        if (sourceData == null || sourceData.length == 0) {
            throw new CryptoParameterException("SM2CardDummy encrypt missing sourceData");
        }
        GMTPublicKey cardKey = this.convertPublicKey(publicKey);
        byte[] jniEncryptData = new byte[sourceData.length + 96];
        try {
            operationResult = JNISM2.encrypt(sourceData, cardKey.getPubXByBytes(), cardKey.getPubYByBytes(), jniEncryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2CardDummy encrypt failure,sourceDataLength={},publicKey={}", new Object[]{sourceData.length, SM2CardKeyHelper.dumpPublicKey(cardKey), e});
            throw new CryptoException("SM2CardDummy encrypt failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("SM2CardDummy encrypt failure,operationResult={},sourceDataLength={},publicKey={}", new Object[]{operationResult, sourceData.length, SM2CardKeyHelper.dumpPublicKey(cardKey)});
            throw new CryptoException("SM2CardDummy encrypt failure: operationResult=" + operationResult);
        }
        return this.convertRAWC1C2C3ToRAWC1C3C2(jniEncryptData);
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] sm2EncryptData) throws CryptoException {
        boolean operationResult;
        if (sm2EncryptData == null || sm2EncryptData.length == 0) {
            throw new CryptoParameterException("SM2CardDummy decrypt missing sm2EncryptData");
        }
        if (sm2EncryptData.length < 96) {
            throw new CryptoParameterException("SM2CardDummy decrypt invalid sm2EncryptDataLength=" + sm2EncryptData.length);
        }
        GMTPrivateKey cardKey = SM2CardDummy.convertPrivateKey(privateKey);
        byte[] jniEncryptData = this.convertRAWC1C3C2ToRAWC1C2C3(sm2EncryptData);
        byte[] decryptData = new byte[jniEncryptData.length - 96];
        try {
            operationResult = JNISM2.decrypt(jniEncryptData, cardKey.getDByBytes(), decryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2CardDummy decrypt failure,sm2EncryptData={},privateKey={}", new Object[]{DataHelper.dump4KPartData(sm2EncryptData), SM2CardKeyHelper.dumpPublicKey(cardKey), e});
            throw new CryptoException("SM2CardDummy decrypt failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("SM2CardDummy decrypt failure,operationResult={},sm2EncryptData={},privateKey={}", new Object[]{operationResult, DataHelper.dump4KPartData(sm2EncryptData), SM2CardKeyHelper.dumpPublicKey(cardKey)});
            throw new CryptoException("SM2CardDummy decrypt failure: operationResult=" + operationResult);
        }
        return decryptData;
    }

    private static final GMTPrivateKey convertPrivateKey(PrivateKey privateKey) throws CryptoException {
        if (privateKey == null) {
            throw new CryptoParameterException("missing privateKey");
        }
        GMTPrivateKey outputPrivateKey = null;
        if (privateKey instanceof GMTPrivateKey) {
            outputPrivateKey = (GMTPrivateKey)privateKey;
        } else if (privateKey instanceof PrivateKey) {
            try {
                outputPrivateKey = new SM2PrivateKey(privateKey.getEncoded());
            }
            catch (Exception e) {
                throw new CryptoException("invalid privateKey: " + privateKey.getClass(), e);
            }
        } else {
            throw new CryptoParameterException("invalid privateKey: required GMTPrivateKey");
        }
        return outputPrivateKey;
    }

    private final GMTPublicKey convertPublicKey(PublicKey publicKey) throws CryptoException {
        if (publicKey == null) {
            throw new CryptoParameterException("missing publicKey");
        }
        GMTPublicKey outputPublicKey = null;
        if (publicKey instanceof GMTPublicKey) {
            outputPublicKey = (GMTPublicKey)publicKey;
        } else if (publicKey instanceof PublicKey) {
            try {
                outputPublicKey = new SM2PublicKey(publicKey.getEncoded());
            }
            catch (Exception e) {
                throw new CryptoException("invalid publicKey: " + publicKey.getClass(), e);
            }
        } else {
            throw new CryptoParameterException("invalid publicKey: required GMTPublicKey");
        }
        return outputPublicKey;
    }

    private final byte[] convertRAWC1C2C3ToRAWC1C3C2(byte[] jniEncryptData) {
        int C1XYLength = 64;
        int C2Length = jniEncryptData.length - 96;
        int C3Length = 32;
        byte[] sm2EncryptData = new byte[jniEncryptData.length];
        System.arraycopy(jniEncryptData, 0, sm2EncryptData, 0, 64);
        System.arraycopy(jniEncryptData, jniEncryptData.length - 32, sm2EncryptData, 64, 32);
        System.arraycopy(jniEncryptData, 64, sm2EncryptData, 96, C2Length);
        return sm2EncryptData;
    }

    private final byte[] convertRAWC1C3C2ToRAWC1C2C3(byte[] sm2EncryptData) {
        int C1XYLength = 64;
        int C2Length = sm2EncryptData.length - 96;
        int C3Length = 32;
        byte[] jniEncryptData = new byte[sm2EncryptData.length];
        System.arraycopy(sm2EncryptData, 0, jniEncryptData, 0, 64);
        System.arraycopy(sm2EncryptData, 96, jniEncryptData, 64, C2Length);
        System.arraycopy(sm2EncryptData, 64, jniEncryptData, jniEncryptData.length - 32, 32);
        return jniEncryptData;
    }

    public PublicKey exportSM2ProtectKey() throws CryptoException {
        throw new CryptoException("exportEncPublicKey failure: SM2CardDummy not supported!");
    }

    public boolean importSM2EncryptKeyPair(int keyIndex, byte[] encryptKeyData) throws CryptoException {
        throw new CryptoException("importSM2KeyPair failure: SM2CardDummy not supported!");
    }

    public boolean checkIdleTest() throws CryptoException {
        return true;
    }

    public boolean idleTest() throws CryptoException {
        return true;
    }

    public int ensureKeyIndexValid(int keyIndex) throws CryptoException {
        return keyIndex;
    }

    public byte[] sm3(GMTKey cardKey, byte[] sourceData) throws CryptoException {
        return SM2CardHashHelper.sm3(cardKey, sourceData);
    }

    public byte[] sm3(GMTKey cardKey, InputStream sourceStream) throws CryptoException {
        return SM2CardHashHelper.sm3(cardKey, sourceStream);
    }

    public static class Dummy {
        public static final SM2CardDummy INSTANCE = new SM2CardDummy();
    }
}

