/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.link.jni;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.link.ICryptoLinkPartRSA;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNISDF;

final class CryptoLinkPartRSAImp
implements ICryptoLinkPartRSA {
    private static final int PUBLICKEYDATA_LENGTH = 1028;
    private static final int PRIVATEKEYDATA_LENGTH = 2820;
    private final JNISDF jnisdf;
    private final long warningTimeThreshold;

    CryptoLinkPartRSAImp(JNISDF jnisdf, long warningTimeThreshold) {
        this.jnisdf = jnisdf;
        this.warningTimeThreshold = warningTimeThreshold;
    }

    public int generateKeyPairRSA(long sessionHandle, int keyBits, byte[] publicKeyData, byte[] privateKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpRSA generateKeyPairRSA Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (publicKeyData == null || publicKeyData.length < 1028) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA generateKeyPairRSA failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpRSA generateKeyPairRSA failed: param publicKeyData is null/invalid");
        }
        if (privateKeyData == null || privateKeyData.length < 2820) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA generateKeyPairRSA failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpRSA generateKeyPairRSA failed: param privateKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.generateKeyPairRSA(sessionHandle, keyBits, publicKeyData, privateKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA generateKeyPairRSA failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpRSA generateKeyPairRSA failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA generateKeyPairRSA failed, sessionHandle={},returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpRSA generateKeyPairRSA finished, sessionHandle={},returnResult={},costTime={},publicKeyData={},privateKeyData={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, this.dumpKeyData(publicKeyData), this.dumpPrivateKeyData(privateKeyData)});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpRSA generateKeyPairRSA accomplished, sessionHandle={},returnResult={},costTime={},publicKeyData={},privateKeyData={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, this.dumpKeyData(publicKeyData), this.dumpPrivateKeyData(privateKeyData)});
        }
        return returnResult;
    }

    public int exportPublicKeyRSA(long sessionHandle, int keyIndex, int algType, byte[] publicKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpRSA exportPublicKeyRSA Running: sessionHandle={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algType});
        if (publicKeyData == null || publicKeyData.length < 1028) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA exportPublicKeyRSA failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpRSA exportPublicKeyRSA failed: param publicKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.exportPublicKeyRSA(sessionHandle, keyIndex, algType, publicKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA exportPublicKeyRSA failed, sessionHandle={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algType, e});
            throw new CryptoException("CryptoNativeImpRSA exportPublicKeyRSA failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA exportPublicKeyRSA failed, sessionHandle={},keyIndex={},algType={},returnResult={}", new Object[]{sessionHandle, keyIndex, algType, NumberHelper.hex(returnResult)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpRSA exportPublicKeyRSA finished, sessionHandle={},returnResult={},costTime={},keyIndex={},algType={},publicKeyData={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, algType, this.dumpKeyData(publicKeyData)});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpRSA exportPublicKeyRSA accomplished, sessionHandle={},returnResult={},costTime={},keyIndex={},algType={},publicKeyData={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, algType, this.dumpKeyData(publicKeyData)});
        }
        return returnResult;
    }

    public int externalPublicKeyOperationRSA(long sessionHandle, byte[] publicKeyData, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpRSA externalPublicKeyOperationRSA Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (publicKeyData == null || publicKeyData.length < 1028) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA externalPublicKeyOperationRSA failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpRSA externalPublicKeyOperationRSA failed: param publicKeyData is null/invalid");
        }
        int modulusLength = this.modulusLength(publicKeyData);
        if (dataInput == null || dataInput.length < modulusLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA externalPublicKeyOperationRSA failed: param dataInput is null/invalid");
            throw new CryptoException("CryptoNativeImpRSA externalPublicKeyOperationRSA failed: param dataInput is null/invalid");
        }
        try {
            returnResult = this.jnisdf.externalPublicKeyOperationRSA(sessionHandle, publicKeyData, dataInput, dataOutput, dataOutputSize);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA externalPublicKeyOperationRSA failed, sessionHandle={},publicKeyData={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), this.dumpKeyData(publicKeyData), DataHelper.dump4KPartData(dataInput), e});
            throw new CryptoException("CryptoNativeImpRSA externalPublicKeyOperationRSA failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA externalPublicKeyOperationRSA failed, sessionHandle={},returnResult={},publicKeyData={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), this.dumpKeyData(publicKeyData), DataHelper.dump4KPartData(dataInput)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpRSA externalPublicKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}, publicKeyData={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, this.dumpKeyData(publicKeyData), DataHelper.dump4KPartData(dataInput)});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpRSA externalPublicKeyOperationRSA accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalPublicKeyOperationRSA(long sessionHandle, int keyIndex, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpRSA internalPublicKeyOperationRSA Running: sessionHandle={},keyIndex={}", (Object)NumberHelper.hex(sessionHandle), (Object)keyIndex);
        try {
            returnResult = this.jnisdf.internalPublicKeyOperationRSA(sessionHandle, keyIndex, dataInput, dataOutput, dataOutputSize);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA internalPublicKeyOperationRSA failed, sessionHandle={},keyIndex={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, DataHelper.dump4KPartData(dataInput), e});
            throw new CryptoException("CryptoNativeImpRSA internalPublicKeyOperationRSA failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA internalPublicKeyOperationRSA failed, sessionHandle={},returnResult={},keyIndex={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, DataHelper.dump4KPartData(dataInput)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpRSA internalPublicKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, DataHelper.dump4KPartData(dataInput)});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpRSA internalPublicKeyOperationRSA accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalPrivateKeyOperationRSA(long sessionHandle, int keyIndex, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpRSA internalPrivateKeyOperationRSA Running: sessionHandle={},keyIndex={}", (Object)NumberHelper.hex(sessionHandle), (Object)keyIndex);
        try {
            returnResult = this.jnisdf.internalPrivateKeyOperationRSA(sessionHandle, keyIndex, dataInput, dataOutput, dataOutputSize);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA internalPrivateKeyOperationRSA failed, sessionHandle={},keyIndex={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, DataHelper.dump4KPartData(dataInput), e});
            throw new CryptoException("CryptoNativeImpRSA internalPrivateKeyOperationRSA failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA internalPrivateKeyOperationRSA failed, sessionHandle={},returnResult={},keyIndex={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, DataHelper.dump4KPartData(dataInput)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpRSA internalPrivateKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, DataHelper.dump4KPartData(dataInput)});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpRSA internalPrivateKeyOperationRSA accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalPrivateKeyOperationRSA(long sessionHandle, byte[] privateKeyData, byte[] dataInput, byte[] dataOutput, int[] dataOutputSize) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpRSA externalPrivateKeyOperationRSA Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (privateKeyData == null || privateKeyData.length < 2820) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA externalPrivateKeyOperationRSA failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpRSA externalPrivateKeyOperationRSA failed: param privateKeyData is null/invalid");
        }
        int modulusLength = this.modulusLength(privateKeyData);
        if (dataInput == null || dataInput.length < modulusLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA externalPrivateKeyOperationRSA failed: param dataInput is null/invalid");
            throw new CryptoException("CryptoNativeImpRSA externalPrivateKeyOperationRSA failed: param dataInput is null/invalid");
        }
        try {
            returnResult = this.jnisdf.externalPrivateKeyOperationRSA(sessionHandle, privateKeyData, dataInput, dataOutput, dataOutputSize);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA externalPrivateKeyOperationRSA failed, sessionHandle={},privateKeyData={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), this.dumpPrivateKeyData(privateKeyData), DataHelper.dump4KPartData(dataInput), e});
            throw new CryptoException("CryptoNativeImpRSA externalPrivateKeyOperationRSA failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpRSA externalPrivateKeyOperationRSA failed, sessionHandle={},returnResult={},privateKeyData={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), this.dumpPrivateKeyData(privateKeyData), DataHelper.dump4KPartData(dataInput)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpRSA externalPrivateKeyOperationRSA finished, sessionHandle={},returnResult={},costTime={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, DataHelper.dump4KPartData(dataInput)});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpRSA externalPrivateKeyOperationRSA accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    private String dumpPrivateKeyData(byte[] privateKeyData) {
        String keyInfo;
        if (privateKeyData != null) {
            String pubKeyInfo = DataHelper.toHexString(privateKeyData, 0, privateKeyData.length < 1028 ? privateKeyData.length : 1028);
            String md5 = NumberHelper.md5(privateKeyData);
            keyInfo = String.format("[md5=%s]%s", md5, pubKeyInfo);
        } else {
            keyInfo = "";
        }
        return keyInfo;
    }

    private String dumpKeyData(byte[] keyData) {
        String keyInfo = keyData != null ? DataHelper.toHexString(keyData, 0, keyData.length < 1028 ? keyData.length : 1028) : "";
        return keyInfo;
    }

    private final int modulusLength(byte[] publicKeyData) {
        int bitLength = (publicKeyData[2] & 0xFF) << 8 | publicKeyData[3] & 0xFF;
        return bitLength >> 3;
    }
}

