/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.link.jni;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.link.ICryptoLinkPartSM2;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNISDF;

final class CryptoLinkPartSM2Imp
implements ICryptoLinkPartSM2 {
    private static final int PUBLICKEYDATA_LENGTH = 68;
    private static final int PRIVATEKEYDATA_LENGTH = 36;
    private static final int ENCRYPT_LENGTH_MIN = 100;
    private static final int SOURCE_LENGTH_MAX = 8192;
    private static final int HASH_LENGTH_MIN = 20;
    private static final int SIGN_LENGTH = 64;
    private final JNISDF jnisdf;
    private final long warningTimeThreshold;

    CryptoLinkPartSM2Imp(JNISDF jnisdf, long warningTimeThreshold) {
        this.jnisdf = jnisdf;
        this.warningTimeThreshold = warningTimeThreshold;
    }

    public int generateKeyPairECC(long sessionHandle, int algID, int keyBits, byte[] publicKeyData, byte[] privateKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC generateKeyPairECC Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC generateKeyPairECC failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC generateKeyPairECC failed: param publicKeyData is null/invalid");
        }
        if (privateKeyData == null || privateKeyData.length < 36) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC generateKeyPairECC failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC generateKeyPairECC failed: param privateKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.generateKeyPairECC(sessionHandle, algID, keyBits, publicKeyData, privateKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC generateKeyPairECC failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpECC generateKeyPairECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC generateKeyPairECC failed, sessionHandle={},returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpECC generateKeyPairECC finished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC generateKeyPairECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int exportPublicKeyECC(long sessionHandle, int keyIndex, int algType, byte[] publicKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC exportPublicKeyECC Running: sessionHandle={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algType});
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC exportPublicKeyECC failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC exportPublicKeyECC failed: param publicKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.exportPublicKeyECC(sessionHandle, keyIndex, algType, publicKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC exportPublicKeyECC failed, sessionHandle={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algType, e});
            throw new CryptoException("CryptoNativeImpECC exportPublicKeyECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC exportPublicKeyECC failed, sessionHandle={},returnResult={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, algType});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpECC exportPublicKeyECC finished, sessionHandle={},returnResult={},costTime={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, algType});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC exportPublicKeyECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int exportProtectECCKey(long sessionHandle, byte[] publicKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC exportProtectKey Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC exportProtectKey failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC exportProtectKey failed: param publicKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.exportProtectKey(sessionHandle, publicKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC exportProtectKey failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpECC exportProtectKey failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC exportProtectKey failed, sessionHandle={},returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpECC exportProtectKey finished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC exportProtectKey accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int importEncryptedECCKeyPairs(long sessionHandle, int keyIndex, byte[] encryptedKeyCipherData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC importEncryptedECCKeyPairs Running: sessionHandle={},keyIndex={}", (Object)NumberHelper.hex(sessionHandle), (Object)keyIndex);
        if (encryptedKeyCipherData == null) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC importEncryptedECCKeyPairs failed: param encryptedKeyCipherData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC importEncryptedECCKeyPairs failed: param encryptedKeyCipherData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.importEncryptedECCKeyPairs(sessionHandle, keyIndex, encryptedKeyCipherData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC importEncryptedECCKeyPairs failed, sessionHandle={},keyIndex={},encryptedKeyCipherData={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, Hex.toHexString(encryptedKeyCipherData), e});
            throw new CryptoException("CryptoNativeImpECC importEncryptedECCKeyPairs failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC importEncryptedECCKeyPairs failed, sessionHandle={},returnResult={},keyIndex={},encryptedKeyCipherData={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, Hex.toHexString(encryptedKeyCipherData)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpECC importEncryptedECCKeyPairs finished, sessionHandle={},returnResult={},costTime={},keyIndex={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC importEncryptedECCKeyPairs accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalSignECC(long sessionHandle, int keyIndex, byte[] hashInput, int hashLength, byte[] signOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC internalSignECC Running: sessionHandle={},keyIndex={}\uff0chashLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, hashLength});
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC internalSignECC failed: param hashInput is null/invalid");
        }
        if (hashInput.length < hashLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed: param hashLength is invalid");
            throw new CryptoException("CryptoNativeImpECC internalSignECC failed: param hashLength is invalid");
        }
        if (signOutput == null || signOutput.length < 64) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed: param signOutput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC internalSignECC failed: param signOutput is null/invalid");
        }
        try {
            returnResult = this.jnisdf.internalSignECC(sessionHandle, keyIndex, hashInput, hashLength, signOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed, sessionHandle={},keyIndex={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, Hex.toHexString(hashInput), hashLength, e});
            throw new CryptoException("CryptoNativeImpECC internalSignECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalSignECC failed, sessionHandle={},returnResult={},keyIndex={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, Hex.toHexString(hashInput), hashLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC internalSignECC finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(hashInput), hashLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC internalSignECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalSignECC(long sessionHandle, int algID, byte[] privateKeyData, byte[] hashInput, int hashLength, byte[] dataOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC externalSignECC Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (privateKeyData == null || privateKeyData.length < 36) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalSignECC failed: param privateKeyData is null/invalid");
        }
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalSignECC failed: param hashInput is null/invalid");
        }
        if (hashInput.length < hashLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed: param hashLength is invalid");
            throw new CryptoException("CryptoNativeImpECC externalSignECC failed: param hashLength is invalid");
        }
        try {
            returnResult = this.jnisdf.externalSignECC(sessionHandle, algID, privateKeyData, hashInput, hashLength, dataOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed, sessionHandle={},algID={},privateKeyDataMD5={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(hashInput), hashLength, e});
            throw new CryptoException("CryptoNativeImpECC externalSignECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalSignECC failed, sessionHandle={},returnResult={},algID={},privateKeyDataMD5={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(hashInput), hashLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC externalSignECC finished, sessionHandle={},returnResult={},costTime={}, algID={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(hashInput), hashLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC externalSignECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalVerifyECC(long sessionHandle, int keyIndex, byte[] hashInput, int hashLength, byte[] signature) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC internalVerifyECC Running: sessionHandle={},keyIndex={}\uff0chashLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, hashLength});
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalVerifyECC failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC internalVerifyECC failed: param hashInput is null/invalid");
        }
        if (signature == null || signature.length != 64) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalVerifyECC failed: param signature is null/invalid");
            throw new CryptoException("CryptoNativeImpECC internalVerifyECC failed: param signature is null/invalid");
        }
        try {
            returnResult = this.jnisdf.internalVerifyECC(sessionHandle, keyIndex, hashInput, hashLength, signature);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalVerifyECC failed, sessionHandle={},keyIndex={},hashInput={},hashLength={},signature={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, Hex.toHexString(hashInput), hashLength, Hex.toHexString(signature), e});
            throw new CryptoException("CryptoNativeImpECC internalVerifyECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalVerifyECC failed, sessionHandle={},returnResult={},keyIndex={},hashInput={},hashLength={},signature={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, Hex.toHexString(hashInput), hashLength, Hex.toHexString(signature)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC internalVerifyECC finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},hashInput={},hashLength={},signature={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(hashInput), hashLength, Hex.toHexString(signature)});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC internalVerifyECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalVerifyECC(long sessionHandle, int algID, byte[] publicKeyData, byte[] hashInput, int hashLength, byte[] signature) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC externalVerifyECC Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalVerifyECC failed: param publicKeyData is null/invalid");
        }
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalVerifyECC failed: param hashInput is null/invalid");
        }
        if (hashInput.length < hashLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed: param hashLength is invalid");
            throw new CryptoException("CryptoNativeImpECC externalVerifyECC failed: param hashLength is invalid");
        }
        try {
            returnResult = this.jnisdf.externalVerifyECC(sessionHandle, algID, publicKeyData, hashInput, hashLength, signature);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed, sessionHandle={},algID={},publicKeyData={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, Hex.toHexString(publicKeyData), Hex.toHexString(hashInput), hashLength, e});
            throw new CryptoException("CryptoNativeImpECC externalVerifyECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalVerifyECC failed, sessionHandle={},returnResult={},algID={},publicKeyData={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, Hex.toHexString(publicKeyData), Hex.toHexString(hashInput), hashLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC externalVerifyECC failed, sessionHandle={},returnResult={},costTime={},algID={},publicKeyData={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(publicKeyData), Hex.toHexString(hashInput), hashLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC externalVerifyECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalEncryptECC(long sessionHandle, int keyIndex, int algID, byte[] dataInput, int dataLength, byte[] dataOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC internalEncryptECC Running: sessionHandle={},keyIndex={}\uff0cdataLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, dataLength});
        if (dataInput == null) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalEncryptECC failed: param dataInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC internalEncryptECC failed: param dataInput is null/invalid");
        }
        int requiredLength = dataInput.length + 100;
        if (dataOutput == null || dataOutput.length < requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalEncryptECC failed: param dataOutput is null/not enough space&requiredLength={}", (Object)requiredLength);
            throw new CryptoException("CryptoNativeImpECC internalEncryptECC failed: param dataOutput is null/not enough space");
        }
        try {
            returnResult = this.jnisdf.internalEncryptECC(sessionHandle, keyIndex, algID, dataInput, dataLength, dataOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalEncryptECC failed, sessionHandle={},keyIndex={},algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algID, Hex.toHexString(dataInput), dataLength, e});
            throw new CryptoException("CryptoNativeImpECC internalEncryptECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalEncryptECC failed, sessionHandle={},returnResult={},keyIndex={},algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, algID, Hex.toHexString(dataInput), dataLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC internalEncryptECC finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(dataInput), dataLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC internalEncryptECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalEncryptECC(long sessionHandle, int algID, byte[] publicKeyData, byte[] dataInput, int dataLength, byte[] dataOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC externalEncryptECC Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalEncryptECC failed: param publicKeyData is null");
            throw new CryptoException("CryptoNativeImpECC externalEncryptECC failed: param publicKeyData is null");
        }
        if (dataInput == null) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalEncryptECC failed: param dataInput is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalEncryptECC failed: param dataInput is null/invalid");
        }
        if (dataLength > 8192 || dataInput.length < dataLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalEncryptECC failed: param dataInput is invalid");
            throw new CryptoException("CryptoNativeImpECC externalEncryptECC failed: param dataInput is invalid");
        }
        int requiredLength = dataLength + 100;
        if (dataOutput == null || dataOutput.length < requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalEncryptECC failed: param dataOutput is null/not enough space&requiredLength={}", (Object)requiredLength);
            throw new CryptoException("CryptoNativeImpECC externalEncryptECC failed: param dataOutput is null/not enough space");
        }
        try {
            returnResult = this.jnisdf.externalEncryptECC(sessionHandle, algID, publicKeyData, dataInput, dataLength, dataOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalEncryptECC failed, sessionHandle={},algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, Hex.toHexString(dataInput), dataLength, e});
            throw new CryptoException("CryptoNativeImpECC externalEncryptECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalEncryptECC failed, sessionHandle={},returnResult={},algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, Hex.toHexString(dataInput), dataLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC externalEncryptECC finished, sessionHandle={},returnResult={},costTime={}, algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(dataInput), dataLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC externalEncryptECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalDecryptECC(long sessionHandle, int keyIndex, int algID, byte[] dataInput, byte[] dataOutput, int[] dataOutputLength) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC internalDecryptECC Running: sessionHandle={},keyIndex={}", (Object)NumberHelper.hex(sessionHandle), (Object)keyIndex);
        if (dataInput == null || dataInput.length < 100) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalDecryptECC failed: param dataInput is null/not enough space&requiredMinLength={}", (Object)100);
            throw new CryptoException("CryptoNativeImpECC internalDecryptECC failed: param dataInput is null/not enough length");
        }
        int requiredLength = dataInput.length - 100;
        if (dataOutput == null || dataOutput.length < requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalDecryptECC failed: param dataOutput is null/not enough space&requiredLength={}", (Object)requiredLength);
            throw new CryptoException("CryptoNativeImpECC internalDecryptECC failed: param dataOutput is null/not enough space");
        }
        try {
            returnResult = this.jnisdf.internalDecryptECC(sessionHandle, keyIndex, algID, dataInput, dataOutput, dataOutputLength);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalDecryptECC failed, sessionHandle={},keyIndex={},algID={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algID, Hex.toHexString(dataInput), e});
            throw new CryptoException("CryptoNativeImpECC internalDecryptECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC internalDecryptECC failed, sessionHandle={},returnResult={},keyIndex={},algID={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, algID, Hex.toHexString(dataInput)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC internalDecryptECC finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(dataInput)});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC internalDecryptECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalDecryptECC(long sessionHandle, int algID, byte[] privateKeyData, byte[] dataInput, byte[] dataOutput, int[] dataOutputLength) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpECC externalDecryptECC Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (privateKeyData == null || privateKeyData.length < 36) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalDecryptECC failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpECC externalDecryptECC failed: param privateKeyData is null/invalid");
        }
        int limitedLength = 8292;
        if (dataInput == null || dataInput.length > 8292) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalDecryptECC failed: param dataInput is null/invalid(limitedLength={})", (Object)8292);
            throw new CryptoException("CryptoNativeImpECC externalDecryptECC failed: param dataInput is null/invalid");
        }
        if (dataOutput == null) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalDecryptECC failed: param dataOutput is null/not enough space");
            throw new CryptoException("CryptoNativeImpECC externalDecryptECC failed: param dataOutput is null/not enough space");
        }
        int requiredLength = dataOutput.length - 100;
        if (dataOutput.length < requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalDecryptECC failed: param dataOutput is null/not enough space&requiredLength={}", (Object)requiredLength);
            throw new CryptoException("CryptoNativeImpECC externalDecryptECC failed: param dataOutput is null/not enough space");
        }
        if (dataOutputLength == null || dataOutputLength.length == 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalDecryptECC failed: param dataOutputLength is null/length=0");
            throw new CryptoException("CryptoNativeImpECC externalDecryptECC failed: param dataOutputLength is null/length=0");
        }
        try {
            returnResult = this.jnisdf.externalDecryptECC(sessionHandle, algID, privateKeyData, dataInput, dataOutput, dataOutputLength);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalDecryptECC failed, sessionHandle={},algID={},privateKeyDataMD5={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(dataInput), dataInput.length, e});
            throw new CryptoException("CryptoNativeImpECC externalDecryptECC failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalDecryptECC failed, sessionHandle={},returnResult={},algID={},privateKeyDataMD5={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(dataInput), dataInput.length});
        }
        if (dataOutputLength[0] != requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpECC externalDecryptECC failed, sessionHandle={},algID={},privateKeyDataMD5={},dataInput={},dataLength={},dataOutputLength[0]={}", new Object[]{NumberHelper.hex(sessionHandle), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(dataInput), dataInput.length, dataOutputLength[0]});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpECC externalDecryptECC finished, sessionHandle={},returnResult={},costTime={}, algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(dataInput), dataInput.length});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpECC externalDecryptECC accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }
}

