/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.util;

import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.org.bouncycastle.util.encoders.Encoder;
import cfca.sadk.org.bouncycastle.util.encoders.HexEncoder;
import cfca.sadk.system.logging.LoggerManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class DataHelper {
    private static final Encoder encoder = new HexEncoder();
    private static final int MAX_DUMP_LENGTH = 4096;
    private static final int MAX_DUMP_PART_LENGTH = 256;

    private DataHelper() {
    }

    public static final int dataLength(byte[] data) {
        return data == null ? 0 : data.length;
    }

    public static final int dataLength(InputStream sourceStream) {
        try {
            return sourceStream == null ? 0 : sourceStream.available();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static final String dump4KPartData(byte[] data) {
        String message = null;
        if (data == null || data.length == 0) {
            message = "";
        } else if (data.length <= 4096) {
            message = DataHelper.toHexString(data);
        } else {
            String hex = DataHelper.toHexString(data, 0, 256);
            message = String.format("%s...(len=%d)", hex, data.length);
        }
        return message;
    }

    public static final byte[] decodeHexString(String hex) {
        byte[] outBytes = null;
        if (hex == null || hex.length() == 0) {
            outBytes = new byte[]{};
        } else {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(hex.length() / 2);
            try {
                try {
                    encoder.decode(hex, bOut);
                    outBytes = bOut.toByteArray();
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.error("exception decoding Hex string", (Throwable)e);
                    throw new RuntimeException("exception decoding Hex string: " + e.getMessage(), e);
                }
                Object var5_3 = null;
                bOut = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                bOut = null;
                throw throwable;
            }
        }
        return outBytes;
    }

    public static final String toHexString(byte[] data) {
        String hex = data == null || data.length == 0 ? "" : DataHelper.toHexString(data, 0, data.length);
        return hex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toHexString(byte[] data, int offset, int length) {
        String hex = null;
        if (data == null || offset < 0 || length <= 0 || data.length <= offset) {
            hex = "";
        } else {
            int validLength = Math.min(data.length - offset, length);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(validLength * 2);
            try {
                try {
                    encoder.encode(data, offset, validLength, bOut);
                    hex = Strings.fromByteArray(bOut.toByteArray());
                }
                catch (Exception e) {
                    LoggerManager.exceptionLogger.error("exception encoding Hex string", (Throwable)e);
                    Object var8_7 = null;
                    bOut = null;
                }
                Object var8_6 = null;
                bOut = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                bOut = null;
                throw throwable;
            }
        }
        return hex;
    }
}

