/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.c200.C200CardP11;
import cfca.sadk.lib.crypto.card.c200.SM2CardInfo;
import cfca.sadk.lib.crypto.card.c200.SM2CardKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardPublicKey;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

final class SM2CardP11 {
    private C200CardP11 p11 = null;

    public SM2CardP11(SM2CardInfo info) throws CardException {
        this.p11 = C200CardP11.getInstance(info);
    }

    final byte[] SM2CardSign(SM2CardKey cardKey, byte[] hashValue) throws CardException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2CardSign>>>>>>Running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(cardKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (cardKey == null || !(cardKey instanceof SM2CardPrivateKey)) {
            throw new CardException("SM2CardSign<<<<<<Failure with invalid SM2CardPrivateKey");
        }
        if (hashValue == null || hashValue.length != 32) {
            throw new CardException("SM2CardSign<<<<<<Failure with invalid hashValue(Required 32)");
        }
        return this.p11.cardSign(cardKey, hashValue);
    }

    final boolean SM2CardVerify(SM2CardKey cardKey, byte[] hashValue, byte[] signValue) throws CardException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2CardVerify>>>>>>Running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(cardKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n signValue: ");
            buffer.append(SADKDebugger.dump(signValue));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (cardKey == null || !(cardKey instanceof SM2CardPublicKey)) {
            throw new CardException("SM2CardVerify<<<<<<Failure with invalid SM2CardPublicKey");
        }
        if (hashValue == null || hashValue.length != 32) {
            throw new CardException("SM2CardVerify<<<<<<Failure with invalid hashValue(Required 32)!");
        }
        if (signValue == null) {
            throw new CardException("SM2CardVerify<<<<<<Failure with invalid signValue!");
        }
        return this.p11.cardVerify(cardKey, hashValue, signValue);
    }

    final byte[] SM2CardEncrypt(SM2CardKey cardKey, byte[] sourceData) throws CardException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2CardEncrypt>>>>>>Running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(cardKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (cardKey == null || !(cardKey instanceof SM2CardPublicKey)) {
            throw new CardException("SM2CardEncrypt<<<<<<Failure with invalid SM2CardPublicKey");
        }
        if (sourceData == null || sourceData.length == 0) {
            throw new CardException("SM2CardEncrypt Failure with invalid sourceData(Required > 0)!");
        }
        return this.p11.cardEncrypt(cardKey, sourceData);
    }

    final byte[] SM2CardDecrypt(SM2CardKey cardKey, byte[] encryptData) throws CardException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2CardDecrypt>>>>>>Running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(cardKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (cardKey == null || !(cardKey instanceof SM2CardPrivateKey)) {
            throw new CardException("SM2CardDecrypt<<<<<<Failure with invalid SM2CardPrivateKey");
        }
        if (encryptData == null || encryptData.length <= 96) {
            throw new CardException("SM2CardDecrypt<<<<<<Failure with invalid encryptData(Required > 96)!");
        }
        return this.p11.cardDecrypt(cardKey, encryptData);
    }

    final SM2CardPublicKey SM2CardPublicKey(PublicKey pubKey) throws CardException {
        if (pubKey == null) {
            throw new CardException("SM2CardPublicKey<<<<<<Required PublicKey");
        }
        SM2CardPublicKey cardKey = null;
        if (pubKey instanceof SM2CardPublicKey) {
            cardKey = (SM2CardPublicKey)pubKey;
        } else {
            SM2PublicKey sm2Key = null;
            if (!(pubKey instanceof SM2PublicKey)) {
                throw new CardException("SM2CardPublicKey<<<<<<Required SM2PublicKey");
            }
            sm2Key = (SM2PublicKey)pubKey;
            KeyPair keypair = this.p11.getKeyPair(sm2Key);
            cardKey = keypair == null ? new SM2CardPublicKey(sm2Key) : (SM2CardPublicKey)keypair.getPublic();
        }
        return cardKey;
    }

    final SM2CardPrivateKey SM2CardPrivateKey(PrivateKey privKey) throws CardException {
        if (privKey == null) {
            throw new CardException("SM2CardPrivateKey<<<<<<Failure: required PrivateKey");
        }
        SM2CardPrivateKey cardKey = null;
        if (privKey instanceof SM2CardPrivateKey) {
            cardKey = (SM2CardPrivateKey)privKey;
        } else {
            SM2PrivateKey sm2Key = null;
            if (!(privKey instanceof SM2PrivateKey)) {
                throw new CardException("SM2CardPrivateKey<<<<<<Required SM2PrivateKey");
            }
            sm2Key = (SM2PrivateKey)privKey;
            if (sm2Key.getSM2PublicKey() == null) {
                throw new CardException("SM2CardPrivateKey<<<<<<Invalid SM2PrivateKey");
            }
            KeyPair keypair = this.p11.getKeyPair(sm2Key.getSM2PublicKey());
            cardKey = keypair == null ? new SM2CardPrivateKey(sm2Key) : (SM2CardPrivateKey)keypair.getPrivate();
        }
        return cardKey;
    }

    public long loginSM2Card(String p11Password) throws CardException {
        return this.p11.loginSM2Card(p11Password);
    }

    public boolean SM2CardExternalVerify(SM2CardPublicKey cardKey, byte[] sm3HashValue, byte[] signData) throws CardException {
        return this.p11.SM2CardExternalVerify(cardKey, sm3HashValue, signData);
    }

    public KeyPair generateKeyPair(GenKeyAttribute genKeyAttribute) throws CardException {
        return this.p11.generateKeyPair(genKeyAttribute);
    }

    public byte[] SM2CardExternalEncrypt(SM2CardPublicKey cardKey, byte[] sourceData) throws CardException {
        return this.p11.SM2CardExternalEncrypt(cardKey, sourceData);
    }

    final PublicKey expoertEncPublicKey() throws CardException {
        return this.p11.expoertEncPublicKey();
    }

    final boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws CardException {
        return this.p11.importSM2KeyPair(encryptKeyData, CKID);
    }

    public boolean checkIdleTest() throws CardException {
        return this.p11.cardIdleTest();
    }
}

