/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.Environments;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.SM2OutputFormat;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.util.DES3Helper;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.SM4Helper;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public class EncryptUtil {
    static final String CHARSET = "UTF-8";
    static final int MAX_SM2_ENCRYPT_LENGTH = 0x800000;
    static final int MAX_SM2_DECRYPT_LENGTH = 0x1000000;
    static final int MAX_SM4_MEMORY_DECRYPT_LENGTH = 0x1000000;

    public static byte[] encryptMessageBySM2(byte[] sourceData, String certFilePath, Session session) throws PKIException {
        X509Cert x509Cert = EncryptUtil.certFrom(certFilePath);
        if (!x509Cert.isSM2Cert()) {
            LoggerManager.exceptionLogger.error("encryptMessageBySM2<<<<<<Failure: required certFilePath for SM2Cert");
            throw new PKIException("required certFilePath for SM2Cert");
        }
        return EncryptUtil.encrypt(new Mechanism("SM2"), x509Cert.getPublicKey(), sourceData, session);
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, X509Cert x509Cert, Session session) throws PKIException {
        if (x509Cert == null) {
            throw new PKIException("Param@x509Cert required not null");
        }
        if (!x509Cert.isSM2Cert()) {
            LoggerManager.exceptionLogger.error("encryptMessageBySM2<<<<<<Failure: required certFilePath for SM2Cert");
            throw new PKIException("required certFilePath for SM2Cert");
        }
        return EncryptUtil.encryptMessage(new Mechanism("SM2"), x509Cert.getPublicKey(), sourceData, session);
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, Key key, Session session) throws PKIException {
        if (!(key instanceof PublicKey)) {
            throw new PKIException("encryptMessageBySM2@key required PublicKey");
        }
        return EncryptUtil.encryptMessage(new Mechanism("SM2"), (PublicKey)key, sourceData, session);
    }

    public static byte[] decryptMessageBySM2(byte[] encryptedData, String sm2FilePath, String sm2FilePwd, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptMessageBySM2>>>>>>Running");
            buffer.append("\n encryptedData: ");
            buffer.append(SADKDebugger.dump(encryptedData));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (encryptedData == null) {
            throw new PKIException("Param@encryptedData required not null");
        }
        if (sm2FilePath == null) {
            throw new PKIException("Param@sm2FilePath key not null");
        }
        if (sm2FilePwd == null) {
            throw new PKIException("Param@sm2FilePwd key not null");
        }
        if (session == null) {
            throw new PKIException("Param@session required not null");
        }
        SM2PrivateKey sm2PrivKey = null;
        try {
            sm2PrivKey = KeyUtil.getPrivateKeyFromSM2(sm2FilePath, sm2FilePwd);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("decryptMessageBySM2<<<<<<GetPrivateKeyFromSM2 Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("decryptMessageBySM2<<<<<<GetPrivateKeyFromSM2 Failure", e);
            throw new PKIException("decryptMessageBySM2 GetPrivateKeyFromSM2 Failure", e);
        }
        return EncryptUtil.decrypt(new Mechanism("SM2"), sm2PrivKey, encryptedData, session);
    }

    public static byte[] decryptMessageBySM2(byte[] encryptedData, Key key, Session session) throws PKIException {
        return EncryptUtil.decrypt(new Mechanism("SM2"), key, encryptedData, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, String certFilePath, Session session) throws PKIException {
        X509Cert x509Cert = EncryptUtil.certFrom(certFilePath);
        if (!x509Cert.isRSACert()) {
            LoggerManager.exceptionLogger.error("encryptMessageByRSA<<<<<<Failure: required certFilePath for RSACert,certFilePath=" + certFilePath);
            throw new PKIException("required certFilePath for RSACert");
        }
        return EncryptUtil.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), x509Cert.getPublicKey(), sourceData, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, X509Cert x509Cert, Session session) throws PKIException {
        if (x509Cert == null) {
            throw new PKIException("Param@x509Cert required not null");
        }
        if (!x509Cert.isRSACert()) {
            LoggerManager.exceptionLogger.error("encryptMessageByRSA<<<<<<Failure: required certFilePath for RSACert");
            throw new PKIException("required certFilePath for RSACert");
        }
        return EncryptUtil.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), x509Cert.getPublicKey(), sourceData, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, Key key, Session session) throws PKIException {
        PublicKey pubKey = null;
        if (!(key instanceof PublicKey)) {
            throw new PKIException("key is not Publickey, PublicKey expected!");
        }
        pubKey = (PublicKey)key;
        return EncryptUtil.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), pubKey, sourceData, session);
    }

    public static byte[] decryptMessageByRSA(byte[] encryptData, String pfxFilePath, String pfxFilePwd, Session session) throws PKIException {
        if (pfxFilePath == null) {
            throw new PKIException("Param@pfxFilePath required not null");
        }
        if (pfxFilePwd == null) {
            throw new PKIException("Param@pfxFilePwd required not null");
        }
        PrivateKey prvKey = null;
        try {
            prvKey = KeyUtil.getPrivateKeyFromPFX(pfxFilePath, pfxFilePwd);
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("decryptMessageByRSA<<<<<<GetPrivateKeyFromPFX Failure", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("decryptMessageByRSA<<<<<<GetPrivateKeyFromPFX Failure", (Throwable)e);
            throw new PKIException("decryptMessageByRSA GetPrivateKeyFromPFX Failure", e);
        }
        return EncryptUtil.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), prvKey, encryptData, session);
    }

    public static byte[] decryptMessageByRSA(byte[] encryptData, Key key, Session session) throws PKIException {
        PrivateKey prvKey = null;
        if (!(key instanceof PrivateKey)) {
            throw new PKIException("decryptMessageByRSA Failure: key is not PrivateKey, PrivateKey expected!");
        }
        prvKey = (PrivateKey)key;
        return EncryptUtil.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), prvKey, encryptData, session);
    }

    public static void encryptFileBySM2(String sourceFilePath, String encryptFilePath, X509Cert x509Cert, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("encryptFileBySM2>>>>>>Running");
            buffer.append("\n sourceFilePath: ");
            buffer.append(SADKDebugger.dump(sourceFilePath));
            buffer.append("\n x509Cert: ");
            buffer.append(SADKDebugger.dump(x509Cert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (x509Cert == null) {
            throw new PKIException("Param@x509Cert required not null");
        }
        if (sourceFilePath == null) {
            throw new PKIException("missing sourceFilePath");
        }
        if (encryptFilePath == null) {
            throw new PKIException("missing encryptFilePath");
        }
        if (session == null) {
            throw new PKIException("Param@session required not null");
        }
        File sourceFile = new File(sourceFilePath);
        if (!sourceFile.exists()) {
            throw new PKIException("sourceFilePath not exists");
        }
        if (sourceFile.length() > 0x800000L) {
            throw new PKIException("sourceFilePath length limited");
        }
        if (!x509Cert.isSM2Cert()) {
            LoggerManager.exceptionLogger.error("encryptMessageBySM2<<<<<<Failure: required certFilePath for SM2Cert");
            throw new PKIException("required certFilePath for SM2Cert");
        }
        try {
            byte[] data = FileHelper.read(sourceFilePath);
            data = EncryptUtil.encryptMessageBySM2(data, x509Cert, session);
            FileHelper.write(encryptFilePath, data);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encryptFileBySM2<<<<<<Finished: encryptFilePath=" + encryptFilePath);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encryptFileBySM2<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encryptFileBySM2<<<<<<Failure", e);
            throw new PKIException("encryptFileBySM2 Failure: " + e.getMessage(), e);
        }
    }

    public static void decryptFileBySM2(String encryptFilePath, String decryptFilePath, SM2PrivateKey sm2PrvKey, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileBySM2>>>>>>Running");
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n decryptFilePath: ");
            buffer.append(SADKDebugger.dump(decryptFilePath));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (encryptFilePath == null) {
            throw new PKIException("missing encryptFilePath");
        }
        if (decryptFilePath == null) {
            throw new PKIException("missing decryptFilePath");
        }
        File encryptFile = new File(encryptFilePath);
        if (!encryptFile.exists()) {
            throw new PKIException("encryptFilePath not exists");
        }
        if (encryptFile.length() > 0x1000000L) {
            throw new PKIException("encryptFilePath length limited");
        }
        try {
            byte[] data = FileHelper.read(encryptFilePath);
            data = EncryptUtil.decryptMessageBySM2(data, sm2PrvKey, session);
            FileHelper.write(decryptFilePath, data);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("decryptFileBySM2<<<<<<Finished: decryptFilePath=" + decryptFilePath);
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("decryptFileBySM2<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("decryptFileBySM2<<<<<<Failure", e);
            throw new PKIException("decryptFileBySM2 Failure: " + e.getMessage(), e);
        }
    }

    public static String encryptMessageByDES3(String sourceText, String password) throws PKIException {
        byte[] sourceData;
        if (sourceText == null) {
            throw new PKIException("encryptMessageByDES3@sourceText required not null!");
        }
        try {
            sourceData = sourceText.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            LoggerManager.exceptionLogger.error("encryptMessageByDES3@sourceText getBytes failed!", (Throwable)e);
            throw new PKIException("encryptMessageByDES3@sourceText getBytes failed!", e);
        }
        byte[] base64EncryptData = EncryptUtil.encryptMessageByDES3(sourceData, password);
        return Strings.fromByteArray(base64EncryptData);
    }

    public static String decryptMessageByDES3(String base64EncryptData, String password) throws PKIException {
        byte[] encryptData;
        if (base64EncryptData == null) {
            throw new PKIException("decryptMessageByDES3@base64EncryptData required not null!");
        }
        try {
            encryptData = base64EncryptData.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            LoggerManager.exceptionLogger.error("decryptMessageByDES3@base64EncryptData getBytes failed!", (Throwable)e);
            throw new PKIException("decryptMessageByDES3@base64EncryptData getBytes failed!", e);
        }
        byte[] decryptData = EncryptUtil.decryptMessageByDES3(encryptData, password);
        try {
            return new String(decryptData, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            LoggerManager.exceptionLogger.error("decryptMessageByDES3@decryptData toString failed!", (Throwable)e);
            throw new PKIException("decryptMessageByDES3@decryptData toString failed!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptFileByDES3(String sourceFilePath, String encryptFilePath, String password) throws PKIException {
        PKIException failure = null;
        FileOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            block5: {
                try {
                    inputStream = new FileInputStream(sourceFilePath);
                    outputStream = new FileOutputStream(encryptFilePath);
                    EncryptUtil.encryptFileByDES3(inputStream, outputStream, password);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("encryptFileByDES3<<<<<<Finished!");
                    buffer.append("\n sourceFilePath: ");
                    buffer.append(SADKDebugger.dump(sourceFilePath));
                    buffer.append("\n encryptFilePath: ");
                    buffer.append(SADKDebugger.dump(encryptFilePath));
                    buffer.append("\n password: ");
                    buffer.append(SADKDebugger.dump(password));
                    LoggerManager.debugLogger.debug(buffer.toString(), (Throwable)failure);
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("encryptFileByDES3 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var8_9 = null;
            FileHelper.closedStream(inputStream, "encryptFileByDES3@sourceFilePath closed failed");
            FileHelper.closedStream(outputStream, "encryptFileByDES3@encryptFilePath closed failed");
            if (failure == null) return;
            StringBuilder buffer = new StringBuilder();
            buffer.append("encryptFileByDES3<<<<<<Failure!");
            buffer.append("\n sourceFilePath: ");
            buffer.append(SADKDebugger.dump(sourceFilePath));
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            FileHelper.closedStream(inputStream, "encryptFileByDES3@sourceFilePath closed failed");
            FileHelper.closedStream(outputStream, "encryptFileByDES3@encryptFilePath closed failed");
            if (failure == null) throw throwable;
            StringBuilder buffer = new StringBuilder();
            buffer.append("encryptFileByDES3<<<<<<Failure!");
            buffer.append("\n sourceFilePath: ");
            buffer.append(SADKDebugger.dump(sourceFilePath));
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decryptFileByDES3(String encryptFilePath, String decryptOutputStream, String password) throws PKIException {
        PKIException failure = null;
        FileOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            block5: {
                try {
                    inputStream = new FileInputStream(encryptFilePath);
                    outputStream = new FileOutputStream(decryptOutputStream);
                    EncryptUtil.decryptFileByDES3(inputStream, outputStream, password);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("decryptFileByDES3<<<<<<Failure!");
                    buffer.append("\n encryptFilePath: ");
                    buffer.append(SADKDebugger.dump(encryptFilePath));
                    buffer.append("\n decryptOutputStream: ");
                    buffer.append(SADKDebugger.dump(decryptOutputStream));
                    buffer.append("\n password: ");
                    buffer.append(SADKDebugger.dump(password));
                    LoggerManager.debugLogger.debug(buffer.toString(), (Throwable)failure);
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("decryptFileByDES3 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var8_9 = null;
            FileHelper.closedStream(inputStream, "decryptFileByDES3@encryptFilePath closed failed");
            FileHelper.closedStream(outputStream, "decryptFileByDES3@decryptOutputStream closed failed");
            if (failure == null) return;
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileByDES3<<<<<<Failure!");
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n decryptOutputStream: ");
            buffer.append(SADKDebugger.dump(decryptOutputStream));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            FileHelper.closedStream(inputStream, "decryptFileByDES3@encryptFilePath closed failed");
            FileHelper.closedStream(outputStream, "decryptFileByDES3@decryptOutputStream closed failed");
            if (failure == null) throw throwable;
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileByDES3<<<<<<Failure!");
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n decryptOutputStream: ");
            buffer.append(SADKDebugger.dump(decryptOutputStream));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decryptFileByDES3(String encryptFilePath, ByteArrayOutputStream outByteStream, String password) throws PKIException {
        PKIException failure = null;
        FileInputStream inputStream = null;
        try {
            block5: {
                try {
                    inputStream = new FileInputStream(encryptFilePath);
                    EncryptUtil.decryptFileByDES3(inputStream, (OutputStream)outByteStream, password);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("decryptFileByDES3<<<<<<Failure!");
                    buffer.append("\n encryptFilePath: ");
                    buffer.append(SADKDebugger.dump(encryptFilePath));
                    buffer.append("\n outByteStream: ");
                    buffer.append(SADKDebugger.dump(outByteStream));
                    buffer.append("\n password: ");
                    buffer.append(SADKDebugger.dump(password));
                    LoggerManager.debugLogger.debug(buffer.toString(), (Throwable)failure);
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("decryptFileByDES3 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var7_8 = null;
            FileHelper.closedStream(inputStream, "decryptFileByDES3@encryptFilePath closed failed");
            if (failure == null) return;
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileByDES3<<<<<<Failure!");
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n outByteStream: ");
            buffer.append(SADKDebugger.dump(outByteStream));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            FileHelper.closedStream(inputStream, "decryptFileByDES3@encryptFilePath closed failed");
            if (failure == null) throw throwable;
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileByDES3<<<<<<Failure!");
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n outByteStream: ");
            buffer.append(SADKDebugger.dump(outByteStream));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    public static byte[] encryptMessageBySM4(byte[] sourceData, String password) throws PKIException {
        SM4Helper.IvSM4Key ivKey;
        try {
            ivKey = new SM4Helper.IvSM4Key(password);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("KDFIvSM4KeyFromPassword<<<<<<Finished!");
                buffer.append("\n password: ");
                buffer.append(SADKDebugger.dump(password));
                buffer.append("\n iv16Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.iv16Bytes));
                buffer.append("\n k16Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.k16Bytes));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("KDFIvSM4KeyFromPassword<<<<<<Failure: password=" + password, (Throwable)e);
            throw e;
        }
        return EncryptUtil.encryptMessageBySM4(sourceData, ivKey.iv16Bytes, ivKey.k16Bytes);
    }

    public static byte[] decryptMessageBySM4(byte[] encryptData, String password) throws PKIException {
        SM4Helper.IvSM4Key ivKey;
        try {
            ivKey = new SM4Helper.IvSM4Key(password);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("KDFIvSM4KeyFromPassword<<<<<<Finished!");
                buffer.append("\n password: ");
                buffer.append(SADKDebugger.dump(password));
                buffer.append("\n iv16Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.iv16Bytes));
                buffer.append("\n k16Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.k16Bytes));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("KDFIvSM4KeyFromPassword<<<<<<Failure: password=" + password, (Throwable)e);
            throw e;
        }
        return EncryptUtil.decryptMessageBySM4(encryptData, ivKey.iv16Bytes, ivKey.k16Bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encryptMessageBySM4(byte[] sourceData, byte[] sm4iv, byte[] sm4key) throws PKIException {
        StringBuilder buffer3;
        byte[] byArray;
        PKIException failure = null;
        try {
            try {
                byte[] base64EncryptData = SM4Helper.encrypt(sm4key, sm4iv, sourceData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    StringBuilder buffer2 = new StringBuilder();
                    buffer2.append("encryptMessageBySM4<<<<<<Finished!");
                    buffer2.append("\n sourceData: ");
                    buffer2.append(SADKDebugger.dump(sourceData));
                    buffer2.append("\n sm4key: ");
                    buffer2.append(SADKDebugger.dump(sm4key));
                    buffer2.append("\n sm4iv: ");
                    buffer2.append(SADKDebugger.dump(sm4iv));
                    buffer2.append("\n base64EncryptText: ");
                    buffer2.append(SADKDebugger.dumpBase64(base64EncryptData));
                    LoggerManager.debugLogger.debug(buffer2.toString());
                }
                byArray = base64EncryptData;
                Object var7_8 = null;
                if (failure == null) return byArray;
                buffer3 = new StringBuilder();
                buffer3.append("encryptMessageBySM4<<<<<<Failure!");
            }
            catch (PKIException e) {
                failure = e;
                throw failure;
            }
            catch (Exception e) {
                failure = new PKIException("encryptMessageBySM4 Failure: " + e.getMessage(), e);
                throw failure;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("encryptMessageBySM4<<<<<<Failure!");
            buffer3.append("\n sourceData: ");
            buffer3.append(SADKDebugger.dump(sourceData));
            buffer3.append("\n sm4key: ");
            buffer3.append(SADKDebugger.dump(sm4key));
            buffer3.append("\n sm4iv: ");
            buffer3.append(SADKDebugger.dump(sm4iv));
            LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
            throw throwable;
        }
        buffer3.append("\n sourceData: ");
        buffer3.append(SADKDebugger.dump(sourceData));
        buffer3.append("\n sm4key: ");
        buffer3.append(SADKDebugger.dump(sm4key));
        buffer3.append("\n sm4iv: ");
        buffer3.append(SADKDebugger.dump(sm4iv));
        LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decryptMessageBySM4(byte[] base64EncryptedBytes, byte[] sm4iv, byte[] sm4key) throws PKIException {
        StringBuilder buffer3;
        byte[] byArray;
        PKIException failure = null;
        try {
            try {
                byte[] sourceData = SM4Helper.decrypt(sm4key, sm4iv, base64EncryptedBytes);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    StringBuilder buffer2 = new StringBuilder();
                    buffer2.append("decryptMessageBySM4<<<<<<Finished!");
                    buffer2.append("\n base64EncryptedBytes: ");
                    buffer2.append(SADKDebugger.dumpBase64(base64EncryptedBytes));
                    buffer2.append("\n sm4key: ");
                    buffer2.append(SADKDebugger.dump(sm4key));
                    buffer2.append("\n sm4iv: ");
                    buffer2.append(SADKDebugger.dump(sm4iv));
                    buffer2.append("\n sourceData: ");
                    buffer2.append(SADKDebugger.dump(sourceData));
                    LoggerManager.debugLogger.debug(buffer2.toString());
                }
                byArray = sourceData;
                Object var7_8 = null;
                if (failure == null) return byArray;
                buffer3 = new StringBuilder();
                buffer3.append("decryptMessageBySM4<<<<<<Failure!");
            }
            catch (PKIException e) {
                failure = e;
                throw failure;
            }
            catch (Exception e) {
                failure = new PKIException("decryptMessageBySM4 Failure: " + e.getMessage(), e);
                throw failure;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("decryptMessageBySM4<<<<<<Failure!");
            buffer3.append("\n base64EncryptedBytes: ");
            buffer3.append(SADKDebugger.dumpBase64(base64EncryptedBytes));
            buffer3.append("\n sm4key: ");
            buffer3.append(SADKDebugger.dump(sm4key));
            buffer3.append("\n sm4iv: ");
            buffer3.append(SADKDebugger.dump(sm4iv));
            LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
            throw throwable;
        }
        buffer3.append("\n base64EncryptedBytes: ");
        buffer3.append(SADKDebugger.dumpBase64(base64EncryptedBytes));
        buffer3.append("\n sm4key: ");
        buffer3.append(SADKDebugger.dump(sm4key));
        buffer3.append("\n sm4iv: ");
        buffer3.append(SADKDebugger.dump(sm4iv));
        LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptFileBySM4(String sourceFilePath, String encryptFilePath, String password) throws PKIException {
        PKIException failure = null;
        FileOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            block5: {
                try {
                    inputStream = new FileInputStream(sourceFilePath);
                    outputStream = new FileOutputStream(encryptFilePath);
                    EncryptUtil.encryptFileBySM4(inputStream, outputStream, password);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("encryptFileBySM4<<<<<<Finished!");
                    buffer.append("\n sourceFilePath: ");
                    buffer.append(SADKDebugger.dump(sourceFilePath));
                    buffer.append("\n encryptFilePath: ");
                    buffer.append(SADKDebugger.dump(encryptFilePath));
                    buffer.append("\n password: ");
                    buffer.append(SADKDebugger.dump(password));
                    LoggerManager.debugLogger.debug(buffer.toString(), (Throwable)failure);
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("encryptFileBySM4 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var8_9 = null;
            FileHelper.closedStream(inputStream, "encryptFileBySM4@sourceFilePath closed failed");
            FileHelper.closedStream(outputStream, "encryptFileBySM4@encryptFilePath closed failed");
            if (failure == null) return;
            StringBuilder buffer = new StringBuilder();
            buffer.append("encryptFileBySM4<<<<<<Failure!");
            buffer.append("\n sourceFilePath: ");
            buffer.append(SADKDebugger.dump(sourceFilePath));
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            FileHelper.closedStream(inputStream, "encryptFileBySM4@sourceFilePath closed failed");
            FileHelper.closedStream(outputStream, "encryptFileBySM4@encryptFilePath closed failed");
            if (failure == null) throw throwable;
            StringBuilder buffer = new StringBuilder();
            buffer.append("encryptFileBySM4<<<<<<Failure!");
            buffer.append("\n sourceFilePath: ");
            buffer.append(SADKDebugger.dump(sourceFilePath));
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decryptFileBySM4(String encryptFilePath, String decryptOutputStream, String password) throws PKIException {
        PKIException failure = null;
        FileOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            block5: {
                try {
                    inputStream = new FileInputStream(encryptFilePath);
                    outputStream = new FileOutputStream(decryptOutputStream);
                    EncryptUtil.decryptFileBySM4(inputStream, outputStream, password);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("decryptFileBySM4<<<<<<Failure!");
                    buffer.append("\n encryptFilePath: ");
                    buffer.append(SADKDebugger.dump(encryptFilePath));
                    buffer.append("\n decryptOutputStream: ");
                    buffer.append(SADKDebugger.dump(decryptOutputStream));
                    buffer.append("\n password: ");
                    buffer.append(SADKDebugger.dump(password));
                    LoggerManager.debugLogger.debug(buffer.toString(), (Throwable)failure);
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("decryptFileBySM4 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var8_9 = null;
            FileHelper.closedStream(inputStream, "decryptFileBySM4@encryptFilePath closed failed");
            FileHelper.closedStream(outputStream, "decryptFileBySM4@decryptOutputStream closed failed");
            if (failure == null) return;
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileBySM4<<<<<<Failure!");
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n decryptOutputStream: ");
            buffer.append(SADKDebugger.dump(decryptOutputStream));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            FileHelper.closedStream(inputStream, "decryptFileBySM4@encryptFilePath closed failed");
            FileHelper.closedStream(outputStream, "decryptFileBySM4@decryptOutputStream closed failed");
            if (failure == null) throw throwable;
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileBySM4<<<<<<Failure!");
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n decryptOutputStream: ");
            buffer.append(SADKDebugger.dump(decryptOutputStream));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decryptFileBySM4(String encryptFilePath, ByteArrayOutputStream decryptOutputStream, String password) throws PKIException {
        PKIException failure = null;
        FileInputStream encryptInputStream = null;
        try {
            block5: {
                try {
                    encryptInputStream = new FileInputStream(encryptFilePath);
                    EncryptUtil.decryptFileBySM4(encryptInputStream, (OutputStream)decryptOutputStream, password);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("decryptFileBySM4<<<<<<Failure!");
                    buffer.append("\n encryptFilePath: ");
                    buffer.append(SADKDebugger.dump(encryptFilePath));
                    buffer.append("\n decryptOutputStream: ");
                    buffer.append(SADKDebugger.dump(decryptOutputStream));
                    buffer.append("\n password: ");
                    buffer.append(SADKDebugger.dump(password));
                    LoggerManager.debugLogger.debug(buffer.toString(), (Throwable)failure);
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("decryptFileBySM4 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var7_8 = null;
            FileHelper.closedStream(encryptInputStream, "decryptFileBySM4@encryptInputStream closed failed");
            if (failure == null) return;
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileBySM4<<<<<<Failure!");
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n decryptOutputStream: ");
            buffer.append(SADKDebugger.dump(decryptOutputStream));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            FileHelper.closedStream(encryptInputStream, "decryptFileBySM4@encryptInputStream closed failed");
            if (failure == null) throw throwable;
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileBySM4<<<<<<Failure!");
            buffer.append("\n encryptFilePath: ");
            buffer.append(SADKDebugger.dump(encryptFilePath));
            buffer.append("\n decryptOutputStream: ");
            buffer.append(SADKDebugger.dump(decryptOutputStream));
            buffer.append("\n password: ");
            buffer.append(SADKDebugger.dump(password));
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    public static int decryptFileBySM4(String encryptedFilePath, byte[] outPlainBytes, String password) throws PKIException {
        if (encryptedFilePath == null) {
            throw new PKIException("decryptFileBySM4@encryptedFilePath required not nul!");
        }
        if (outPlainBytes == null) {
            throw new PKIException("decryptFileBySM4@outPlainBytes required not nul!");
        }
        if (password == null) {
            throw new PKIException("decryptFileBySM4@password required not nul!");
        }
        File encryptedFile = new File(encryptedFilePath);
        if (!encryptedFile.exists()) {
            throw new PKIException("decryptFileBySM4@encryptedFilePath not exists!encryptedFile->" + encryptedFile);
        }
        long encryptedFileLength = encryptedFile.length();
        if (encryptedFileLength > (long)outPlainBytes.length) {
            throw new PKIException(String.format("decryptFileBySM4@encryptedFilePath(%s) more than outPlainBytes(%s)", encryptedFileLength, outPlainBytes.length));
        }
        if (encryptedFileLength > 0x1000000L) {
            throw new PKIException(String.format("decryptFileBySM4@encryptedFilePath(%s) limited MAX_SM4_MEMORY_DECRYPT_LENGTH(%s)", encryptedFileLength, 0x1000000));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)encryptedFileLength);
        EncryptUtil.decryptFileBySM4(encryptedFilePath, baos, password);
        byte[] decryptBytes = baos.toByteArray();
        baos.reset();
        baos = null;
        System.arraycopy(decryptBytes, 0, outPlainBytes, 0, decryptBytes.length);
        return decryptBytes.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData, Session session) throws PKIException {
        StringBuilder buffer3;
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("encrypt[data]>>>>>>Running");
            buffer2.append("\n mechanism: ");
            buffer2.append(SADKDebugger.dump(mechanism));
            buffer2.append("\n key: ");
            buffer2.append(SADKDebugger.dump(key));
            buffer2.append("\n sourceData: ");
            buffer2.append(SADKDebugger.dump(sourceData));
            buffer2.append("\n session: ");
            buffer2.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        if (mechanism == null) {
            throw new PKIException("encrypt[data]Param@mechanism required not null");
        }
        if (key == null) {
            throw new PKIException("encrypt[data]Param@key required not null");
        }
        if (sourceData == null) {
            throw new PKIException("encrypt[data]Param@sourceData required not null");
        }
        if (session == null) {
            throw new PKIException("encrypt[data]Param@session required not null");
        }
        PKIException failure = null;
        try {
            try {
                byte[] encryptedBytes = session.encrypt(mechanism, key, sourceData);
                byte[] base64EncryptBytes = Base64.encode(encryptedBytes);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("encrypt[data]<<<<<<Finished: base64EncryptBytes=" + SADKDebugger.dumpBase64(base64EncryptBytes));
                }
                byArray = base64EncryptBytes;
                Object var9_11 = null;
                if (failure == null) return byArray;
                buffer3 = new StringBuilder();
                buffer3.append("encrypt[data]>>>>>>Failure");
            }
            catch (PKIException e) {
                failure = e;
                throw failure;
            }
            catch (Exception e) {
                failure = new PKIException("encrypt[data] Failure: " + e.getMessage(), e);
                throw failure;
            }
            catch (Throwable e) {
                failure = new PKIException("encrypt[data] Failure: " + e.getMessage(), e);
                throw failure;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("encrypt[data]>>>>>>Failure");
            buffer3.append("\n mechanism: ");
            buffer3.append(SADKDebugger.dump(mechanism));
            buffer3.append("\n key: ");
            buffer3.append(SADKDebugger.dump(key));
            buffer3.append("\n sourceData: ");
            buffer3.append(SADKDebugger.dump(sourceData));
            buffer3.append("\n session: ");
            buffer3.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
            throw throwable;
        }
        buffer3.append("\n mechanism: ");
        buffer3.append(SADKDebugger.dump(mechanism));
        buffer3.append("\n key: ");
        buffer3.append(SADKDebugger.dump(key));
        buffer3.append("\n sourceData: ");
        buffer3.append(SADKDebugger.dump(sourceData));
        buffer3.append("\n session: ");
        buffer3.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData, Session session) throws PKIException {
        StringBuilder buffer3;
        byte[] byArray;
        byte[] encryptBytes;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("decrypt[data]>>>>>>Running");
            buffer2.append("\n mechanism: ");
            buffer2.append(SADKDebugger.dump(mechanism));
            buffer2.append("\n key: ");
            buffer2.append(SADKDebugger.dump(key));
            buffer2.append("\n encryptData: ");
            buffer2.append(SADKDebugger.dump(encryptData));
            buffer2.append("\n session: ");
            buffer2.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        if (mechanism == null) {
            throw new PKIException("decrypt[data]Param@mechanism required not null");
        }
        if (key == null) {
            throw new PKIException("decrypt[data]Param@key required not null");
        }
        if (encryptData == null) {
            throw new PKIException("decrypt[data]Param@encryptData required not null");
        }
        if (session == null) {
            throw new PKIException("decrypt[data]Param@session required not null");
        }
        try {
            encryptBytes = Base64.decode(encryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("decrypt[data]<<<<<<Failure: Param@encryptData required base64=" + SADKDebugger.dump(encryptData));
            throw new PKIException("decrypt[data]Param@encryptData required base64", e);
        }
        PKIException failure = null;
        byte[] decryptBytes = null;
        try {
            try {
                decryptBytes = session.decrypt(mechanism, key, encryptBytes);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("decrypt[data]<<<<<<Finished: decryptBytes=" + SADKDebugger.dump(decryptBytes));
                }
                byArray = decryptBytes;
                Object var9_12 = null;
                if (failure == null) return byArray;
                buffer3 = new StringBuilder();
                buffer3.append("decrypt[data]>>>>>>Failure");
            }
            catch (PKIException e) {
                failure = e;
                throw failure;
            }
            catch (Exception e) {
                failure = new PKIException("decrypt[data] Failure: " + e.getMessage(), e);
                throw failure;
            }
            catch (Throwable e) {
                failure = new PKIException("decrypt[data] Failure: " + e.getMessage(), e);
                throw failure;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("decrypt[data]>>>>>>Failure");
            buffer3.append("\n mechanism: ");
            buffer3.append(SADKDebugger.dump(mechanism));
            buffer3.append("\n key: ");
            buffer3.append(SADKDebugger.dump(key));
            buffer3.append("\n encryptData: ");
            buffer3.append(SADKDebugger.dump(encryptData));
            buffer3.append("\n session: ");
            buffer3.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
            throw throwable;
        }
        buffer3.append("\n mechanism: ");
        buffer3.append(SADKDebugger.dump(mechanism));
        buffer3.append("\n key: ");
        buffer3.append(SADKDebugger.dump(key));
        buffer3.append("\n encryptData: ");
        buffer3.append(SADKDebugger.dump(encryptData));
        buffer3.append("\n session: ");
        buffer3.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
        return byArray;
    }

    public static void encrypt(Mechanism mechanism, Key key, String sourceFilePath, String encryptFilePath, Session session) throws PKIException {
        if (sourceFilePath == null) {
            throw new PKIException("encrypt[file]Param@sourceFilePath required not null");
        }
        if (encryptFilePath == null) {
            throw new PKIException("encrypt[file]Param@encryptFilePath required not null");
        }
        File sourceFile = new File(sourceFilePath);
        if (!sourceFile.exists()) {
            throw new PKIException("encrypt[file]Files@sourceFile not exists: " + sourceFile);
        }
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        PKIException failure = null;
        try {
            try {
                inputStream = new FileInputStream(sourceFilePath);
                File file = new File(encryptFilePath);
                if (!file.exists()) {
                    file.createNewFile();
                }
                outputStream = new FileOutputStream(file);
                EncryptUtil.encryptFile(mechanism, key, inputStream, outputStream, session);
            }
            catch (PKIException e) {
                failure = e;
                throw failure;
            }
            catch (Exception e) {
                failure = new PKIException("encrypt[file] Failure: " + e.getMessage(), e);
                throw failure;
            }
            catch (Throwable e) {
                failure = new PKIException("encrypt[file] Failure: " + e.getMessage(), e);
                throw failure;
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            FileHelper.closedStream(inputStream, "encrypt[file]@inputStream closed failure");
            FileHelper.closedStream(outputStream, "encrypt[file]@outputStream closed failure");
            throw throwable;
        }
        FileHelper.closedStream(inputStream, "encrypt[file]@inputStream closed failure");
        FileHelper.closedStream(outputStream, "encrypt[file]@outputStream closed failure");
    }

    public static void decrypt(Mechanism mechanism, Key key, String encryptFilePath, String decryptOutputStream, Session session) throws PKIException {
        if (encryptFilePath == null) {
            throw new PKIException("decrypt[file]Param@encryptFilePath required not null");
        }
        if (decryptOutputStream == null) {
            throw new PKIException("decrypt[file]Param@decryptOutputStream required not null");
        }
        File sourceFile = new File(encryptFilePath);
        if (!sourceFile.exists()) {
            throw new PKIException("decrypt[file]Files@encryptFilePath not exists: " + sourceFile);
        }
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        PKIException failure = null;
        try {
            try {
                inputStream = new FileInputStream(encryptFilePath);
                File file = new File(decryptOutputStream);
                if (!file.exists()) {
                    file.createNewFile();
                }
                outputStream = new FileOutputStream(file);
                EncryptUtil.decryptFile(mechanism, key, inputStream, outputStream, session);
            }
            catch (PKIException e) {
                failure = e;
                throw failure;
            }
            catch (Exception e) {
                failure = new PKIException("decrypt[file] Failure: " + e.getMessage(), e);
                throw failure;
            }
            catch (Throwable e) {
                failure = new PKIException("decrypt[file] Failure: " + e.getMessage(), e);
                throw failure;
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            FileHelper.closedStream(inputStream, "decrypt[file]@inputStream closed failure");
            FileHelper.closedStream(outputStream, "decrypt[file]@outputStream closed failure");
            throw throwable;
        }
        FileHelper.closedStream(inputStream, "decrypt[file]@inputStream closed failure");
        FileHelper.closedStream(outputStream, "decrypt[file]@outputStream closed failure");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void encryptFile(Mechanism mechanism, Key key, InputStream inputStream, OutputStream outputStream, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("encrypt[file]>>>>>>Running");
            buffer2.append("\n mechanism: ");
            buffer2.append(SADKDebugger.dump(mechanism));
            buffer2.append("\n key: ");
            buffer2.append(SADKDebugger.dump(key));
            buffer2.append("\n inputStream: ");
            buffer2.append(SADKDebugger.dump(inputStream));
            buffer2.append("\n outputStream: ");
            buffer2.append(SADKDebugger.dump(outputStream));
            buffer2.append("\n session: ");
            buffer2.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        if (mechanism == null) {
            throw new PKIException("encrypt[file]Param@mechanism required not null");
        }
        if (key == null) {
            throw new PKIException("encrypt[file]Param@key required not null");
        }
        if (inputStream == null) {
            throw new PKIException("encrypt[file]Param@inputStream required not null");
        }
        if (outputStream == null) {
            throw new PKIException("encrypt[file]Param@outputStream required not null");
        }
        if (session == null) {
            throw new PKIException("encrypt[file]Param@session required not null");
        }
        PKIException failure = null;
        try {
            block12: {
                try {
                    session.encrypt(mechanism, key, inputStream, outputStream);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block12;
                    LoggerManager.debugLogger.debug("encrypt[file]<<<<<<Finished!");
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("encrypt[file] Failure: " + e.getMessage(), e);
                    throw failure;
                }
                catch (Throwable e) {
                    failure = new PKIException("encrypt[file] Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var8_6 = null;
            if (failure == null) return;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("encrypt[file]>>>>>>Running");
            buffer322.append("\n mechanism: ");
            buffer322.append(SADKDebugger.dump(mechanism));
            buffer322.append("\n key: ");
            buffer322.append(SADKDebugger.dump(key));
            buffer322.append("\n inputStream: ");
            buffer322.append(SADKDebugger.dump(inputStream));
            buffer322.append("\n outputStream: ");
            buffer322.append(SADKDebugger.dump(outputStream));
            buffer322.append("\n session: ");
            buffer322.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("encrypt[file]>>>>>>Running");
            buffer322.append("\n mechanism: ");
            buffer322.append(SADKDebugger.dump(mechanism));
            buffer322.append("\n key: ");
            buffer322.append(SADKDebugger.dump(key));
            buffer322.append("\n inputStream: ");
            buffer322.append(SADKDebugger.dump(inputStream));
            buffer322.append("\n outputStream: ");
            buffer322.append(SADKDebugger.dump(outputStream));
            buffer322.append("\n session: ");
            buffer322.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void decryptFile(Mechanism mechanism, Key key, InputStream inputStream, OutputStream outputStream, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("decrypt[file]>>>>>>Running");
            buffer2.append("\n Mechanism: ");
            buffer2.append(SADKDebugger.dump(mechanism));
            buffer2.append("\n key: ");
            buffer2.append(SADKDebugger.dump(key));
            buffer2.append("\n inputStream: ");
            buffer2.append(SADKDebugger.dump(inputStream));
            buffer2.append("\n outputStream: ");
            buffer2.append(SADKDebugger.dump(outputStream));
            buffer2.append("\n session: ");
            buffer2.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer2.toString());
        }
        if (mechanism == null) {
            throw new PKIException("decrypt[file]Param@mechanism required not null");
        }
        if (key == null) {
            throw new PKIException("decrypt[file]Param@key required not null");
        }
        if (inputStream == null) {
            throw new PKIException("decrypt[file]Param@inputStream required not null");
        }
        if (outputStream == null) {
            throw new PKIException("decrypt[file]Param@outputStream required not null");
        }
        if (session == null) {
            throw new PKIException("decrypt[file]Param@session required not null");
        }
        PKIException failure = null;
        try {
            block12: {
                try {
                    session.decrypt(mechanism, key, inputStream, outputStream);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block12;
                    LoggerManager.debugLogger.debug("decrypt[file]<<<<<<Finished!");
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("decrypt[file] Failure: " + e.getMessage(), e);
                    throw failure;
                }
                catch (Throwable e) {
                    failure = new PKIException("decrypt[file] Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var8_6 = null;
            if (failure == null) return;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("decrypt[file]>>>>>>Running");
            buffer322.append("\n Mechanism: ");
            buffer322.append(SADKDebugger.dump(mechanism));
            buffer322.append("\n key: ");
            buffer322.append(SADKDebugger.dump(key));
            buffer322.append("\n inputStream: ");
            buffer322.append(SADKDebugger.dump(inputStream));
            buffer322.append("\n outputStream: ");
            buffer322.append(SADKDebugger.dump(outputStream));
            buffer322.append("\n session: ");
            buffer322.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("decrypt[file]>>>>>>Running");
            buffer322.append("\n Mechanism: ");
            buffer322.append(SADKDebugger.dump(mechanism));
            buffer322.append("\n key: ");
            buffer322.append(SADKDebugger.dump(key));
            buffer322.append("\n inputStream: ");
            buffer322.append(SADKDebugger.dump(inputStream));
            buffer322.append("\n outputStream: ");
            buffer322.append(SADKDebugger.dump(outputStream));
            buffer322.append("\n session: ");
            buffer322.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    public static byte[] encryptMessageByDES3(byte[] sourceData, String password) throws PKIException {
        DES3Helper.IvDES3Key ivKey;
        try {
            ivKey = new DES3Helper.IvDES3Key(password);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("buildIvDES3KeyFromPassword<<<<<<Finished!");
                buffer.append("\n password: ");
                buffer.append(SADKDebugger.dump(password));
                buffer.append("\n iv8Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.iv8Bytes));
                buffer.append("\n k24Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.k24Bytes));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("buildIvDES3KeyFromPassword<<<<<<Failure: password=" + password, (Throwable)e);
            throw e;
        }
        return EncryptUtil.encryptMessageByDES3(sourceData, ivKey.iv8Bytes, ivKey.k24Bytes);
    }

    public static byte[] decryptMessageByDES3(byte[] base64EncryptedBytes, String password) throws PKIException {
        DES3Helper.IvDES3Key ivKey;
        try {
            ivKey = new DES3Helper.IvDES3Key(password);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("buildIvDES3KeyFromPassword<<<<<<Finished!");
                buffer.append("\n password: ");
                buffer.append(SADKDebugger.dump(password));
                buffer.append("\n iv8Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.iv8Bytes));
                buffer.append("\n k24Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.k24Bytes));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("buildIvDES3KeyFromPassword<<<<<<Failure: password=" + password, (Throwable)e);
            throw e;
        }
        return EncryptUtil.decryptMessageByDES3(base64EncryptedBytes, ivKey.iv8Bytes, ivKey.k24Bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encryptMessageByDES3(byte[] sourceData, byte[] des3iv, byte[] des3key) throws PKIException {
        StringBuilder buffer3;
        byte[] byArray;
        PKIException failure = null;
        try {
            try {
                byte[] base64EncryptData = DES3Helper.encrypt(des3key, des3iv, sourceData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    StringBuilder buffer2 = new StringBuilder();
                    buffer2.append("encryptMessageByDES3<<<<<<Finished!");
                    buffer2.append("\n sourceData: ");
                    buffer2.append(SADKDebugger.dump(sourceData));
                    buffer2.append("\n des3key: ");
                    buffer2.append(SADKDebugger.dump(des3key));
                    buffer2.append("\n des3iv: ");
                    buffer2.append(SADKDebugger.dump(des3iv));
                    buffer2.append("\n base64EncryptText: ");
                    buffer2.append(SADKDebugger.dumpBase64(base64EncryptData));
                    LoggerManager.debugLogger.debug(buffer2.toString());
                }
                byArray = base64EncryptData;
                Object var7_8 = null;
                if (failure == null) return byArray;
                buffer3 = new StringBuilder();
                buffer3.append("encryptMessageByDES3<<<<<<Failure!");
            }
            catch (PKIException e) {
                failure = e;
                throw failure;
            }
            catch (Exception e) {
                failure = new PKIException("encryptMessageByDES3 Failure: " + e.getMessage(), e);
                throw failure;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("encryptMessageByDES3<<<<<<Failure!");
            buffer3.append("\n sourceData: ");
            buffer3.append(SADKDebugger.dump(sourceData));
            buffer3.append("\n des3key: ");
            buffer3.append(SADKDebugger.dump(des3key));
            buffer3.append("\n des3iv: ");
            buffer3.append(SADKDebugger.dump(des3iv));
            LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
            throw throwable;
        }
        buffer3.append("\n sourceData: ");
        buffer3.append(SADKDebugger.dump(sourceData));
        buffer3.append("\n des3key: ");
        buffer3.append(SADKDebugger.dump(des3key));
        buffer3.append("\n des3iv: ");
        buffer3.append(SADKDebugger.dump(des3iv));
        LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decryptMessageByDES3(byte[] base64EncryptedBytes, byte[] des3iv, byte[] des3key) throws PKIException {
        StringBuilder buffer3;
        byte[] byArray;
        PKIException failure = null;
        try {
            try {
                byte[] sourceData = DES3Helper.decrypt(des3key, des3iv, base64EncryptedBytes);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    StringBuilder buffer2 = new StringBuilder();
                    buffer2.append("decryptMessageByDES3<<<<<<Finished!");
                    buffer2.append("\n base64EncryptedBytes: ");
                    buffer2.append(SADKDebugger.dumpBase64(base64EncryptedBytes));
                    buffer2.append("\n des3key: ");
                    buffer2.append(SADKDebugger.dump(des3key));
                    buffer2.append("\n des3iv: ");
                    buffer2.append(SADKDebugger.dump(des3iv));
                    buffer2.append("\n sourceData: ");
                    buffer2.append(SADKDebugger.dump(sourceData));
                    LoggerManager.debugLogger.debug(buffer2.toString());
                }
                byArray = sourceData;
                Object var7_8 = null;
                if (failure == null) return byArray;
                buffer3 = new StringBuilder();
                buffer3.append("decryptMessageByDES3<<<<<<Failure!");
            }
            catch (PKIException e) {
                failure = e;
                throw failure;
            }
            catch (Exception e) {
                failure = new PKIException("decryptMessageByDES3 Failure: " + e.getMessage(), e);
                throw failure;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer3 = new StringBuilder();
            buffer3.append("decryptMessageByDES3<<<<<<Failure!");
            buffer3.append("\n base64EncryptedBytes: ");
            buffer3.append(SADKDebugger.dumpBase64(base64EncryptedBytes));
            buffer3.append("\n des3key: ");
            buffer3.append(SADKDebugger.dump(des3key));
            buffer3.append("\n des3iv: ");
            buffer3.append(SADKDebugger.dump(des3iv));
            LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
            throw throwable;
        }
        buffer3.append("\n base64EncryptedBytes: ");
        buffer3.append(SADKDebugger.dumpBase64(base64EncryptedBytes));
        buffer3.append("\n des3key: ");
        buffer3.append(SADKDebugger.dump(des3key));
        buffer3.append("\n des3iv: ");
        buffer3.append(SADKDebugger.dump(des3iv));
        LoggerManager.exceptionLogger.error(buffer3.toString(), (Throwable)failure);
        return byArray;
    }

    public static void encryptFileByDES3(InputStream sourceInputStream, OutputStream encryptOutputStream, String password) throws PKIException {
        DES3Helper.IvDES3Key ivKey;
        try {
            ivKey = new DES3Helper.IvDES3Key(password);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("buildIvDES3KeyFromPassword<<<<<<Finished!");
                buffer.append("\n password: ");
                buffer.append(SADKDebugger.dump(password));
                buffer.append("\n iv8Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.iv8Bytes));
                buffer.append("\n k24Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.k24Bytes));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("buildIvDES3KeyFromPassword<<<<<<Failure: password=" + password, (Throwable)e);
            throw e;
        }
        EncryptUtil.encryptFileByDES3(sourceInputStream, encryptOutputStream, ivKey.iv8Bytes, ivKey.k24Bytes);
    }

    public static void decryptFileByDES3(InputStream encryptInputStream, OutputStream decryptOutputStream, String password) throws PKIException {
        DES3Helper.IvDES3Key ivKey;
        try {
            ivKey = new DES3Helper.IvDES3Key(password);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("buildIvDES3KeyFromPassword<<<<<<Finished!");
                buffer.append("\n password: ");
                buffer.append(SADKDebugger.dump(password));
                buffer.append("\n iv8Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.iv8Bytes));
                buffer.append("\n k24Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.k24Bytes));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("buildIvDES3KeyFromPassword<<<<<<Failure: password=" + password, (Throwable)e);
            throw e;
        }
        EncryptUtil.decryptFileByDES3(encryptInputStream, decryptOutputStream, ivKey.iv8Bytes, ivKey.k24Bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptFileByDES3(InputStream sourceInputStream, OutputStream encryptOutputStream, byte[] des3iv, byte[] des3key) throws PKIException {
        PKIException failure = null;
        try {
            block5: {
                try {
                    DES3Helper.encrypt(des3key, des3iv, sourceInputStream, encryptOutputStream);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer2 = new StringBuilder();
                    buffer2.append("encryptFileByDES3<<<<<<Finished!");
                    buffer2.append("\n sourceInputStream: ");
                    buffer2.append(SADKDebugger.dump(sourceInputStream));
                    buffer2.append("\n encryptOutputStream: ");
                    buffer2.append(SADKDebugger.dump(encryptOutputStream));
                    buffer2.append("\n des3key: ");
                    buffer2.append(SADKDebugger.dump(des3key));
                    buffer2.append("\n des3iv: ");
                    buffer2.append(SADKDebugger.dump(des3iv));
                    LoggerManager.debugLogger.debug(buffer2.toString());
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("encryptFileByDES3 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var7_8 = null;
            if (failure == null) return;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("encryptFileByDES3<<<<<<Failure!");
            buffer322.append("\n sourceInputStream: ");
            buffer322.append(SADKDebugger.dump(sourceInputStream));
            buffer322.append("\n encryptOutputStream: ");
            buffer322.append(SADKDebugger.dump(encryptOutputStream));
            buffer322.append("\n des3key: ");
            buffer322.append(SADKDebugger.dump(des3key));
            buffer322.append("\n des3iv: ");
            buffer322.append(SADKDebugger.dump(des3iv));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("encryptFileByDES3<<<<<<Failure!");
            buffer322.append("\n sourceInputStream: ");
            buffer322.append(SADKDebugger.dump(sourceInputStream));
            buffer322.append("\n encryptOutputStream: ");
            buffer322.append(SADKDebugger.dump(encryptOutputStream));
            buffer322.append("\n des3key: ");
            buffer322.append(SADKDebugger.dump(des3key));
            buffer322.append("\n des3iv: ");
            buffer322.append(SADKDebugger.dump(des3iv));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decryptFileByDES3(InputStream encryptInputStream, OutputStream decryptOutputStream, byte[] des3iv, byte[] des3key) throws PKIException {
        PKIException failure = null;
        try {
            block5: {
                try {
                    DES3Helper.decrypt(des3key, des3iv, encryptInputStream, decryptOutputStream);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer2 = new StringBuilder();
                    buffer2.append("decryptFileByDES3<<<<<<Finished!");
                    buffer2.append("\n encryptInputStream: ");
                    buffer2.append(SADKDebugger.dump(encryptInputStream));
                    buffer2.append("\n decryptOutputStream: ");
                    buffer2.append(SADKDebugger.dump(decryptOutputStream));
                    buffer2.append("\n des3key: ");
                    buffer2.append(SADKDebugger.dump(des3key));
                    buffer2.append("\n des3iv: ");
                    buffer2.append(SADKDebugger.dump(des3iv));
                    LoggerManager.debugLogger.debug(buffer2.toString());
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("decryptFileByDES3 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var7_8 = null;
            if (failure == null) return;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("decryptFileByDES3<<<<<<Failure!");
            buffer322.append("\n encryptInputStream: ");
            buffer322.append(SADKDebugger.dump(encryptInputStream));
            buffer322.append("\n decryptOutputStream: ");
            buffer322.append(SADKDebugger.dump(decryptOutputStream));
            buffer322.append("\n des3key: ");
            buffer322.append(SADKDebugger.dump(des3key));
            buffer322.append("\n des3iv: ");
            buffer322.append(SADKDebugger.dump(des3iv));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("decryptFileByDES3<<<<<<Failure!");
            buffer322.append("\n encryptInputStream: ");
            buffer322.append(SADKDebugger.dump(encryptInputStream));
            buffer322.append("\n decryptOutputStream: ");
            buffer322.append(SADKDebugger.dump(decryptOutputStream));
            buffer322.append("\n des3key: ");
            buffer322.append(SADKDebugger.dump(des3key));
            buffer322.append("\n des3iv: ");
            buffer322.append(SADKDebugger.dump(des3iv));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    public static void encryptFileBySM4(InputStream sourceInputStream, OutputStream encryptOutputStream, String password) throws PKIException {
        SM4Helper.IvSM4Key ivKey;
        try {
            ivKey = new SM4Helper.IvSM4Key(password);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("KDFIvSM4KeyFromPassword<<<<<<Finished!");
                buffer.append("\n password: ");
                buffer.append(SADKDebugger.dump(password));
                buffer.append("\n iv16Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.iv16Bytes));
                buffer.append("\n k16Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.k16Bytes));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("KDFIvSM4KeyFromPassword<<<<<<Failure: password=" + password, (Throwable)e);
            throw e;
        }
        EncryptUtil.encryptFileBySM4(sourceInputStream, encryptOutputStream, ivKey.iv16Bytes, ivKey.k16Bytes);
    }

    public static void decryptFileBySM4(InputStream encryptInputStream, OutputStream decryptOutputStream, String password) throws PKIException {
        SM4Helper.IvSM4Key ivKey;
        try {
            ivKey = new SM4Helper.IvSM4Key(password);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("KDFIvSM4KeyFromPassword<<<<<<Finished!");
                buffer.append("\n password: ");
                buffer.append(SADKDebugger.dump(password));
                buffer.append("\n iv16Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.iv16Bytes));
                buffer.append("\n k16Bytes: ");
                buffer.append(SADKDebugger.dump(ivKey.k16Bytes));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("KDFIvSM4KeyFromPassword<<<<<<Failure: password=" + password, (Throwable)e);
            throw e;
        }
        EncryptUtil.decryptFileBySM4(encryptInputStream, decryptOutputStream, ivKey.iv16Bytes, ivKey.k16Bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptFileBySM4(InputStream sourceInputStream, OutputStream encryptOutputStream, byte[] sm4iv, byte[] sm4key) throws PKIException {
        PKIException failure = null;
        try {
            block5: {
                try {
                    SM4Helper.encrypt(sm4key, sm4iv, sourceInputStream, encryptOutputStream);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer2 = new StringBuilder();
                    buffer2.append("encryptFileBySM4<<<<<<Finished!");
                    buffer2.append("\n sourceInputStream: ");
                    buffer2.append(SADKDebugger.dump(sourceInputStream));
                    buffer2.append("\n encryptOutputStream: ");
                    buffer2.append(SADKDebugger.dump(encryptOutputStream));
                    buffer2.append("\n sm4key: ");
                    buffer2.append(SADKDebugger.dump(sm4key));
                    buffer2.append("\n sm4iv: ");
                    buffer2.append(SADKDebugger.dump(sm4iv));
                    LoggerManager.debugLogger.debug(buffer2.toString());
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("encryptFileBySM4 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var7_8 = null;
            if (failure == null) return;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("encryptFileBySM4<<<<<<Failure!");
            buffer322.append("\n sourceInputStream: ");
            buffer322.append(SADKDebugger.dump(sourceInputStream));
            buffer322.append("\n encryptOutputStream: ");
            buffer322.append(SADKDebugger.dump(encryptOutputStream));
            buffer322.append("\n sm4key: ");
            buffer322.append(SADKDebugger.dump(sm4key));
            buffer322.append("\n sm4iv: ");
            buffer322.append(SADKDebugger.dump(sm4iv));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("encryptFileBySM4<<<<<<Failure!");
            buffer322.append("\n sourceInputStream: ");
            buffer322.append(SADKDebugger.dump(sourceInputStream));
            buffer322.append("\n encryptOutputStream: ");
            buffer322.append(SADKDebugger.dump(encryptOutputStream));
            buffer322.append("\n sm4key: ");
            buffer322.append(SADKDebugger.dump(sm4key));
            buffer322.append("\n sm4iv: ");
            buffer322.append(SADKDebugger.dump(sm4iv));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decryptFileBySM4(InputStream encryptInputStream, OutputStream decryptOutputStream, byte[] sm4iv, byte[] sm4key) throws PKIException {
        PKIException failure = null;
        try {
            block5: {
                try {
                    SM4Helper.decrypt(sm4key, sm4iv, encryptInputStream, decryptOutputStream);
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block5;
                    StringBuilder buffer2 = new StringBuilder();
                    buffer2.append("decryptFileBySM4<<<<<<Finished!");
                    buffer2.append("\n encryptInputStream: ");
                    buffer2.append(SADKDebugger.dump(encryptInputStream));
                    buffer2.append("\n decryptOutputStream: ");
                    buffer2.append(SADKDebugger.dump(decryptOutputStream));
                    buffer2.append("\n sm4key: ");
                    buffer2.append(SADKDebugger.dump(sm4key));
                    buffer2.append("\n sm4iv: ");
                    buffer2.append(SADKDebugger.dump(sm4iv));
                    LoggerManager.debugLogger.debug(buffer2.toString());
                }
                catch (PKIException e) {
                    failure = e;
                    throw failure;
                }
                catch (Exception e) {
                    failure = new PKIException("decryptFileBySM4 Failure: " + e.getMessage(), e);
                    throw failure;
                }
            }
            Object var7_8 = null;
            if (failure == null) return;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("decryptFileBySM4<<<<<<Failure!");
            buffer322.append("\n encryptInputStream: ");
            buffer322.append(SADKDebugger.dump(encryptInputStream));
            buffer322.append("\n decryptOutputStream: ");
            buffer322.append(SADKDebugger.dump(decryptOutputStream));
            buffer322.append("\n sm4key: ");
            buffer322.append(SADKDebugger.dump(sm4key));
            buffer322.append("\n sm4iv: ");
            buffer322.append(SADKDebugger.dump(sm4iv));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (failure == null) throw throwable;
            StringBuilder buffer322 = new StringBuilder();
            buffer322.append("decryptFileBySM4<<<<<<Failure!");
            buffer322.append("\n encryptInputStream: ");
            buffer322.append(SADKDebugger.dump(encryptInputStream));
            buffer322.append("\n decryptOutputStream: ");
            buffer322.append(SADKDebugger.dump(decryptOutputStream));
            buffer322.append("\n sm4key: ");
            buffer322.append(SADKDebugger.dump(sm4key));
            buffer322.append("\n sm4iv: ");
            buffer322.append(SADKDebugger.dump(sm4iv));
            LoggerManager.exceptionLogger.error(buffer322.toString(), (Throwable)failure);
            throw throwable;
        }
    }

    public static byte[] encryptMessage(Mechanism encryptAlg, PublicKey publicKey, byte[] sourceData, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("encryptMessage>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(SADKDebugger.dump(encryptAlg));
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encryptedBytes = session.encrypt(encryptAlg, publicKey, sourceData);
            encryptedBytes = EncryptUtil.sm2FormatEncrypted64Bytes(encryptAlg, encryptedBytes);
            byte[] base64EncryptBytes = Base64.encode(encryptedBytes);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encryptMessage<<<<<<Finished: base64EncryptBytes=" + SADKDebugger.dumpBase64(base64EncryptBytes));
            }
            return base64EncryptBytes;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encryptMessage<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encryptMessage<<<<<<Failure", e);
            throw new PKIException("encryptMessage Failure: " + e.getMessage(), e);
        }
    }

    public static byte[] decryptMessage(Mechanism encryptAlg, Key key, byte[] base64EncryptedBytes, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptMessage>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(SADKDebugger.dump(encryptAlg));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n base64EncryptedBytes: ");
            buffer.append(SADKDebugger.dump(base64EncryptedBytes));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] decryptBytes = session.decrypt(encryptAlg, key, Base64.decode(base64EncryptedBytes));
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("decryptMessage<<<<<<Finished: decryptBytes=" + SADKDebugger.dump(decryptBytes));
            }
            return decryptBytes;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("decryptMessage<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("decryptMessage<<<<<<Failure", e);
            throw new PKIException("decryptMessage Failure: " + e.getMessage(), e);
        }
    }

    public static void encrypt(Mechanism mechanism, Key key, FileInputStream plainFileInputStream, FileOutputStream out, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("encrypt>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            session.encrypt(mechanism, key, plainFileInputStream, out);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encrypt<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encrypt<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encrypt<<<<<<Failure", e);
            throw new PKIException("encrypt Failure: " + e.getMessage(), e);
        }
    }

    public static void decrypt(Mechanism encryptAlg, Key key, FileInputStream encryptFileInputStream, FileOutputStream out, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("decrypt>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(SADKDebugger.dump(encryptAlg));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            session.decrypt(encryptAlg, key, encryptFileInputStream, out);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("decrypt<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("decrypt<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("decrypt<<<<<<Failure", e);
            throw new PKIException("decrypt Failure: " + e.getMessage(), e);
        }
    }

    public static void encryptFileBySM2(FileInputStream plainFileInputStream, FileOutputStream out, X509Cert sm2cert, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("encryptFileBySM2>>>>>>Running");
            buffer.append("\n X509Cert: ");
            buffer.append(SADKDebugger.dump(sm2cert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            EncryptUtil.encryptFileBySM2(plainFileInputStream, out, sm2cert.getPublicKey(), session);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encryptFileBySM2<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encryptFileBySM2<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encryptFileBySM2<<<<<<Failure", e);
            throw new PKIException("encryptFileBySM2 Failure: " + e.getMessage(), e);
        }
    }

    public static void encryptFileBySM2(FileInputStream plainFileInputStream, FileOutputStream out, PublicKey sm2pubKey, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("encryptFileBySM2>>>>>>Running");
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(sm2pubKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] plainData = new byte[plainFileInputStream.available()];
            plainFileInputStream.read(plainData);
            byte[] encryptedData = EncryptUtil.encryptMessageBySM2(plainData, sm2pubKey, session);
            out.write(encryptedData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encryptFileBySM2<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encryptFileBySM2<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encryptFileBySM2<<<<<<Failure", e);
            throw new PKIException("encryptFileBySM2 Failure: " + e.getMessage(), e);
        }
    }

    public static void decryptFileBySM2(FileInputStream encryptedFileInputStream, FileOutputStream out, PrivateKey sm2priKey, Session session) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("decryptFileBySM2>>>>>>Running");
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(sm2priKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encryptedData = new byte[encryptedFileInputStream.available()];
            encryptedFileInputStream.read(encryptedData);
            byte[] decryptedData = EncryptUtil.decryptMessageBySM2(encryptedData, sm2priKey, session);
            out.write(decryptedData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("decryptFileBySM2<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("decryptFileBySM2<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("decryptFileBySM2<<<<<<Failure", e);
            throw new PKIException("decryptFileBySM2 Failure: " + e.getMessage(), e);
        }
    }

    private static final byte[] sm2FormatEncrypted64Bytes(Mechanism mechanism, byte[] encryptedBytes) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sm2FormatEncrypted64Bytes::>>>>>>Running");
            buffer.append("\n Mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n encryptedBytes: ");
            buffer.append(SADKDebugger.dump(encryptedBytes));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        if (mechanism != null && "SM2".equals(mechanism.getMechanismType())) {
            encryptedBytes = SM2OutputFormat.sm2FormatEncryptedRAWBytes(encryptedBytes);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("sm2FormatEncrypted64Bytes::<<<<<<Finished: encryptedBytes=" + SADKDebugger.dump(encryptedBytes));
        }
        return encryptedBytes;
    }

    private static final X509Cert certFrom(String certFilePath) throws PKIException {
        if (certFilePath == null) {
            throw new PKIException("certFrom Param@certFilePath required not null");
        }
        try {
            X509Cert x509Cert = new X509Cert(certFilePath);
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("certFrom<<<<<<Failure: +certFilePath", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("certFrom<<<<<<Failure: +certFilePath", (Throwable)e);
            throw new PKIException("certFrom Failure: " + certFilePath, e);
        }
    }

    static {
        Environments.environments();
    }
}

