package com.bizunited.test;

import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.axis2.AxisFault;
import org.apache.commons.lang.StringUtils;

import com.bizunited.config.SmsConfig;
import com.bizunited.smsmsg.SMSReport;
import com.bizunited.smsmsg.SmsStub;
import com.bizunited.smsmsg.SmsStub.Report;
import com.bizunited.smsmsg.SmsStub.Sms;
import com.bizunited.smsmsg.SmsStub.SmsResponse;
import com.bizunited.util.SendVerificationCode;
import com.bizunited.util.SmsMessageUtil;

public class TestWebServiceSms {
	private static SmsStub sms = null;
	
	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
	
	private static final String prefixnum = "917";
	
	private static final SimpleDateFormat suffixfmt = new SimpleDateFormat("yyyyMMddhhmmssSSS");
	
	
	/**
	 * 企业编号
	 */
	public static final String spCode = SmsConfig.SPCODE;
	/**
	 * 用户名称
	 */
	public static final String loginName =SmsConfig.LOGIN_NAME;
	/**
	 * 用户密码
	 */
	public static final String password = SmsConfig.PASSWORD;
	static{
		if(sms==null){
			try {
				sms = new SmsStub();
			} catch (AxisFault e) {
				e.printStackTrace();
			}
		}
	}
	
	public static void main(String[] args) {
		System.out.println(SendVerificationCode.sendVerifiCode("12345", "18583758017"));
//		List<String> phonenums = new ArrayList<String>();
//		phonenums.add("18583758017");
//		phonenums.add("18583660326");
//		try {
//			System.out.println(SmsMessageUtil.sendSMSMsg("smsmsg_content_template3", phonenums, "12345"));
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
	}
	
	/**
	 * 立即发送短信
	 * @param content 内容
	 * @param phonenums 电话号码 最长1000条
	 * @throws Exception
	 */
	public static String sendSMSMsg(String content,List<String> phonenums) throws Exception{
		return sendSMSMsg(content, phonenums, null);
	}
	
	/**
	 * 按时发送短信
	 * @param content 内容
	 * @param phonenums 电话号码 最长1000条
	 * @param sendTime 发送时间
	 * @throws Exception
	 */
	public static String sendSMSMsg(String content,List<String> phonenums,Date sendTime) throws Exception{
		Sms sms0 = new Sms();
		sms0.setIn0(spCode);
		sms0.setIn1(loginName);
		sms0.setIn2(password);
		if(content.length()>402){
			throw new Exception("短信内容过长");
		}
		sms0.setIn3(content);
		if(phonenums.size()>1000){
			throw new Exception("电话号码数量过长");
		}
		sms0.setIn4(StringUtils.join(phonenums, ","));
		if(sendTime!=null){
			sms0.setIn6(sdf.format(sendTime));
		}else{
			sms0.setIn6("");
		}
		//流水号
		sms0.setIn5(getSerialNumber());
		sms0.setIn7("1");
		SmsResponse res =  sms.sms(sms0);
		return res.getOut();
	}
	
	/**
	 * 获取流水号 20位数字
	 * @return
	 */
	public static String getSerialNumber(){
		return new StringBuffer(prefixnum).append(suffixfmt.format(new Date())).toString();
	}
	/**
	 * 获取发送回执
	 * @return
	 * @throws RemoteException 
	 */
	public static List<SMSReport> getReport() throws RemoteException{
		List<SMSReport> reports = new ArrayList<SMSReport>();
		Report report = new Report();
		report.setIn0(spCode);
		report.setIn1(loginName);
		report.setIn2(password);
		String info = sms.report(report).getOut();
		if(StringUtils.isNotEmpty(info)){
			for(String str : info.split(";")){
				String[] re = str.split(",");
				reports.add(new SMSReport(re[0], re[1], re[2]));
			}
		}
		return reports;	
	}
	
}
