package com.bizunited.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.bizunited.config.SmsConfig;


/**
 * 发送短信工具类
 * 
 * @author younger
 * 
 */
public class SendMessageUtil {
	
	private  SendMessageUtil(){
		
	}
	
	/**	弃用!!采用玄武短信网关发送短信--ESMSMessageSend.sendMessage
	 *@param moblie 电话号码
	 *@param content 内容
	 */
	@Deprecated
	public static boolean sendMessage(String moblie,String content){
		return sendMessage(moblie, content, "");
	}
	public static boolean isMobileNO(String mobiles){  
		Pattern p = Pattern.compile("^((13[0-9])|(15[012356789])|(18[0-9])|(17[0,6-8])|14[57])\\d{8}$");  
		Matcher m = p.matcher(mobiles);  
		return m.matches();  
	}
	/**	弃用!!采用玄武短信网关发送短信--ESMSMessageSend.sendMessage
	 *@param moblie 电话号码
	 *@param content 内容
	 *@param sendtime 发送时间
	 */
	@Deprecated
	public static boolean sendMessage(String moblie,String content ,String sendtime){
		InputStream inputStream = null;
		OutputStreamWriter out = null;
		try {
			URL url = new URL(SmsConfig.OLD_MESSAGE_URL);
			URLConnection connection = url.openConnection();
			connection.setDoOutput(true);
			out = new OutputStreamWriter(connection.getOutputStream(), "gb2312");
			out.write(connectStr(moblie,content,sendtime));
			out.flush();
			out.close();
			String line = null, result = null;
			StringBuffer bufXml = new StringBuffer();
			inputStream = connection.getInputStream();
			// 传说中的三层包装阿！
			BufferedReader l_reader = new BufferedReader(new InputStreamReader(
					inputStream));
			while ((line = l_reader.readLine()) != null) {
				bufXml.append(line);
			}
			result = bufXml.toString().replaceAll("\\s+", "");
			System.out.println(result);
			if(result.contains("success")){
				return true;
			}else{
				return false;
			}
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}finally{
			if(out!=null){
				try {
					out.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if(inputStream!=null){
				try {
					inputStream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	
	/**
	 * 封装访问的url参数
	 * @param phones 电话
	 * @param content 内容
	 * @param time 发送时间
	 */
	private static String connectStr(String phones, String content, String time){
		String result = null;
		long l = System.currentTimeMillis()/1000;
		String str =SmsConfig.OLD_PASSWORD+"_"+l+"_topsky";
		result =  "cpid="+SmsConfig.OLD_CPID +
				 "&password="+MD5.GetMD5Code(str)+
				 "&channelid="+SmsConfig.OLD_CHANNELID+
				 "&tele="+phones+
				 "&msg="+content;
			result = result + "&timestamp="+l;
		return result;
	}
	
	public static String getValiCode(int length){
		Random r = new Random();
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<length;i++){
			sb.append(r.nextInt(9)+1);
		}
		return sb.toString();
	}
	
	public static void main(String[] args) {
		try {
			ResourceBundle bundler = ResourceBundle.getBundle("eshop");
			String content = bundler.getString("register_msg").replace("{code}", getValiCode(5));
			sendMessage("18583758017",URLEncoder.encode(content,"GBK"));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
}
