/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.test;

import com.bizunited.config.SmsConfig;
import com.bizunited.smsmsg.SMSReport;
import com.bizunited.smsmsg.SmsStub;
import com.bizunited.util.SendVerificationCode;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.commons.lang.StringUtils;

public class TestWebServiceSms {
    private static SmsStub sms = null;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
    private static final String prefixnum = "917";
    private static final SimpleDateFormat suffixfmt = new SimpleDateFormat("yyyyMMddhhmmssSSS");
    public static final String spCode = SmsConfig.SPCODE;
    public static final String loginName = SmsConfig.LOGIN_NAME;
    public static final String password = SmsConfig.PASSWORD;

    static {
        if (sms == null) {
            try {
                sms = new SmsStub();
            }
            catch (AxisFault e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(SendVerificationCode.sendVerifiCode("12345", "18583758017"));
    }

    public static String sendSMSMsg(String content, List<String> phonenums) throws Exception {
        return TestWebServiceSms.sendSMSMsg(content, phonenums, null);
    }

    public static String sendSMSMsg(String content, List<String> phonenums, Date sendTime) throws Exception {
        SmsStub.Sms sms0 = new SmsStub.Sms();
        sms0.setIn0(spCode);
        sms0.setIn1(loginName);
        sms0.setIn2(password);
        if (content.length() > 402) {
            throw new Exception("\u77ed\u4fe1\u5185\u5bb9\u8fc7\u957f");
        }
        sms0.setIn3(content);
        if (phonenums.size() > 1000) {
            throw new Exception("\u7535\u8bdd\u53f7\u7801\u6570\u91cf\u8fc7\u957f");
        }
        sms0.setIn4(StringUtils.join(phonenums, (String)","));
        if (sendTime != null) {
            sms0.setIn6(sdf.format(sendTime));
        } else {
            sms0.setIn6("");
        }
        sms0.setIn5(TestWebServiceSms.getSerialNumber());
        sms0.setIn7("1");
        SmsStub.SmsResponse res = sms.sms(sms0);
        return res.getOut();
    }

    public static String getSerialNumber() {
        return new StringBuffer(prefixnum).append(suffixfmt.format(new Date())).toString();
    }

    public static List<SMSReport> getReport() throws RemoteException {
        ArrayList<SMSReport> reports = new ArrayList<SMSReport>();
        SmsStub.Report report = new SmsStub.Report();
        report.setIn0(spCode);
        report.setIn1(loginName);
        report.setIn2(password);
        String info = sms.report(report).getOut();
        if (StringUtils.isNotEmpty((String)info)) {
            String[] stringArray = info.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                String[] re = str.split(",");
                reports.add(new SMSReport(re[0], re[1], re[2]));
                ++n2;
            }
        }
        return reports;
    }
}

