package com.bizunited.smsmsg;

import java.io.Serializable;

/**
 * 电话号码，发送内容key
 * @author bruce.qin
 *
 */
public class PhoneContentKey implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 5190293466102296061L;
	/**电话号码*/
	private String phone;
	/**发送内容*/
	private String content;
	public String getPhone() {
		return phone;
	}
	public void setPhone(String phone) {
		this.phone = phone;
	}
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		this.content = content;
	}
	public PhoneContentKey(String phone, String content) {
		super();
		this.phone = phone;
		this.content = content;
	}
	public PhoneContentKey() {
		super();
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((content == null) ? 0 : content.hashCode());
		result = prime * result + ((phone == null) ? 0 : phone.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PhoneContentKey other = (PhoneContentKey) obj;
		if (content == null) {
			if (other.content != null)
				return false;
		} else if (!content.equals(other.content))
			return false;
		if (phone == null) {
			if (other.phone != null)
				return false;
		} else if (!phone.equals(other.phone))
			return false;
		return true;
	}
	
	
}
