package com.bizunited.util;

import java.util.ArrayList;
import java.util.UUID;

import com.bizunited.config.SmsConfig;
import com.esms.MessageData;
import com.esms.PostMsg;
import com.esms.common.entity.Account;
import com.esms.common.entity.GsmsResponse;
import com.esms.common.entity.MTPack;
import com.esms.common.entity.MTPack.SendType;

public class ESMSMessageSend {

	private ESMSMessageSend(){
	}
	
	/**玄武短信网关账户*/
	private static final Account ACCOUNT = new Account(SmsConfig.XW_USERNAME, SmsConfig.XW_PASSWORD);
	
	private static final String CM_HOST = "211.147.239.62";
	
	private static final int CM_PORT = 8450;
	
	private static final String WS_HOST = "211.147.239.62";
	
	private static final int WS_PORT = 8460;
	
	private static PostMsg pm = null;
	
	static{
		pm = new PostMsg(true);//默认是长链接，true为短链接
		//mos网关
		pm.getCmHost().setHost(CM_HOST, CM_PORT);//设置网关的IP和port，用于发送信息
		pm.getWsHost().setHost(WS_HOST, WS_PORT);//设置网关的 IP和port，用于获取账号信息、上行、状态报告等等
	}
	
	/**
	 * 模板短信发送
	 * @param templateKey 配置文件模板key
	 * @param phone	电话
	 * @param values 模板中对应位置的变量值
	 * @return
	 * @throws Exception
	 */
	public static String sendMessage(String templateKey, String[] phones, String... values) throws Exception{
		String content = SmsMessageUtil.buildSmsContent(templateKey, values);
		MTPack pack = new MTPack();
		pack.setBatchID(UUID.randomUUID());
		pack.setBatchName("短信单发");
		pack.setMsgType(MTPack.MsgType.SMS);
		pack.setBizType(0);
		pack.setDistinctFlag(false);
		pack.setSendType(SendType.GROUP);
		ArrayList<MessageData> msgs = new ArrayList<MessageData>();
		for(String phone : phones)
			msgs.add(new MessageData(phone, content));
		pack.setMsgs(msgs);
		/** 设置模板编号(静态模板将以模板内容发送; 动态模板需要发送变量值，JSON格式：[{"key":"变量名1","value":"变量值1"},{"key":"变量名2","value":"变量值2"}]) */
		GsmsResponse resp = pm.post(ACCOUNT, pack);
		return resp.toString();
	}
	
	/**
	 * 短信发送
	 * @param content 短信内容
	 * @param phone 手机号
	 * @return
	 * @throws Exception
	 */
	public static String sendMessage(String content, String... phones) throws Exception{
		MTPack pack = new MTPack();
		pack.setBatchID(UUID.randomUUID());
		pack.setBatchName("短信单发");
		pack.setMsgType(MTPack.MsgType.SMS);
		pack.setBizType(0);
		pack.setDistinctFlag(false);
		pack.setSendType(SendType.GROUP);
		ArrayList<MessageData> msgs = new ArrayList<MessageData>();
		for(String phone : phones)
			msgs.add(new MessageData(phone, content));
		pack.setMsgs(msgs);
		/** 设置模板编号(静态模板将以模板内容发送; 动态模板需要发送变量值，JSON格式：[{"key":"变量名1","value":"变量值1"},{"key":"变量名2","value":"变量值2"}]) */
		GsmsResponse resp = pm.post(ACCOUNT, pack);
		return resp.toString();
	}
	
}