package com.bizunited.util;

/**
 * 发送验证码类
 * @author bruce.qin
 *
 */
public class SendVerificationCode {

	private SendVerificationCode(){
	}
	
	/**
	 * 发送验证码
	 * @param code  验证码
	 * @param phone  电话号码
	 * @return
	 */
	public static boolean sendVerifiCode(String code,String phone){
		if(!SendMessageUtil.isMobileNO(phone))
			return false;
		try {
			if(ESMSMessageSend.sendMessage(SmsMessageUtil.buildSmsContent("smsmsg_content_template1", code), phone).indexOf("result=0")!=-1){
				return true;
			}else if(ESMSMessageSend.sendMessage(SmsMessageUtil.buildSmsContent("smsmsg_content_template3", code), phone, code).indexOf("result=0")!=-1){
				return true;
			}
			return false;
//			else if(SmsMessageUtil.sendSMSMsg("smsmsg_content_template1", phone, code).indexOf("result=0")!=-1){
//				return true;
//			}else if(SmsMessageUtil.sendSMSMsg("smsmsg_content_template3", phone, code).indexOf("result=0")!=-1){
//				return true;
//			}else{
//				String content = SmsMessageUtil.buildSmsContent("smsmsg_content_template3", code);
//				return SendMessageUtil.sendMessage(phone, content);
//			}
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
	
	/**
	 * 发送用户快捷登录验证码
	 * @param code  验证码
	 * @param phone  电话号码
	 * @return
	 */
	public static boolean sendLoginVerifiCode(String code,String phone){
		if(!SendMessageUtil.isMobileNO(phone))
			return false;
		try {
			if(ESMSMessageSend.sendMessage(SmsMessageUtil.buildSmsContent("smsmsg_content_login", code), phone, code).indexOf("result=0")!=-1){
				return true;
			}
			return false;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
	/**
	 * 发送用户订单串码
	 * @param code  串码
	 * @param phone  电话号码
	 * @return
	 */
	public static boolean sendOrderVerifiCode(String code,String phone){
		if(!SendMessageUtil.isMobileNO(phone))
			return false;
		try {
			if(ESMSMessageSend.sendMessage(SmsMessageUtil.buildSmsContent("smsmsg_content_order", code), phone, code).indexOf("result=0")!=-1){
				return true;
			}
			return false;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
}
