/*
 * Decompiled with CFR 0.152.
 */
package cn.wangdian.erp.sdk.impl;

import cn.wangdian.erp.sdk.Client;
import cn.wangdian.erp.sdk.Pager;
import cn.wangdian.erp.sdk.WdtErpException;
import cn.wangdian.erp.sdk.impl.Api;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;

public class ApiFactory {
    public static <T> T get(Client client, Class<T> iface) {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new DynamicProxy(client));
    }

    private static class DynamicProxy
    implements InvocationHandler {
        private Client client;

        public DynamicProxy(Client client) {
            this.client = client;
        }

        @Override
        public Object invoke(Object inst, Method method, Object[] args) throws Throwable {
            Api api = method.getAnnotation(Api.class);
            if (api == null) {
                throw new WdtErpException(-1, "Api Name not indicated");
            }
            Pager pager = null;
            if (api.paged()) {
                int len = args.length;
                pager = (Pager)args[len - 1];
                Object[] newParams = new Object[len - 1];
                System.arraycopy(args, 0, newParams, 0, len - 1);
                args = newParams;
            }
            Type returnType = method.getGenericReturnType();
            return this.client.execute(api.value(), args, pager, returnType);
        }
    }
}

