/*
 * Decompiled with CFR 0.152.
 */
package cn.wangdian.erp.sdk.impl;

import cn.wangdian.erp.sdk.Client;
import cn.wangdian.erp.sdk.Pager;
import cn.wangdian.erp.sdk.WdtErpException;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;

public class DefaultClient
implements Client {
    private static final String WDT_SERVICE_URL = "http://wdt.wangdian.cn/";
    public static final String version = "1.0";
    private static final int WDT_UNIX_TIMESTAMP_DIFF = 1325347200;
    private String sid;
    private String url;
    private String key;
    private String secret;
    private String salt;
    private int timeout = 30000;
    private boolean isMultiTenantMode = false;
    private static Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Boolean.TYPE, BooleanJsonDeserializer.INSTANCE).registerTypeAdapter((Type)((Object)Boolean.class), BooleanJsonDeserializer.INSTANCE).create();
    private static JsonParser parser = new JsonParser();

    private DefaultClient(String sid, String url, String key, String secret, boolean isMultiTenantMode) {
        url = url.endsWith("/") ? url + "openapi" : url + "/openapi";
        this.url = url;
        this.sid = sid;
        this.key = key;
        int pos = secret.indexOf(58);
        this.secret = secret.substring(0, pos);
        this.salt = secret.substring(pos + 1);
        this.isMultiTenantMode = isMultiTenantMode;
    }

    private String urlEncode(String data) {
        try {
            return URLEncoder.encode(data, String.valueOf(StandardCharsets.UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String ToQueryString(Map<String, String> args) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> item : args.entrySet()) {
            if (!first) {
                sb.append('&');
            } else {
                first = false;
            }
            sb.append(this.urlEncode(item.getKey()));
            sb.append('=');
            sb.append(this.urlEncode(item.getValue()));
        }
        return sb.toString();
    }

    private static String md5(String info) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(info.getBytes(StandardCharsets.UTF_8));
            byte[] md5Array = md5.digest();
            return DefaultClient.bytesToHex(md5Array);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHex(byte[] md5Array) {
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < md5Array.length; ++i) {
            int temp = 0xFF & md5Array[i];
            String hexString = Integer.toHexString(temp);
            if (hexString.length() == 1) {
                strBuilder.append("0").append(hexString);
                continue;
            }
            strBuilder.append(hexString);
        }
        return strBuilder.toString();
    }

    private String sign(Map<String, String> args, String secret) {
        StringBuilder sb = new StringBuilder();
        sb.append(secret);
        for (Map.Entry<String, String> item : args.entrySet()) {
            if (item.getKey().equals("sign")) continue;
            sb.append(item.getKey());
            sb.append(item.getValue());
        }
        sb.append(secret);
        return DefaultClient.md5(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(String method, Object[] args, Pager pager, Type returnType) throws WdtErpException, IOException {
        String responseBody;
        TreeMap<String, String> requestParams = new TreeMap<String, String>();
        requestParams.put("sid", this.sid);
        requestParams.put("key", this.key);
        requestParams.put("method", method);
        requestParams.put("salt", this.salt);
        requestParams.put("timestamp", Integer.toString((int)(System.currentTimeMillis() / 1000L - 1325347200L)));
        requestParams.put("v", version);
        if (pager != null) {
            requestParams.put("page_size", Integer.toString(pager.getPageSize()));
            requestParams.put("page_no", Integer.toString(pager.getPageNo()));
            requestParams.put("calc_total", pager.isCalcTotal() ? "1" : "0");
        }
        String body = gson.toJson(args);
        requestParams.put("body", body);
        String sign = this.sign(requestParams, this.secret);
        requestParams.remove("body");
        requestParams.put("sign", sign);
        String requestUrl = this.url + "?" + this.ToQueryString(requestParams);
        PrintWriter outWriter = null;
        BufferedReader inReader = null;
        try {
            int len;
            URL url = new URL(requestUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            if (this.isMultiTenantMode) {
                conn.setRequestProperty("Connection", "close");
            }
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStream outStream = conn.getOutputStream();
            outWriter = new PrintWriter(new OutputStreamWriter(outStream, StandardCharsets.UTF_8));
            outWriter.write(body);
            outWriter.flush();
            InputStream in = conn.getInputStream();
            inReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            char[] tmp = new char[256];
            while ((len = inReader.read(tmp)) > 0) {
                sb.append(tmp, 0, len);
            }
            responseBody = sb.toString();
        }
        finally {
            if (outWriter != null) {
                outWriter.close();
            }
            if (inReader != null) {
                inReader.close();
            }
        }
        JsonObject jsonResponse = parser.parse(responseBody).getAsJsonObject();
        int status = jsonResponse.get("status").getAsInt();
        if (status > 0) {
            String message = jsonResponse.get("message").getAsString();
            throw new WdtErpException(status, message);
        }
        if (returnType.equals(Void.TYPE) || returnType.equals(Void.class)) {
            return null;
        }
        Object result = !jsonResponse.has("data") ? null : (jsonResponse.get("data").isJsonArray() ? gson.fromJson((JsonElement)jsonResponse, returnType) : gson.fromJson(jsonResponse.get("data"), returnType));
        if (pager == null || !pager.isCalcTotal() || result == null || !(returnType instanceof Class)) {
            return result;
        }
        if (!jsonResponse.has("total")) {
            return result;
        }
        Class returnClass = (Class)returnType;
        try {
            Method[] methods;
            for (Method m : methods = returnClass.getDeclaredMethods()) {
                Class<?>[] argsType;
                if (!m.getName().equals("setTotal") || (argsType = m.getParameterTypes()).length != 1) continue;
                Class<?> argType = argsType[0];
                if (argType == Integer.class || argType == Integer.TYPE) {
                    m.invoke(result, jsonResponse.get("total").getAsInt());
                } else {
                    if (argType != Long.class && argType != Long.TYPE) continue;
                    m.invoke(result, jsonResponse.get("total").getAsLong());
                }
                break;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public static Client get(String sid, String url, String key, String secret, boolean isMultiTenantMode) {
        return new DefaultClient(sid, url, key, secret, isMultiTenantMode);
    }

    public static Client get(String sid, String url, String key, String secret) {
        return new DefaultClient(sid, url, key, secret, false);
    }

    public static Client get(String sid, String key, String secret) {
        return new DefaultClient(sid, WDT_SERVICE_URL, key, secret, false);
    }

    private static class BooleanJsonDeserializer
    implements JsonDeserializer<Boolean> {
        static final BooleanJsonDeserializer INSTANCE = new BooleanJsonDeserializer();

        private BooleanJsonDeserializer() {
        }

        @Override
        public Boolean deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                JsonPrimitive primitive = (JsonPrimitive)json;
                if (primitive.isBoolean()) {
                    return primitive.getAsBoolean();
                }
                if (primitive.isNumber()) {
                    Number num = primitive.getAsNumber();
                    if (num instanceof Integer || num instanceof Long || num instanceof Short || num instanceof Byte) {
                        return num.intValue() != 0;
                    }
                    return num.doubleValue() != 0.0;
                }
            }
            return !json.isJsonNull();
        }
    }
}

