/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.excel;

import cn.wine.common.excel.ExcelDataLoader;
import cn.wine.common.excel.ExcelWriteReqVO;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class ExcelUtils {
    public static <T> void writeExcel(File file, ExcelWriteReqVO<T> reqVO) throws Exception {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ExcelUtils.writeExcel(reqVO, fileOutputStream);
        }
    }

    public static <T> void writeExcel(HttpServletResponse response, String fileName, ExcelWriteReqVO<T> reqVO) throws Exception {
        ExcelUtils.writeExcel(reqVO, ExcelUtils.getOutputStream(fileName, response));
    }

    private static <T> void writeExcel(ExcelWriteReqVO<T> reqVO, OutputStream outputStream) {
        ExcelDataLoader.ExcelDataLoadResult<T> excelDataLoadResult;
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        ExcelWriterBuilder excelWriterBuilder = EasyExcel.write((OutputStream)outputStream, reqVO.getHeaderClass());
        excelWriterBuilder.excelType(ExcelTypeEnum.XLSX);
        if (CollectionUtils.isNotEmpty(reqVO.getIncludeColumnFiledNames())) {
            excelWriterBuilder.includeColumnFiledNames(reqVO.getIncludeColumnFiledNames());
        } else if (CollectionUtils.isNotEmpty(reqVO.getExcludeColumnFiledNames())) {
            excelWriterBuilder.excludeColumnFiledNames(reqVO.getExcludeColumnFiledNames());
        }
        ExcelWriter excelWriter = excelWriterBuilder.build();
        ExcelWriterSheetBuilder excelWriterSheetBuilder = excelWriterBuilder.sheet(reqVO.getSheetName());
        ExcelWriterSheetBuilder writerSheetBuilder = excelWriterSheetBuilder.registerWriteHandler((WriteHandler)horizontalCellStyleStrategy);
        WriteSheet writeSheet = writerSheetBuilder.build();
        boolean hasMoreData = true;
        while (hasMoreData && (excelDataLoadResult = reqVO.getDataLoader().load()) != null) {
            hasMoreData = excelDataLoadResult.isHasMoreData();
            if (!CollectionUtils.isNotEmpty(excelDataLoadResult.getData())) continue;
            excelWriter.write(excelDataLoadResult.getData(), writeSheet);
        }
        excelWriter.finish();
    }

    private static OutputStream getOutputStream(String fileName, HttpServletResponse response) throws Exception {
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
        return response.getOutputStream();
    }
}

