/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.jackson.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionStringifyAnnotationFieldJsonSerializer
extends JsonSerializer<Collection<Long>> {
    private static final Logger log = LoggerFactory.getLogger(CollectionStringifyAnnotationFieldJsonSerializer.class);

    public void serialize(Collection<Long> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        gen.writeStartArray();
        if (CollectionUtils.isEmpty(value)) {
            gen.writeEndArray();
            return;
        }
        for (Long longValue : value) {
            gen.writeString(String.valueOf(longValue));
        }
        gen.writeEndArray();
    }
}

