/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.support.rest;

import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@ConditionalOnProperty(value={"wine.security.cors.enable"}, havingValue="true")
@Configuration
public class CorsConfig {
    private static final Logger log = LoggerFactory.getLogger(CorsConfig.class);
    @Value(value="${wine.security.cors.pathPattern:/**}")
    private String pathPattern;
    @Value(value="${wine.security.cors.allowedHeaders:*}")
    private String allowedHeaders;
    @Value(value="${wine.security.cors.allowedMethods:*}")
    private String allowedMethods;
    @Value(value="${wine.security.cors.allowedOrigins:*}")
    private String allowedOrigins;

    @Bean
    public FilterRegistrationBean corsFilter() {
        log.info("Add CORS configuration pathPattern:{}, allowedHeaders:{}, allowedMethods:{}, allowedOrigins:{}", new Object[]{this.pathPattern, this.allowedHeaders, this.allowedMethods, this.allowedOrigins});
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin(this.allowedOrigins);
        config.addAllowedHeader(this.allowedHeaders);
        config.addAllowedMethod(this.allowedMethods);
        source.registerCorsConfiguration(this.pathPattern, config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setOrder(Integer.MIN_VALUE);
        return bean;
    }
}

