/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public final class DateUtil {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long TWOHOUR = 0x6DDD00L;
    public static final long DAY = 86400000L;
    public static final long DAY3 = 259200000L;
    public static final long DAY7 = 604800000L;
    public static final long DAY15 = 1296000000L;
    public static final long DAY30 = 2592000000L;
    public static final ThreadLocal<DateFormat> THREAD_LOCAL_OF_SQL99_TIME_FORMAT = new ThreadLocal();
    public static final ThreadLocal<DateFormat> THREAD_LOCAL_OF_DATE_NUMBER_FORMAT = new ThreadLocal();
    public static final ThreadLocal<DateFormat> THREAD_LOCAL_OF_DATE_DAY_FORMAT = new ThreadLocal();

    private DateUtil() {
    }

    private static DateFormat getSql99TimeFormat() {
        if (THREAD_LOCAL_OF_SQL99_TIME_FORMAT.get() == null) {
            THREAD_LOCAL_OF_SQL99_TIME_FORMAT.set(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S"));
        }
        return THREAD_LOCAL_OF_SQL99_TIME_FORMAT.get();
    }

    private static DateFormat getDateNumberFormat() {
        if (THREAD_LOCAL_OF_DATE_NUMBER_FORMAT.get() == null) {
            THREAD_LOCAL_OF_DATE_NUMBER_FORMAT.set(new SimpleDateFormat("yyyyMMdd"));
        }
        return THREAD_LOCAL_OF_DATE_NUMBER_FORMAT.get();
    }

    private static DateFormat getDateDayFormat() {
        if (THREAD_LOCAL_OF_DATE_DAY_FORMAT.get() == null) {
            THREAD_LOCAL_OF_DATE_DAY_FORMAT.set(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        return THREAD_LOCAL_OF_DATE_DAY_FORMAT.get();
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static int betweenDays(Date from, Date to) {
        long duration = to.getTime() - from.getTime();
        return (int)(duration / 86400000L + (long)(duration % 86400000L == 0L ? 0 : 1));
    }

    public static Date weekAgo() {
        Calendar c = Calendar.getInstance();
        c.add(5, -7);
        return new Date(c.getTimeInMillis());
    }

    public static long beforeDays(int days) {
        days = days < 0 ? days : -days;
        Calendar c = Calendar.getInstance();
        c.add(5, days);
        return c.getTimeInMillis();
    }

    public static long afterDays(int days) {
        Calendar c = Calendar.getInstance();
        c.add(5, days);
        return c.getTimeInMillis();
    }

    public static int getWeek1to7(long timeMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMillis);
        int week = c.get(7);
        if (week == 1) {
            return 7;
        }
        return week - 1;
    }

    public static String getWeekName(int week) {
        switch (week) {
            case 1: {
                return "\u5468\u4e00";
            }
            case 2: {
                return "\u5468\u4e8c";
            }
            case 3: {
                return "\u5468\u4e09";
            }
            case 4: {
                return "\u5468\u56db";
            }
            case 5: {
                return "\u5468\u4e94";
            }
            case 6: {
                return "\u5468\u516d";
            }
            case 7: {
                return "\u5468\u65e5";
            }
        }
        return "";
    }

    public static int getTimeInMinute(long timeMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMillis);
        return c.get(11) * 60 + c.get(12);
    }

    public static int getTime(long ts, int calendarType) {
        Calendar calDate = Calendar.getInstance();
        calDate.setTime(new Date(ts));
        return calDate.get(calendarType);
    }

    public static String formatTo24Hour(int minute) {
        if (minute <= 0) {
            return "00:00";
        }
        if (minute >= 1440) {
            return "24:00";
        }
        return DateUtil.prefixDecade(minute / 60) + ":" + DateUtil.prefixDecade(minute % 60);
    }

    private static String prefixDecade(int num) {
        return num >= 10 ? "" + num : "0" + num;
    }

    public static String getMinuteItBPay(Long limitTime) {
        Calendar calendar = Calendar.getInstance();
        Long nowTime = calendar.getTimeInMillis();
        Long betweenMinute = (limitTime - nowTime) / 1000L / 60L;
        return betweenMinute + "m";
    }

    public static String getNowDate() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return DateUtil.format2String(timestamp, "yyyy-MM-dd");
    }

    public static String getNowFmtDatetime(String fmt) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return DateUtil.format2String(timestamp, fmt);
    }

    public static String getDateFormat(Date date, String fmt) {
        Timestamp timestamp = new Timestamp(date.getTime());
        return DateUtil.format2String(timestamp, fmt);
    }

    public static Long getTime(String fmtDateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(fmtDateStr);
        try {
            return sdf.parse(fmtDateStr).getTime();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean isToday(Long currentTime) {
        return new Timestamp(currentTime).toLocalDateTime().toLocalDate().isEqual(LocalDate.now());
    }

    public static boolean isMonth(Long currentTime) {
        GregorianCalendar min = new GregorianCalendar();
        ((Calendar)min).add(5, -30);
        return currentTime >= min.getTimeInMillis();
    }

    public static Long getTodayStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static Long getTodayEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime().getTime();
    }

    public static Long getPresentMonthStartTime() {
        Calendar monthStart = Calendar.getInstance();
        monthStart.set(5, 1);
        monthStart.set(11, 0);
        monthStart.set(12, 0);
        monthStart.set(13, 0);
        monthStart.set(14, 0);
        return monthStart.getTime().getTime();
    }

    public static Long getOneHourAgoTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        return calendar.getTime().getTime();
    }

    public static String longToDateStr(long time, String fmtDateStr) {
        SimpleDateFormat s = new SimpleDateFormat(fmtDateStr);
        String dateStr = s.format(new Date(time));
        return dateStr;
    }

    public static String formatChars(long time) {
        return DateUtil.longToDateStr(time, "yyyy-MM-dd HH:mm:ss");
    }

    public static int getAfterSeconds(Long futureTime) {
        if (futureTime == null) {
            return 0;
        }
        int durationSeconds = (int)((futureTime - System.currentTimeMillis()) / 1000L);
        return durationSeconds >= 0 ? durationSeconds : 0;
    }

    public static int hourToMinutes(String hourOfDay) {
        if (StringUtils.isBlank((CharSequence)hourOfDay)) {
            return 0;
        }
        int hour = Integer.valueOf(StringUtils.substringBefore((String)hourOfDay, (String)":"));
        int minute = Integer.valueOf(StringUtils.substringAfter((String)hourOfDay, (String)":"));
        return hour * 60 + minute;
    }

    public static Long getAgeTime(Integer age) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        calendar.add(1, -age.intValue());
        return calendar.getTime().getTime();
    }

    public static Long getAccountPayTime(Integer minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -minute.intValue());
        return calendar.getTime().getTime();
    }

    public static Date getTargetTime(Timestamp time) {
        Calendar c = Calendar.getInstance();
        c.set(11, time.getHours());
        c.set(12, time.getMinutes());
        c.set(13, time.getSeconds());
        return c.getTime();
    }

    public static LocalDateTime getTargetLocalDateTime(Timestamp time) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(time.toInstant(), ZoneId.systemDefault());
        return LocalDateTime.of(LocalDate.now(), localDateTime.toLocalTime());
    }

    public static boolean isTimesIntersection(Date start1, Date end1, Date start2, Date end2) {
        long start1l = start1.getTime();
        long end1l = end1.getTime();
        long start2l = start2.getTime();
        long end2l = end2.getTime();
        return end1l >= start2l && start1l <= end2l;
    }

    public static boolean isDateBetween(Date compare, Date start, Date end) {
        if (compare == null || start == null || end == null) {
            return false;
        }
        long cl = compare.getTime();
        long sl = start.getTime();
        long el = end.getTime();
        return cl >= sl && cl <= el;
    }

    public static boolean isNowBetween(Date start, Date end) {
        return DateUtil.isDateBetween(new Date(), start, end);
    }

    public static boolean isAfter(Date date) {
        return date != null && System.currentTimeMillis() >= date.getTime();
    }

    public static boolean isBefore(Date date) {
        return date != null && System.currentTimeMillis() < date.getTime();
    }

    public static String getTodayBeginTimeWithSql99Format() {
        return DateUtil.getSql99TimeFormat().format(new Date(DateUtil.getTodayStartTime()));
    }

    public static String getTodayEndTimeWithSql99Format() {
        return DateUtil.getSql99TimeFormat().format(new Date(DateUtil.getTodayEndTime()));
    }

    public static String getPresentMonthStartTimeWithSql99Format() {
        return DateUtil.getSql99TimeFormat().format(new Date(DateUtil.getPresentMonthStartTime()));
    }

    public static String getYesterDayBeiginTimeWithSql99Format() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(DateUtil.getTodayStartTime()));
        calendar.add(5, -1);
        return DateUtil.getSql99TimeFormat().format(calendar.getTime());
    }

    public static String getYesterDayEndTimeWithSql99Format() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(DateUtil.getTodayEndTime()));
        calendar.add(5, -1);
        return DateUtil.getSql99TimeFormat().format(calendar.getTime());
    }

    public static String getDateWithFormat(DateFormat df) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 0);
        return df.format(calendar.getTime());
    }

    public static String getLastDateWithFormat(DateFormat df) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return df.format(calendar.getTime());
    }

    public static String getLastDateWithNumberFormat() {
        return DateUtil.getLastDateWithFormat(DateUtil.getDateNumberFormat());
    }

    public static String getDateFormat() {
        return DateUtil.getDateWithFormat(DateUtil.getDateDayFormat());
    }

    public static String getDateTimeFormat(Timestamp timestamp) {
        return DateUtil.format2String(timestamp, "yyyyMMddHHmmss");
    }

    public static Timestamp newTimestamp(String fmtDateStr) {
        return new Timestamp(DateUtil.getTime(fmtDateStr));
    }

    public static Timestamp getTimestamp(String dateStr) {
        if (StringUtils.isNotBlank((CharSequence)dateStr) && dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
            return DateUtil.getTimestamp(dateStr, "yyyy-MM-dd");
        }
        return DateUtil.getTimestamp(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static Timestamp getTimestamp(String dateStr, String dateFmt) {
        Timestamp timestamp = null;
        SimpleDateFormat f = new SimpleDateFormat(dateFmt);
        try {
            timestamp = new Timestamp(f.parse(dateStr).getTime());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return timestamp;
    }

    public static Long getYesterdayStartTime() {
        Calendar calendar = Calendar.getInstance();
        Date now = new Date();
        calendar.set(5, now.getDate() - 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public static Long getYesterdayEndTime() {
        Calendar calendar = Calendar.getInstance();
        Date now = new Date();
        calendar.set(5, now.getDate() - 1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Long getDayEndTime(String dateStr, String fmt) {
        Timestamp timestamp = DateUtil.getTimestamp(dateStr, fmt);
        if (timestamp == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime().getTime();
    }

    public static String format2String(Timestamp ts) {
        return DateUtil.format2String(ts, null);
    }

    public static String format2String(LocalDateTime time) {
        return DateUtil.format2String(Timestamp.valueOf(time), null);
    }

    public static String format2String(Timestamp ts, String fmt) {
        if (ts == null) {
            return null;
        }
        if (fmt == null) {
            fmt = "yyyy-MM-dd HH:mm:ss";
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(fmt);
            return sdf.format(ts);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LocalDateTime formatToLocalDateTime(String date, String fmt) {
        try {
            if (StringUtils.isBlank((CharSequence)fmt)) {
                fmt = "yyyy-MM-dd HH:mm:ss";
            }
            SimpleDateFormat sdf = new SimpleDateFormat(fmt);
            Instant instant = sdf.parse(date).toInstant();
            ZoneId zone = ZoneId.systemDefault();
            return LocalDateTime.ofInstant(instant, zone);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatToLocalDateTime(LocalDateTime date, String fmt) {
        try {
            if (StringUtils.isBlank((CharSequence)fmt)) {
                fmt = "yyyy-MM-dd HH:mm:ss";
            }
            SimpleDateFormat sdf = new SimpleDateFormat(fmt);
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = date.atZone(zone).toInstant();
            return sdf.format(Date.from(instant));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatToLocalDateTime(LocalDateTime date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = date.atZone(zone).toInstant();
            return sdf.format(Date.from(instant));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date yesterday(Date today) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.set(5, calendar.get(5) - 1);
        return calendar.getTime();
    }

    public static Date tomorrow(Date today) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.set(5, calendar.get(5) + 1);
        return calendar.getTime();
    }

    public static int getAgeByBirth(Date birthday) {
        int age = 0;
        try {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date());
            Calendar birth = Calendar.getInstance();
            birth.setTime(birthday);
            if (birth.after(now)) {
                age = 0;
            } else {
                age = now.get(1) - birth.get(1);
                if (now.get(6) > birth.get(6)) {
                    ++age;
                }
            }
            return age;
        }
        catch (Exception e) {
            return age;
        }
    }

    public static int getTodayLeftSeconds() {
        LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        Long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
        return seconds.intValue();
    }

    public static Date addMinute(Date date, int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, minute);
        return calendar.getTime();
    }

    public static Date addMillisecond(Date date, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(14, millisecond);
        return calendar.getTime();
    }
}

