/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils;

import cn.wine.common.exception.BusinessSilentException;
import cn.wine.common.exception.CommonExceptions;
import cn.wine.common.exception.ExceptionType;
import cn.wine.common.lang.Alphabet;
import cn.wine.common.utils.AssertUtils;
import cn.wine.common.utils.security.AesCryptographer;
import cn.wine.common.utils.security.MD5Utils;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdUtils {
    private static final Logger log = LoggerFactory.getLogger(OpenIdUtils.class);

    public static String idToOpenId(Long id, String channel) {
        AssertUtils.notNull((Object)id, (ExceptionType)CommonExceptions.PARAM_ERROR, "Argument id is null.");
        AssertUtils.notNull((Object)channel, (ExceptionType)CommonExceptions.PARAM_ERROR, "Argument channel is null.");
        String channelPrefix = OpenIdUtils.buildChannelPrefix(channel);
        String channelMd5 = MD5Utils.instance().digest(channel);
        String processedId = Long.toString(id, 36);
        byte[] encryptId = new AesCryptographer().cbcEncrypt(processedId, channelMd5.substring(0, 16), channelMd5.substring(16));
        return channelPrefix + Base64.getEncoder().encodeToString(encryptId).replaceAll("=", "");
    }

    public static Long openIdToId(String openId, String channel) {
        block3: {
            AssertUtils.notNull((Object)openId, (ExceptionType)CommonExceptions.PARAM_ERROR, "Argument openId is null.");
            AssertUtils.notNull((Object)channel, (ExceptionType)CommonExceptions.PARAM_ERROR, "Argument channel is null.");
            String channelPrefix = OpenIdUtils.buildChannelPrefix(channel);
            if (openId.startsWith(channelPrefix)) {
                try {
                    String channelMd5 = MD5Utils.instance().digest(channel);
                    byte[] bytes = Base64.getDecoder().decode(openId.substring(channelPrefix.length()));
                    String decryptOpenId = new String(new AesCryptographer().cbcDecrypt(bytes, channelMd5.substring(0, 16), channelMd5.substring(16)), "UTF-8");
                    return Long.valueOf(decryptOpenId, 36);
                }
                catch (Throwable e) {
                    if (!log.isTraceEnabled()) break block3;
                    log.trace("Decrypt openId failed.", e);
                }
            }
        }
        throw new BusinessSilentException("Invalid openId");
    }

    private static String buildChannelPrefix(String channel) {
        return Long.toString(Math.abs(Alphabet.toLongValue(channel)), 36);
    }
}

