/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils;

import org.apache.commons.lang3.StringUtils;

public class ValueUtils {
    private ValueUtils() {
    }

    public static Byte getByte(Byte value, Byte defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Long getValue(Long value) {
        return ValueUtils.getValue(value, 0L);
    }

    public static Long getValue(Long value, Long defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Integer getValue(Integer value) {
        return ValueUtils.getValue(value, 0);
    }

    public static Integer getValue(Integer value, Integer defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Double getValue(Double value) {
        return ValueUtils.getValue(value, 0.0);
    }

    public static Double getValue(Double value, Double defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Float getValue(Float value) {
        return ValueUtils.getValue(value, Float.valueOf(0.0f));
    }

    public static Float getValue(Float value, Float defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static Number getValue(Number value) {
        return ValueUtils.getValue(value, (Number)0);
    }

    public static Number getValue(Number value, Number defaultValue) {
        return value == null ? (Number)defaultValue : (Number)value;
    }

    public static String toString(long source, int size) {
        String sourceString = String.valueOf(source);
        if (sourceString.length() >= size) {
            return sourceString;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int whiteSpanSize = size - sourceString.length();
        for (int i = 0; i < whiteSpanSize; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(sourceString);
        return stringBuilder.toString();
    }

    public static Boolean getValue(Boolean booleanValue) {
        return booleanValue != null && booleanValue != false;
    }

    public static Boolean getValue(Boolean booleanValue, Boolean defaultValue) {
        return booleanValue == null ? defaultValue : booleanValue;
    }

    public static <T extends Enum> T getEnumInstance(Class<T> ct, String name) {
        return StringUtils.isBlank((CharSequence)name) ? null : (T)Enum.valueOf(ct, name);
    }

    public static <T> T getValueOrDefault(T obj, T defaultValue) {
        return obj == null ? defaultValue : obj;
    }

    public static String getValue(String value, String defaultValue) {
        return StringUtils.isBlank((CharSequence)value) ? defaultValue : value;
    }
}

