/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.geo;

import cn.wine.common.utils.JsonUtils;
import cn.wine.common.utils.geo.BaiduMapConfig;
import cn.wine.common.utils.geo.vo.GeoDecodeResultVO;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class BaiduMapUtil {
    private static final Logger log = LoggerFactory.getLogger(BaiduMapUtil.class);

    public static String getLocationDecode(BaiduMapConfig baiduMapConfig, Object latitude, Object longitude) {
        RestTemplate restTemplate = new RestTemplate();
        String requestUrl = String.format(baiduMapConfig.getLocationDecodeUrl(), latitude, longitude, baiduMapConfig.getBaiduMapAk());
        return (String)restTemplate.getForObject(requestUrl, String.class, new Object[0]);
    }

    public static String getLocationEncode(BaiduMapConfig baiduMapConfig, String address) {
        RestTemplate restTemplate = new RestTemplate();
        String requestUrl = String.format(baiduMapConfig.getLocationEncodeUrl(), address, baiduMapConfig.getBaiduMapAk());
        return (String)restTemplate.getForObject(requestUrl, String.class, new Object[0]);
    }

    public static GeoDecodeResultVO getLocationByIP(BaiduMapConfig baiduMapConfig, String ip) {
        RestTemplate restTemplate = new RestTemplate();
        String requestUrl = String.format(baiduMapConfig.getLocationByIP(), ip, baiduMapConfig.getBaiduMapAk());
        String result = (String)restTemplate.getForObject(requestUrl, String.class, new Object[0]);
        String province = null;
        String city = null;
        String cityCode = null;
        String district = null;
        if (StringUtils.isNotBlank((String)result)) {
            try {
                LinkedHashMap linkedHashMap = JsonUtils.json2Obj(result, LinkedHashMap.class);
                LinkedHashMap content = (LinkedHashMap)linkedHashMap.get("content");
                LinkedHashMap addressDetail = (LinkedHashMap)content.get("address_detail");
                Object provinceValue = addressDetail.get("province");
                province = provinceValue == null ? null : provinceValue.toString();
                Object cityValue = addressDetail.get("city");
                city = cityValue == null ? null : cityValue.toString();
                Object cityCodeValue = addressDetail.get("city_code");
                cityCode = cityCodeValue == null ? null : cityCodeValue.toString();
                Object districtValue = addressDetail.get("district");
                district = districtValue == null ? null : districtValue.toString();
            }
            catch (Exception e) {
                log.warn("\u767e\u5ea6\u8fd4\u56de\u6570\u636e\u6709\u53d8\u5316\uff0c\u8bf7\u5f00\u53d1\u6ce8\u610f\u66f4\u65b0, \u8fd4\u56de\u503c:{}", (Object)result, (Object)e);
            }
        }
        return GeoDecodeResultVO.of(result, province, city, cityCode, district);
    }
}

