/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.geo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoParser {
    private static final Logger log = LoggerFactory.getLogger(GeoParser.class);
    public static String[] provinceIgnoreSuffix = new String[]{"\u7701", "\u81ea\u6cbb\u533a", "\u7279\u522b\u884c\u653f\u533a", "\u5e02"};
    public static String[] cityIgnoreSuffix = new String[]{"\u5e02", "\u81ea\u6cbb\u5dde", "\u5730\u533a", "\u7fa4\u5c9b"};
    public static String[] districtIgnoreSuffix = new String[]{"\u53bf", "\u533a", "\u5e02"};
    public int DEFAULT_MINIMUM_PROVINCE_MATCHED_LENGTH = 2;
    public int DEFAULT_MINIMUM_CITY_MATCHED_LENGTH = 2;
    public int DEFAULT_MINIMUM_DISTRICT_MATCHED_LENGTH = 2;
    private Set<IdAndNameAndParentId> provinces;
    private StringMatcher provinceMatcher;
    private Set<IdAndNameAndParentId> cities;
    private StringMatcher cityMatcher;
    private Set<IdAndNameAndParentId> districts;
    private StringMatcher districtMatcher;
    private boolean allowDistrictMatchByCharts;

    public GeoParser(Set<IdAndNameAndParentId> provinces, Set<IdAndNameAndParentId> cities, Set<IdAndNameAndParentId> districts, Boolean allowDistrictMatchByCharts) {
        this.provinces = provinces;
        this.cities = cities;
        this.districts = districts;
        this.allowDistrictMatchByCharts = allowDistrictMatchByCharts == null ? true : allowDistrictMatchByCharts;
    }

    public IdAndNameAndParentId parseProvince(String address) {
        return this.matchProvince(address).bestCandidate.source;
    }

    @Nonnull
    private StringMatcher.MatchResult matchProvince(String address) {
        if (CollectionUtils.isEmpty(this.provinces) || StringUtils.isBlank((CharSequence)address)) {
            return StringMatcher.NULL;
        }
        if (this.provinceMatcher == null) {
            this.provinceMatcher = new StringMatcher(this.provinces, this.DEFAULT_MINIMUM_PROVINCE_MATCHED_LENGTH, false, provinceIgnoreSuffix);
        }
        return this.provinceMatcher.match(address);
    }

    @Nonnull
    public IdAndNameAndParentId parseCity(String address) {
        return this.matchCityForProvince(address, null).bestCandidate.source;
    }

    @Nonnull
    private StringMatcher.MatchResult matchCityForProvince(String address, StringMatcher.MatchResult province) {
        if (CollectionUtils.isEmpty(this.cities) || StringUtils.isBlank((CharSequence)address)) {
            return StringMatcher.NULL;
        }
        if (this.cityMatcher == null) {
            this.cityMatcher = new StringMatcher(this.cities, this.DEFAULT_MINIMUM_CITY_MATCHED_LENGTH, false, cityIgnoreSuffix);
        }
        return province == null || !province.isMatched() ? this.cityMatcher.match(address) : this.cityMatcher.match(address, province);
    }

    @Nonnull
    public IdAndNameAndParentId parseDistrict(String address) {
        return this.matchDistrictForCities(address, new StringMatcher.MatchResult[0]).bestCandidate.source;
    }

    @Nonnull
    private StringMatcher.MatchResult matchDistrictForCities(String address, StringMatcher.MatchResult ... cities) {
        if (CollectionUtils.isEmpty(this.districts) || StringUtils.isBlank((CharSequence)address)) {
            return StringMatcher.NULL;
        }
        if (this.districtMatcher == null) {
            this.districtMatcher = new StringMatcher(this.districts, this.DEFAULT_MINIMUM_DISTRICT_MATCHED_LENGTH, this.allowDistrictMatchByCharts, districtIgnoreSuffix);
        }
        return ArrayUtils.isEmpty((Object[])cities) ? this.districtMatcher.match(address) : this.districtMatcher.match(address, cities);
    }

    @Nonnull
    public GeoParseResult parse(@NotNull String address) {
        StringMatcher.MatchResult cityMatchResultByProvinceAddress;
        String addressForProvinceParse;
        if (StringUtils.isBlank((CharSequence)address)) {
            return GeoParseResult.builder().originalAddress(address).build();
        }
        String addressForCityParse = addressForProvinceParse = StringUtils.trim((String)address);
        StringMatcher.MatchResult provinceMatchResult = this.matchProvince(addressForProvinceParse);
        IdAndNameAndParentId province = null;
        if (provinceMatchResult.isMatched()) {
            province = provinceMatchResult.bestCandidate.source;
            addressForCityParse = this.fixedAddress(addressForProvinceParse, provinceMatchResult);
        }
        String addressForDistrictParse = addressForCityParse;
        StringMatcher.MatchResult cityMatchResult = this.matchCityForProvince(addressForCityParse, provinceMatchResult);
        IdAndNameAndParentId city = null;
        if (cityMatchResult.isMatched()) {
            city = cityMatchResult.bestCandidate.source;
            addressForDistrictParse = this.fixedAddress(addressForCityParse, cityMatchResult);
        } else if (provinceMatchResult.isMatched() && (cityMatchResultByProvinceAddress = this.matchCityForProvince(addressForProvinceParse, null)).isMatched()) {
            if (Objects.equals(cityMatchResultByProvinceAddress.getBestCandidate().source.getParentId(), provinceMatchResult.getBestCandidate().getSource().getId())) {
                cityMatchResult = cityMatchResultByProvinceAddress;
                city = cityMatchResultByProvinceAddress.getBestCandidate().source;
            } else if (StringUtils.isBlank((CharSequence)cityMatchResultByProvinceAddress.getMatchedKey())) {
                cityMatchResult = cityMatchResultByProvinceAddress;
                city = cityMatchResultByProvinceAddress.getBestCandidate().source;
                provinceMatchResult = StringMatcher.MatchResult.builder().bestCandidate(new StringMatcher.SourceAndScore(this.findProvinceById(city.getParentId()), 0)).build();
            }
        }
        StringMatcher.MatchResult districtMatchResult = this.getMatchResult(addressForDistrictParse, provinceMatchResult, cityMatchResult);
        if (!districtMatchResult.isMatched() && cityMatchResult.isMatched() && provinceMatchResult.isMatched()) {
            districtMatchResult = this.getMatchResult(addressForCityParse, provinceMatchResult, cityMatchResult);
        }
        IdAndNameAndParentId district = null;
        if (districtMatchResult.isMatched()) {
            district = districtMatchResult.bestCandidate.source;
            if (CollectionUtils.isEmpty(districtMatchResult.getCandidates())) {
                if (city == null) {
                    city = this.findCityById(district.getParentId());
                } else if (!Objects.equals(district.getParentId(), city.id) && province != null) {
                    IdAndNameAndParentId cityByIdAndProvinceId = this.findCityByIdAndProvinceId(district.getParentId(), province.getId());
                    if (cityByIdAndProvinceId != null) {
                        city = cityByIdAndProvinceId;
                    } else {
                        district = null;
                    }
                }
            } else if (city == null) {
                for (StringMatcher.SourceAndScore candidate : districtMatchResult.getCandidates()) {
                    IdAndNameAndParentId cityById = this.findCityById(candidate.source.parentId);
                    if (cityById == null) continue;
                    if (province != null) {
                        if (!Objects.equals(cityById.getParentId(), province.id)) continue;
                        district = candidate.source;
                        city = cityById;
                        break;
                    }
                    district = candidate.source;
                    city = cityById;
                    break;
                }
                if (city == null) {
                    district = null;
                }
            } else if (!Objects.equals(district.getParentId(), city.id)) {
                if (province != null) {
                    for (StringMatcher.SourceAndScore candidate : districtMatchResult.getCandidates()) {
                        IdAndNameAndParentId cityByIdAndProvinceId = this.findCityByIdAndProvinceId(candidate.source.getParentId(), province.id);
                        if (cityByIdAndProvinceId == null) continue;
                        city = cityByIdAndProvinceId;
                        district = candidate.source;
                        break;
                    }
                } else {
                    String parentCityId = city.getId();
                    List candidatesOfCity = districtMatchResult.getCandidates().stream().filter(p -> Objects.equals(p.getSource().getParentId(), parentCityId)).collect(Collectors.toList());
                    if (candidatesOfCity.isEmpty()) {
                        district = null;
                    } else {
                        IdAndNameAndParentId idAndNameAndParentId = district = candidatesOfCity.size() == 1 ? ((StringMatcher.SourceAndScore)candidatesOfCity.get(0)).source : ((StringMatcher.SourceAndScore)Sets.newTreeSet(candidatesOfCity).iterator().next()).source;
                    }
                }
            }
        }
        if (!(city == null || province != null && Objects.equals(city.parentId, province.id))) {
            province = this.findProvinceById(city.getParentId());
        }
        return GeoParseResult.builder().originalAddress(address).province(province).city(city).district(district).build();
    }

    private StringMatcher.MatchResult getMatchResult(String addressForDistrictParse, StringMatcher.MatchResult provinceMatchResult, StringMatcher.MatchResult cityMatchResult) {
        StringMatcher.MatchResult districtMatchResult = cityMatchResult.isMatched() ? this.matchDistrictForCities(addressForDistrictParse, cityMatchResult) : (provinceMatchResult.isMatched() ? this.matchDistrictForCities(addressForDistrictParse, this.findByParentId(this.cities, provinceMatchResult.bestCandidate.source.getId())) : this.matchDistrictForCities(addressForDistrictParse, new StringMatcher.MatchResult[0]));
        return districtMatchResult;
    }

    private IdAndNameAndParentId findProvinceById(String id) {
        for (IdAndNameAndParentId sourceProvince : this.provinces) {
            if (!Objects.equals(sourceProvince.getId(), id)) continue;
            return sourceProvince;
        }
        return null;
    }

    private IdAndNameAndParentId findCityById(String id) {
        for (IdAndNameAndParentId sourceCity : this.cities) {
            if (!Objects.equals(sourceCity.getId(), id)) continue;
            return sourceCity;
        }
        return null;
    }

    private IdAndNameAndParentId findCityByIdAndProvinceId(String id, String provinceId) {
        for (IdAndNameAndParentId sourceCity : this.cities) {
            if (!Objects.equals(sourceCity.getId(), id) || !Objects.equals(sourceCity.getParentId(), provinceId)) continue;
            return sourceCity;
        }
        return null;
    }

    private String fixedAddress(String sourceKey, StringMatcher.MatchResult matchResult) {
        if (matchResult != StringMatcher.NULL && sourceKey.contains(matchResult.sourceKey)) {
            return sourceKey.split(matchResult.sourceKey, 2)[1];
        }
        if (matchResult != StringMatcher.NULL && sourceKey.contains(matchResult.matchedKey)) {
            return sourceKey.split(matchResult.matchedKey, 2)[1];
        }
        if (matchResult != StringMatcher.NULL && StringUtils.isNotBlank((CharSequence)matchResult.matchedKey)) {
            char[] matchedChars;
            for (char matchedChar : matchedChars = matchResult.matchedKey.toCharArray()) {
                sourceKey = sourceKey.replaceFirst(String.valueOf(matchedChar), "");
            }
        }
        return sourceKey;
    }

    private StringMatcher.MatchResult[] findByParentId(Collection<IdAndNameAndParentId> candidates, String parentId) {
        return (StringMatcher.MatchResult[])candidates.stream().filter(p -> p.getParentId().equals(parentId)).distinct().map(e -> new StringMatcher.MatchResult(true, null, null, new StringMatcher.SourceAndScore((IdAndNameAndParentId)e, 0), null)).distinct().toArray(StringMatcher.MatchResult[]::new);
    }

    public static GeoParserBuilder builder() {
        return new GeoParserBuilder();
    }

    public static class GeoParserBuilder {
        private Set<IdAndNameAndParentId> provinces;
        private Set<IdAndNameAndParentId> cities;
        private Set<IdAndNameAndParentId> districts;
        private Boolean allowDistrictMatchByCharts;

        GeoParserBuilder() {
        }

        public GeoParserBuilder provinces(Set<IdAndNameAndParentId> provinces) {
            this.provinces = provinces;
            return this;
        }

        public GeoParserBuilder cities(Set<IdAndNameAndParentId> cities) {
            this.cities = cities;
            return this;
        }

        public GeoParserBuilder districts(Set<IdAndNameAndParentId> districts) {
            this.districts = districts;
            return this;
        }

        public GeoParserBuilder allowDistrictMatchByCharts(Boolean allowDistrictMatchByCharts) {
            this.allowDistrictMatchByCharts = allowDistrictMatchByCharts;
            return this;
        }

        public GeoParser build() {
            return new GeoParser(this.provinces, this.cities, this.districts, this.allowDistrictMatchByCharts);
        }

        public String toString() {
            return "GeoParser.GeoParserBuilder(provinces=" + this.provinces + ", cities=" + this.cities + ", districts=" + this.districts + ", allowDistrictMatchByCharts=" + this.allowDistrictMatchByCharts + ")";
        }
    }

    public static class GeoParseResult {
        private String originalAddress;
        @Nullable
        private IdAndNameAndParentId province;
        @Nullable
        private IdAndNameAndParentId city;
        @Nullable
        private IdAndNameAndParentId district;

        @Nullable
        public String getFullAddress() {
            if (this.district != null) {
                return (this.province == null ? "" : this.province.getName()) + (this.city == null ? "" : this.city.getName()) + this.district.getName();
            }
            return this.originalAddress;
        }

        @JsonIgnore
        @Nullable
        public String getProvinceId() {
            return this.province == null ? null : this.province.getId();
        }

        @JsonIgnore
        @Nullable
        public String getCityId() {
            return this.city == null ? null : this.city.getId();
        }

        @JsonIgnore
        @Nullable
        public String getDistrictId() {
            return this.district == null ? null : this.district.getId();
        }

        GeoParseResult(String originalAddress, @Nullable IdAndNameAndParentId province, @Nullable IdAndNameAndParentId city, @Nullable IdAndNameAndParentId district) {
            this.originalAddress = originalAddress;
            this.province = province;
            this.city = city;
            this.district = district;
        }

        public static GeoParseResultBuilder builder() {
            return new GeoParseResultBuilder();
        }

        public String getOriginalAddress() {
            return this.originalAddress;
        }

        @Nullable
        public IdAndNameAndParentId getProvince() {
            return this.province;
        }

        @Nullable
        public IdAndNameAndParentId getCity() {
            return this.city;
        }

        @Nullable
        public IdAndNameAndParentId getDistrict() {
            return this.district;
        }

        public String toString() {
            return "GeoParser.GeoParseResult(originalAddress=" + this.getOriginalAddress() + ", province=" + this.getProvince() + ", city=" + this.getCity() + ", district=" + this.getDistrict() + ")";
        }

        public static class GeoParseResultBuilder {
            private String originalAddress;
            private IdAndNameAndParentId province;
            private IdAndNameAndParentId city;
            private IdAndNameAndParentId district;

            GeoParseResultBuilder() {
            }

            public GeoParseResultBuilder originalAddress(String originalAddress) {
                this.originalAddress = originalAddress;
                return this;
            }

            public GeoParseResultBuilder province(IdAndNameAndParentId province) {
                this.province = province;
                return this;
            }

            public GeoParseResultBuilder city(IdAndNameAndParentId city) {
                this.city = city;
                return this;
            }

            public GeoParseResultBuilder district(IdAndNameAndParentId district) {
                this.district = district;
                return this;
            }

            public GeoParseResult build() {
                return new GeoParseResult(this.originalAddress, this.province, this.city, this.district);
            }

            public String toString() {
                return "GeoParser.GeoParseResult.GeoParseResultBuilder(originalAddress=" + this.originalAddress + ", province=" + this.province + ", city=" + this.city + ", district=" + this.district + ")";
            }
        }
    }

    private static class IdAndNameAndParentIdForMatch {
        private IdAndNameAndParentId idAndNameAndParentId;
        private String fixedNameForMatch;

        public IdAndNameAndParentIdForMatch(IdAndNameAndParentId idAndNameAndParentId, String fixedNameForMatch) {
            this.idAndNameAndParentId = idAndNameAndParentId;
            this.fixedNameForMatch = fixedNameForMatch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdAndNameAndParentIdForMatch)) {
                return false;
            }
            IdAndNameAndParentIdForMatch other = (IdAndNameAndParentIdForMatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IdAndNameAndParentId this$idAndNameAndParentId = this.idAndNameAndParentId;
            IdAndNameAndParentId other$idAndNameAndParentId = other.idAndNameAndParentId;
            return !(this$idAndNameAndParentId == null ? other$idAndNameAndParentId != null : !((Object)this$idAndNameAndParentId).equals(other$idAndNameAndParentId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdAndNameAndParentIdForMatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IdAndNameAndParentId $idAndNameAndParentId = this.idAndNameAndParentId;
            result = result * 59 + ($idAndNameAndParentId == null ? 43 : ((Object)$idAndNameAndParentId).hashCode());
            return result;
        }
    }

    public static class IdAndNameAndParentId {
        private String id;
        private String name;
        private String nameForMatch;
        private String parentId;
        private IdAndNameAndParentId parent;

        public String getNameForMatch() {
            return this.nameForMatch == null ? this.name : this.nameForMatch;
        }

        public String toString() {
            return this.name + "_" + this.id + "_" + this.parentId;
        }

        public static IdAndNameAndParentIdBuilder builder() {
            return new IdAndNameAndParentIdBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getParentId() {
            return this.parentId;
        }

        public IdAndNameAndParentId getParent() {
            return this.parent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdAndNameAndParentId)) {
                return false;
            }
            IdAndNameAndParentId other = (IdAndNameAndParentId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$nameForMatch = this.getNameForMatch();
            String other$nameForMatch = other.getNameForMatch();
            return !(this$nameForMatch == null ? other$nameForMatch != null : !this$nameForMatch.equals(other$nameForMatch));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdAndNameAndParentId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $nameForMatch = this.getNameForMatch();
            result = result * 59 + ($nameForMatch == null ? 43 : $nameForMatch.hashCode());
            return result;
        }

        public IdAndNameAndParentId() {
        }

        public IdAndNameAndParentId(String id, String name, String nameForMatch, String parentId, IdAndNameAndParentId parent) {
            this.id = id;
            this.name = name;
            this.nameForMatch = nameForMatch;
            this.parentId = parentId;
            this.parent = parent;
        }

        public static class IdAndNameAndParentIdBuilder {
            private String id;
            private String name;
            private String nameForMatch;
            private String parentId;
            private IdAndNameAndParentId parent;

            IdAndNameAndParentIdBuilder() {
            }

            public IdAndNameAndParentIdBuilder id(String id) {
                this.id = id;
                return this;
            }

            public IdAndNameAndParentIdBuilder name(String name) {
                this.name = name;
                return this;
            }

            public IdAndNameAndParentIdBuilder nameForMatch(String nameForMatch) {
                this.nameForMatch = nameForMatch;
                return this;
            }

            public IdAndNameAndParentIdBuilder parentId(String parentId) {
                this.parentId = parentId;
                return this;
            }

            public IdAndNameAndParentIdBuilder parent(IdAndNameAndParentId parent) {
                this.parent = parent;
                return this;
            }

            public IdAndNameAndParentId build() {
                return new IdAndNameAndParentId(this.id, this.name, this.nameForMatch, this.parentId, this.parent);
            }

            public String toString() {
                return "GeoParser.IdAndNameAndParentId.IdAndNameAndParentIdBuilder(id=" + this.id + ", name=" + this.name + ", nameForMatch=" + this.nameForMatch + ", parentId=" + this.parentId + ", parent=" + this.parent + ")";
            }
        }
    }

    private static class StringMatcher
    extends HashMap<String, Set<SourceAndScore>> {
        public static long DEFAULT_CACHE_SIZE = 3000L;
        public static int DEFAULT_EXPIRE_MINUTE = 2;
        private static MatchResult NULL;
        private int maxStringLengthForMatch = 0;
        private int minimumMatchedLength;
        private boolean allowDistrictMatchByCharts = false;
        private Set<IdAndNameAndParentIdForMatch> sources;
        private Cache<String, MatchResult> cache;
        private String[] ignoreSuffixes;

        public StringMatcher(@Nonnull Set<IdAndNameAndParentId> sources, int minimumMatchedLength, boolean allowDistrictMatchByCharts, String ... ignoreSuffixes) {
            this(sources, minimumMatchedLength, allowDistrictMatchByCharts, DEFAULT_CACHE_SIZE, TimeUnit.MINUTES, DEFAULT_EXPIRE_MINUTE, ignoreSuffixes);
        }

        public StringMatcher(@Nonnull Set<IdAndNameAndParentId> sources, int minimumMatchedLength, boolean allowDistrictMatchByCharts, long cacheSize, TimeUnit timeUnit, int cacheExpireTime, String ... ignoreSuffixes) {
            super(sources.size());
            this.allowDistrictMatchByCharts = allowDistrictMatchByCharts;
            this.minimumMatchedLength = Math.max(1, minimumMatchedLength);
            Set processedSource = sources.stream().map(e -> new IdAndNameAndParentIdForMatch((IdAndNameAndParentId)e, e.getNameForMatch())).collect(Collectors.toSet());
            if (ArrayUtils.isNotEmpty((Object[])ignoreSuffixes)) {
                for (IdAndNameAndParentIdForMatch source : processedSource) {
                    for (String ignoreSuffix : ignoreSuffixes) {
                        if (!source.fixedNameForMatch.endsWith(ignoreSuffix)) continue;
                        source.fixedNameForMatch = source.fixedNameForMatch.substring(0, source.fixedNameForMatch.length() - ignoreSuffix.length());
                    }
                }
                this.ignoreSuffixes = ignoreSuffixes;
            }
            this.sources = processedSource;
            if (cacheSize > 0L) {
                this.cache = CacheBuilder.newBuilder().maximumSize(cacheSize).expireAfterWrite((long)cacheExpireTime, timeUnit).build();
            }
            for (IdAndNameAndParentIdForMatch source : processedSource) {
                Set sourceSet = this.getOrDefault(source.fixedNameForMatch, Sets.newTreeSet());
                sourceSet.add(new SourceAndScore(source.idAndNameAndParentId, 100));
                this.put(source.fixedNameForMatch, sourceSet);
                if (!Objects.equals(source.idAndNameAndParentId.getNameForMatch(), source.fixedNameForMatch)) {
                    sourceSet = this.getOrDefault(source.idAndNameAndParentId.getNameForMatch(), Sets.newTreeSet());
                    sourceSet.add(new SourceAndScore(source.idAndNameAndParentId, 100));
                    this.put(source.idAndNameAndParentId.getNameForMatch(), sourceSet);
                }
                this.maxStringLengthForMatch = Math.max(this.maxStringLengthForMatch, source.idAndNameAndParentId.getNameForMatch().length());
            }
            for (IdAndNameAndParentIdForMatch source : processedSource) {
                if (source.fixedNameForMatch.length() <= minimumMatchedLength) continue;
                int startIndex = 0;
                for (int keyEndIndex = minimumMatchedLength; keyEndIndex <= source.fixedNameForMatch.length(); ++keyEndIndex) {
                    String key = source.fixedNameForMatch.substring(startIndex, keyEndIndex);
                    Set sourceAndScoreSet = this.getOrDefault(key, Sets.newTreeSet());
                    SourceAndScore data = new SourceAndScore(source.idAndNameAndParentId, this.maxStringLengthForMatch - startIndex);
                    sourceAndScoreSet.add(data);
                    this.put(key, sourceAndScoreSet);
                    ++startIndex;
                }
            }
        }

        @Nonnull
        public MatchResult match(String address) {
            return this.match(address, new MatchResult[0]);
        }

        @Nonnull
        public MatchResult match(String address, MatchResult ... candidateParents) {
            SourceAndScore candidate;
            MatchResult cachedTarget = this.getFromCache(address, candidateParents);
            if (cachedTarget != null) {
                return cachedTarget;
            }
            String fixedAddress = address;
            HashMap<SourceAndScore, Integer> dataToScore = new HashMap<SourceAndScore, Integer>(fixedAddress.length());
            HashMap<SourceAndScore, Integer> dataToMatchTimes = new HashMap<SourceAndScore, Integer>(fixedAddress.length());
            Set sourceAndScoreSetOfCandidate = (Set)this.get(address);
            if (sourceAndScoreSetOfCandidate == null && ArrayUtils.isNotEmpty((Object[])this.ignoreSuffixes)) {
                boolean addressFixed = false;
                if (fixedAddress.length() > this.minimumMatchedLength) {
                    for (String ignoreSuffix : this.ignoreSuffixes) {
                        if (!address.endsWith(ignoreSuffix)) continue;
                        fixedAddress = address.substring(0, address.length() - ignoreSuffix.length());
                        addressFixed = true;
                        break;
                    }
                }
                if (!addressFixed) {
                    for (String ignoreSuffix : this.ignoreSuffixes) {
                        int suffixIndex = address.indexOf(ignoreSuffix);
                        if (suffixIndex <= 0 || suffixIndex >= this.maxStringLengthForMatch) continue;
                        fixedAddress = address.substring(0, suffixIndex);
                        break;
                    }
                }
                sourceAndScoreSetOfCandidate = (Set)this.get(fixedAddress);
            }
            if (CollectionUtils.isNotEmpty((Collection)sourceAndScoreSetOfCandidate)) {
                if (ArrayUtils.isNotEmpty((Object[])candidateParents)) {
                    for (SourceAndScore sourceAndScoreOfCandidate : sourceAndScoreSetOfCandidate) {
                        for (MatchResult parent : candidateParents) {
                            if (!Objects.equals(sourceAndScoreOfCandidate.getSource().getParentId(), parent.bestCandidate.source.getId())) continue;
                            dataToScore.put(sourceAndScoreOfCandidate, sourceAndScoreOfCandidate.getScore());
                        }
                    }
                }
                if (dataToScore.isEmpty()) {
                    for (SourceAndScore sourceAndScore : sourceAndScoreSetOfCandidate) {
                        dataToScore.put(sourceAndScore, sourceAndScore.getScore());
                    }
                }
            }
            ArrayList<String> matchedKey = new ArrayList<String>(fixedAddress.length());
            int maxIndex = Math.min(this.maxStringLengthForMatch, fixedAddress.length());
            if (dataToScore.isEmpty()) {
                int startIndex = 0;
                for (int keyEndIndex = this.minimumMatchedLength; keyEndIndex <= maxIndex; ++keyEndIndex) {
                    String key = fixedAddress.substring(startIndex, keyEndIndex);
                    Set data = (Set)this.get(key);
                    if (CollectionUtils.isNotEmpty((Collection)data)) {
                        matchedKey.add(key);
                        for (SourceAndScore candidate2 : data) {
                            Integer score = dataToScore.getOrDefault(candidate2, 0);
                            Integer matchedTimes = dataToMatchTimes.getOrDefault(candidate2, 0);
                            dataToScore.put(candidate2, score + candidate2.getScore() - startIndex);
                            dataToMatchTimes.put(candidate2, matchedTimes + 1);
                        }
                    }
                    ++startIndex;
                }
            }
            if (dataToScore.isEmpty()) {
                for (IdAndNameAndParentIdForMatch source : this.sources) {
                    if (!fixedAddress.contains(source.fixedNameForMatch.length() > 1 ? source.fixedNameForMatch : source.idAndNameAndParentId.getNameForMatch())) continue;
                    MatchResult matchResult = MatchResult.builder().matched(true).bestCandidate(new SourceAndScore(source.idAndNameAndParentId, 0)).build();
                    return this.cacheResult(address, StringUtils.join(matchedKey, (String)""), matchResult, candidateParents);
                }
                if (this.allowDistrictMatchByCharts) {
                    fixedAddress = StringUtils.substring((String)fixedAddress, (int)0, (int)this.minimumMatchedLength);
                    if (ArrayUtils.isNotEmpty((Object[])this.ignoreSuffixes)) {
                        for (String ignoreSuffix : this.ignoreSuffixes) {
                            String matchKey = fixedAddress;
                            if (fixedAddress.contains(ignoreSuffix)) {
                                matchKey = fixedAddress.split(ignoreSuffix, 2)[0];
                            }
                            if (StringUtils.isBlank((CharSequence)matchKey)) continue;
                            char[] chars = matchKey.toCharArray();
                            for (int i = 0; i < chars.length; ++i) {
                                String singleKey = String.valueOf(chars[i]);
                                for (IdAndNameAndParentIdForMatch source : this.sources) {
                                    if (!source.fixedNameForMatch.contains(singleKey)) continue;
                                    matchedKey.add(singleKey);
                                    SourceAndScore candidate3 = new SourceAndScore(source.idAndNameAndParentId, maxIndex - source.fixedNameForMatch.indexOf(singleKey));
                                    Integer score = dataToScore.getOrDefault(candidate3, 0);
                                    Integer matchedTimes = dataToMatchTimes.getOrDefault(candidate3, 0);
                                    dataToScore.put(candidate3, score + candidate3.getScore() - i);
                                    dataToMatchTimes.put(candidate3, matchedTimes + 1);
                                }
                            }
                        }
                    }
                }
            }
            if (dataToScore.isEmpty()) {
                return this.cacheResult(address, StringUtils.join(matchedKey, (String)""), NULL, candidateParents);
            }
            SourceAndScore target = null;
            TreeSet candidates = Sets.newTreeSet();
            int previousScore = 0;
            for (Map.Entry dataToScoreEntry : dataToScore.entrySet()) {
                String keyOfMustMatched = ((SourceAndScore)dataToScoreEntry.getKey()).getSource().getNameForMatch().substring(0, this.minimumMatchedLength);
                if (!address.contains(keyOfMustMatched) || address.indexOf(keyOfMustMatched) > this.maxStringLengthForMatch) continue;
                if (ArrayUtils.isNotEmpty((Object[])candidateParents)) {
                    boolean isChildOfCandidateParents = false;
                    for (MatchResult parent : candidateParents) {
                        if (!parent.isMatched() || !Objects.equals(((SourceAndScore)dataToScoreEntry.getKey()).getSource().getParentId(), parent.bestCandidate.source.getId())) continue;
                        isChildOfCandidateParents = true;
                        break;
                    }
                    if (!isChildOfCandidateParents) continue;
                }
                if ((Integer)dataToScoreEntry.getValue() > previousScore) {
                    previousScore = (Integer)dataToScoreEntry.getValue();
                    target = (SourceAndScore)dataToScoreEntry.getKey();
                } else if ((Integer)dataToScoreEntry.getValue() == previousScore && address.contains(((SourceAndScore)dataToScoreEntry.getKey()).source.getNameForMatch()) && address.indexOf(((SourceAndScore)dataToScoreEntry.getKey()).source.getNameForMatch()) < this.maxStringLengthForMatch) {
                    previousScore = (Integer)dataToScoreEntry.getValue();
                    target = (SourceAndScore)dataToScoreEntry.getKey();
                }
                candidates.add(new SourceAndScore(((SourceAndScore)dataToScoreEntry.getKey()).getSource(), (Integer)dataToScoreEntry.getValue()));
            }
            if (target == null && dataToScore.size() == 1 && address.contains((candidate = (SourceAndScore)dataToScore.keySet().iterator().next()).getSource().getNameForMatch()) && address.indexOf(candidate.getSource().getNameForMatch()) < this.maxStringLengthForMatch) {
                target = candidate;
            }
            if (target == null) {
                return this.cacheResult(address, StringUtils.join(matchedKey, (String)""), NULL, candidateParents);
            }
            MatchResult matchResult = MatchResult.builder().matched(true).bestCandidate(target).candidates(candidates).build();
            return this.cacheResult(address, StringUtils.join(matchedKey, (String)""), matchResult, candidateParents);
        }

        private MatchResult getFromCache(String address, MatchResult ... candidateParents) {
            if (ArrayUtils.isEmpty((Object[])candidateParents)) {
                return (MatchResult)this.cache.getIfPresent((Object)address);
            }
            List parentIds = Arrays.stream(candidateParents).map(e -> e.getBestCandidate().getSource().getId()).sorted().collect(Collectors.toList());
            return (MatchResult)this.cache.getIfPresent((Object)(address + StringUtils.join((Object[])new List[]{parentIds})));
        }

        private MatchResult cacheResult(String sourceKey, String matchedKey, @Nonnull MatchResult matchResult, MatchResult ... candidateParents) {
            if (ArrayUtils.isEmpty((Object[])candidateParents)) {
                this.cache.put((Object)sourceKey, (Object)matchResult);
            } else {
                List parentIds = Arrays.stream(candidateParents).map(e -> ((MatchResult)e).bestCandidate.source.getId()).sorted().collect(Collectors.toList());
                this.cache.put((Object)(sourceKey + StringUtils.join((Object[])new List[]{parentIds})), (Object)matchResult);
            }
            if (matchResult.isMatched()) {
                char[] matchedChars;
                matchResult.sourceKey = matchResult.bestCandidate.source.getNameForMatch();
                StringBuilder sb = new StringBuilder();
                for (char matchedChar : matchedChars = matchedKey.toCharArray()) {
                    if (!matchResult.sourceKey.contains(String.valueOf(matchedChar))) continue;
                    sb.append(matchedChar);
                }
                matchResult.matchedKey = sb.toString();
            }
            return matchResult;
        }

        static {
            IdAndNameAndParentId idAndNameAndParentIdOfNull = IdAndNameAndParentId.builder().id("0").name("null").build();
            SourceAndScore sourceAndScoreOfNull = new SourceAndScore(idAndNameAndParentIdOfNull, 0);
            NULL = MatchResult.builder().bestCandidate(sourceAndScoreOfNull).candidates(Sets.newHashSet((Object[])new SourceAndScore[]{sourceAndScoreOfNull})).build();
        }

        private static class MatchResult {
            private boolean matched;
            private String sourceKey;
            private String matchedKey;
            private SourceAndScore bestCandidate;
            private Set<SourceAndScore> candidates;

            public String toString() {
                return String.valueOf(this.bestCandidate);
            }

            MatchResult(boolean matched, String sourceKey, String matchedKey, SourceAndScore bestCandidate, Set<SourceAndScore> candidates) {
                this.matched = matched;
                this.sourceKey = sourceKey;
                this.matchedKey = matchedKey;
                this.bestCandidate = bestCandidate;
                this.candidates = candidates;
            }

            public static MatchResultBuilder builder() {
                return new MatchResultBuilder();
            }

            public boolean isMatched() {
                return this.matched;
            }

            public String getSourceKey() {
                return this.sourceKey;
            }

            public String getMatchedKey() {
                return this.matchedKey;
            }

            public SourceAndScore getBestCandidate() {
                return this.bestCandidate;
            }

            public Set<SourceAndScore> getCandidates() {
                return this.candidates;
            }

            public static class MatchResultBuilder {
                private boolean matched;
                private String sourceKey;
                private String matchedKey;
                private SourceAndScore bestCandidate;
                private Set<SourceAndScore> candidates;

                MatchResultBuilder() {
                }

                public MatchResultBuilder matched(boolean matched) {
                    this.matched = matched;
                    return this;
                }

                public MatchResultBuilder sourceKey(String sourceKey) {
                    this.sourceKey = sourceKey;
                    return this;
                }

                public MatchResultBuilder matchedKey(String matchedKey) {
                    this.matchedKey = matchedKey;
                    return this;
                }

                public MatchResultBuilder bestCandidate(SourceAndScore bestCandidate) {
                    this.bestCandidate = bestCandidate;
                    return this;
                }

                public MatchResultBuilder candidates(Set<SourceAndScore> candidates) {
                    this.candidates = candidates;
                    return this;
                }

                public MatchResult build() {
                    return new MatchResult(this.matched, this.sourceKey, this.matchedKey, this.bestCandidate, this.candidates);
                }

                public String toString() {
                    return "GeoParser.StringMatcher.MatchResult.MatchResultBuilder(matched=" + this.matched + ", sourceKey=" + this.sourceKey + ", matchedKey=" + this.matchedKey + ", bestCandidate=" + this.bestCandidate + ", candidates=" + this.candidates + ")";
                }
            }
        }

        private static class SourceAndScore
        implements Comparable<SourceAndScore> {
            private IdAndNameAndParentId source;
            private int score;

            @Override
            public int compareTo(SourceAndScore o) {
                return ComparisonChain.start().compare(o.getScore(), this.getScore()).compare((Comparable)((Object)this.getSource().getId()), (Comparable)((Object)o.getSource().getId())).result();
            }

            public String toString() {
                return this.source == null ? "null" : this.source.getNameForMatch() + ":" + this.score;
            }

            public SourceAndScore(IdAndNameAndParentId source, int score) {
                this.source = source;
                this.score = score;
            }

            public IdAndNameAndParentId getSource() {
                return this.source;
            }

            public int getScore() {
                return this.score;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SourceAndScore)) {
                    return false;
                }
                SourceAndScore other = (SourceAndScore)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                IdAndNameAndParentId this$source = this.getSource();
                IdAndNameAndParentId other$source = other.getSource();
                return !(this$source == null ? other$source != null : !((Object)this$source).equals(other$source));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SourceAndScore;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                IdAndNameAndParentId $source = this.getSource();
                result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
                return result;
            }
        }
    }
}

