/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.io;

import cn.wine.common.exception.BusinessSilentException;
import cn.wine.common.exception.CommonExceptions;
import cn.wine.common.exception.ExceptionType;
import cn.wine.common.utils.AssertUtils;
import cn.wine.common.utils.IOUtils;
import cn.wine.common.utils.jvm.JvmRuntimeInfoFetcher;
import cn.wine.common.utils.network.UrlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ProcessLockFactory {
    public static Lock getLock(String lockFolderPath, String lockFileName) {
        return ProcessLockFactory.getLock(lockFolderPath, lockFileName, TimeUnit.DAYS, 1);
    }

    public static Lock getLock(final String lockFolderPath, final String lockFileName, final TimeUnit timeUnit, final int lockExpireTime) {
        String trimmedLockFolderPath = StringUtils.trim((String)lockFolderPath);
        String trimmedBusinessKey = StringUtils.trim((String)lockFileName);
        AssertUtils.hasText(trimmedLockFolderPath, (ExceptionType)CommonExceptions.PARAM_ERROR, "Lock folder is blank");
        AssertUtils.hasText(trimmedBusinessKey, (ExceptionType)CommonExceptions.PARAM_ERROR, "Lock file name is blank");
        final File lockFolder = new File(trimmedLockFolderPath);
        if (!lockFolder.exists()) {
            lockFolder.mkdirs();
        }
        final JvmRuntimeInfoFetcher.JvmRuntimeInfo jvmRuntimeInfo = JvmRuntimeInfoFetcher.getInfo();
        Lock lock = new Lock(){

            @Override
            public void close() {
                this.unlock();
            }

            @Override
            public boolean lock() {
                try {
                    File lockFile = new File(lockFolder.getPath() + "/" + lockFileName);
                    if (lockFile.exists() && !ProcessLockFactory.isLockExpired(lockFile, timeUnit, lockExpireTime)) {
                        return false;
                    }
                    boolean createFileSuccess = lockFile.createNewFile();
                    if (createFileSuccess) {
                        IOUtils.write(String.valueOf(jvmRuntimeInfo.getProcessId()).getBytes(StandardCharsets.UTF_8), (OutputStream)new FileOutputStream(lockFile));
                        return true;
                    }
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public void unlock() {
                block4: {
                    try {
                        File lockFile = new File(UrlUtils.join(lockFolderPath, lockFileName));
                        if (!lockFile.exists()) break block4;
                        if (ProcessLockFactory.isLockExpired(lockFile, timeUnit, lockExpireTime)) {
                            lockFile.deleteOnExit();
                            return;
                        }
                        byte[] processId = IOUtils.getBytes(new FileInputStream(lockFile));
                        String pid = new String(processId, StandardCharsets.UTF_8);
                        if (Objects.equals(String.valueOf(jvmRuntimeInfo.getProcessId()), pid)) {
                            lockFile.delete();
                            break block4;
                        }
                        throw new BusinessSilentException(String.format("\u5f53\u524d\u8fdb\u7a0b\u9501\u5c5e\u4e8e\u8fdb\u7a0b[%s]", pid));
                    }
                    catch (Exception e) {
                        throw new BusinessSilentException(String.format("\u89e3\u9501\u5931\u8d25:%s", e.getMessage()));
                    }
                }
            }
        };
        return lock;
    }

    private static boolean isLockExpired(File file, TimeUnit timeUnit, int lockExpireTime) {
        if (timeUnit == null || lockExpireTime < 1) {
            return false;
        }
        long lastModified = file.lastModified();
        return System.currentTimeMillis() - lastModified > timeUnit.toMillis(lockExpireTime);
    }

    public static interface Lock
    extends AutoCloseable {
        public boolean lock();

        public void unlock();
    }
}

