/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.jar;

import cn.wine.common.network.IpUtils;
import cn.wine.common.utils.JsonUtils;
import cn.wine.common.utils.jar.MavenRuntimeInfoEvent;
import cn.wine.common.utils.jar.vo.MavenDependencyVO;
import cn.wine.common.utils.jar.vo.MavenRuntimeVO;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class MavenDependencyCollector {
    private static final Logger log = LoggerFactory.getLogger(MavenDependencyCollector.class);
    public static final String JAR_FILE = "jar";
    @Value(value="${wine.project.code:}")
    private String projectCode;
    @Value(value="${spring.application.name:}")
    private String applicationName;
    @Value(value="${server.port:}")
    private Integer port;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @PostConstruct
    public void collect() throws Exception {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/maven");
            TreeSet<MavenDependencyVO> mavenDependencies = new TreeSet<MavenDependencyVO>();
            while (resources.hasMoreElements()) {
                try {
                    URL url = resources.nextElement();
                    Collection<String> pomPropertySet = this.listPomProperties(url);
                    for (String s : pomPropertySet) {
                        InputStream is = this.getClass().getResourceAsStream(s);
                        Properties properties = new Properties();
                        properties.load(is);
                        String version = properties.getProperty("version");
                        String groupId = properties.getProperty("groupId");
                        String artifactId = properties.getProperty("artifactId");
                        MavenDependencyVO mavenIdentifyRuntimeVO = MavenDependencyVO.builder().groupId(groupId).artifactId(artifactId).version(version).build();
                        mavenDependencies.add(mavenIdentifyRuntimeVO);
                    }
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Load maven properties failed.", (Throwable)e);
                }
            }
            MavenRuntimeVO mavenRuntimeVO = MavenRuntimeVO.builder().projectCode(this.projectCode).application(this.applicationName).ip(IpUtils.getLocalHostLanIpAddress().getHostAddress()).port(this.port).dependencies(mavenDependencies).build();
            if (log.isInfoEnabled()) {
                log.info("Current application maven info:{}", (Object)JsonUtils.obj2Json(mavenRuntimeVO));
            }
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new MavenRuntimeInfoEvent(this, mavenRuntimeVO));
        }
        catch (Throwable e) {
            log.warn("Collection maven info failed.", e);
        }
    }

    private Collection<String> listPomProperties(URL mavenPath) throws Exception {
        HashSet<String> pomProperties;
        block7: {
            pomProperties = new HashSet<String>();
            try {
                Path myPath;
                URI uri = mavenPath.toURI();
                if (uri.getScheme().equals(JAR_FILE)) {
                    try {
                        myPath = FileSystems.newFileSystem(uri, Collections.emptyMap()).getPath(mavenPath.getPath().split("!")[1], new String[0]);
                    }
                    catch (FileSystemAlreadyExistsException e) {
                        myPath = Paths.get(uri);
                    }
                } else {
                    myPath = Paths.get(uri);
                }
                Stream<Path> walk = Files.walk(myPath, 4, new FileVisitOption[0]);
                Iterator it = walk.iterator();
                while (it.hasNext()) {
                    Path path = (Path)it.next();
                    if (!path.toString().endsWith("pom.properties")) continue;
                    pomProperties.add(path.toString());
                }
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block7;
                log.trace("Collect maven info of {} failed.", (Object)mavenPath, (Object)e);
            }
        }
        return pomProperties;
    }
}

