/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.jvm;

import java.lang.management.ManagementFactory;

public class JvmRuntimeInfoFetcher {
    public static JvmRuntimeInfo getInfo() {
        long processId = Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        String user = System.getProperty("user.name");
        String homeDirectoryOfUser = System.getProperty("user.home");
        return JvmRuntimeInfo.builder().processId(processId).user(user).homeDirectoryOfUser(homeDirectoryOfUser).build();
    }

    public static class JvmRuntimeInfo {
        private long processId;
        private String user;
        private String homeDirectoryOfUser;

        JvmRuntimeInfo(long processId, String user, String homeDirectoryOfUser) {
            this.processId = processId;
            this.user = user;
            this.homeDirectoryOfUser = homeDirectoryOfUser;
        }

        public static JvmRuntimeInfoBuilder builder() {
            return new JvmRuntimeInfoBuilder();
        }

        public long getProcessId() {
            return this.processId;
        }

        public String getUser() {
            return this.user;
        }

        public String getHomeDirectoryOfUser() {
            return this.homeDirectoryOfUser;
        }

        public static class JvmRuntimeInfoBuilder {
            private long processId;
            private String user;
            private String homeDirectoryOfUser;

            JvmRuntimeInfoBuilder() {
            }

            public JvmRuntimeInfoBuilder processId(long processId) {
                this.processId = processId;
                return this;
            }

            public JvmRuntimeInfoBuilder user(String user) {
                this.user = user;
                return this;
            }

            public JvmRuntimeInfoBuilder homeDirectoryOfUser(String homeDirectoryOfUser) {
                this.homeDirectoryOfUser = homeDirectoryOfUser;
                return this;
            }

            public JvmRuntimeInfo build() {
                return new JvmRuntimeInfo(this.processId, this.user, this.homeDirectoryOfUser);
            }

            public String toString() {
                return "JvmRuntimeInfoFetcher.JvmRuntimeInfo.JvmRuntimeInfoBuilder(processId=" + this.processId + ", user=" + this.user + ", homeDirectoryOfUser=" + this.homeDirectoryOfUser + ")";
            }
        }
    }
}

