/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.network;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastHandler {
    private static final Logger log = LoggerFactory.getLogger(MulticastHandler.class);
    private InetAddress group;
    private MulticastSocket multicastSocket;
    private int port;

    public static MulticastHandler of(String address, int port) {
        MulticastHandler multicastHandler = new MulticastHandler();
        try {
            multicastHandler.port = port;
            multicastHandler.group = InetAddress.getByName(address);
            MulticastSocket multicastSocket = new MulticastSocket(port);
            multicastSocket.joinGroup(multicastHandler.group);
            multicastHandler.multicastSocket = multicastSocket;
        }
        catch (Exception e) {
            log.info("Join to {}:{} failed.", (Object)address, (Object)port);
            throw new RuntimeException(e);
        }
        return multicastHandler;
    }

    public void send(String data) {
        if (data == null) {
            return;
        }
        try {
            byte[] bytes = data.getBytes("UTF-8");
            DatagramPacket datagramPacket = new DatagramPacket(bytes, bytes.length, this.group, this.port);
            this.multicastSocket.send(datagramPacket);
            log.debug("Send data:{}", (Object)data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String receive(int dataSize) {
        try {
            byte[] buffer = new byte[Math.max(dataSize, 1)];
            DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
            this.multicastSocket.receive(dp);
            return new String(dp.getData(), 0, dp.getLength(), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.multicastSocket != null) {
                log.info("Leave multicast group.");
                this.multicastSocket.leaveGroup(this.group);
                log.info("Close multicast socket.");
                this.multicastSocket.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.multicastSocket = null;
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public InetAddress getGroup() {
        return this.group;
    }

    public MulticastSocket getMulticastSocket() {
        return this.multicastSocket;
    }

    public int getPort() {
        return this.port;
    }
}

