/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.security;

import cn.wine.common.utils.security.authcode.AnimatedGifEncoder;
import cn.wine.common.utils.security.authcode.AuthCodeAlgorithm;
import cn.wine.common.utils.security.authcode.GifAuthCode;
import cn.wine.common.utils.security.authcode.MathVO;
import cn.wine.common.utils.security.authcode.ReadDifficulty;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.UUID;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GifAuthCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(GifAuthCodeGenerator.class);
    private static final int MIN_COLOR = 0;
    private static final int MAX_COLOR = 255;
    private static final int QUALITY = 10;
    private static final int REPEAT = 0;
    private static final int DELAY = 200;
    private static SoftReference<Font> DEFAULT_FONT;
    private Font font;
    private int width;
    private int height;

    public static GifAuthCode generateGif(@Min(value=3L) @Max(value=6L) @Min(value=3L) @Max(value=6L) int codeNum) throws IllegalArgumentException {
        return GifAuthCodeGenerator.generateGif(AuthCodeAlgorithm.NORMAL, ReadDifficulty.NORMAL, codeNum);
    }

    public static GifAuthCode generateGif(AuthCodeAlgorithm authCodeAlgorithm, ReadDifficulty readDifficulty, @Min(value=3L) @Max(value=6L) @Min(value=3L) @Max(value=6L) int codeNum) throws IllegalArgumentException {
        String authCode;
        String authCodeGifText;
        ReadDifficulty fixedReadDifficulty;
        ReadDifficulty readDifficulty2 = fixedReadDifficulty = readDifficulty == null ? ReadDifficulty.NORMAL : readDifficulty;
        if (authCodeAlgorithm == AuthCodeAlgorithm.MATH) {
            MathVO mathVO = MathVO.random();
            authCodeGifText = mathVO.getExpression();
            authCode = Integer.valueOf(mathVO.getResult()).toString();
            fixedReadDifficulty = ReadDifficulty.EASY;
        } else {
            if (codeNum < 3 || codeNum > 6) {
                throw new IllegalArgumentException("\u9a8c\u8bc1\u7801\u4f4d\u6570\u53ea\u63a5\u53d73-6\u4f4d");
            }
            authCodeGifText = authCode = UUID.randomUUID().toString().replaceAll("-", "").substring(0, codeNum);
        }
        return new GifAuthCode(authCode, GifAuthCodeGenerator.generateGif(authCodeGifText, GifAuthCodeGenerator.getDefaultFont(), fixedReadDifficulty));
    }

    public static byte[] generateGif(String code) {
        return GifAuthCodeGenerator.generateGif(code, GifAuthCodeGenerator.getDefaultFont(), ReadDifficulty.NORMAL);
    }

    public static byte[] generateGif(String code, Font font, ReadDifficulty readDifficulty) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int height = font.getSize();
        int width = code.length() * height;
        GifAuthCodeGenerator gifAuthCodeGenerator = new GifAuthCodeGenerator(width, height, font);
        gifAuthCodeGenerator.font = font;
        gifAuthCodeGenerator.out(code, byteArrayOutputStream, readDifficulty);
        return byteArrayOutputStream.toByteArray();
    }

    private GifAuthCodeGenerator(int width, int height, Font font) {
        this.width = width;
        this.height = height;
        this.font = font;
    }

    private void out(String code, OutputStream os, ReadDifficulty readDifficulty) {
        int i;
        AnimatedGifEncoder gifEncoder = new AnimatedGifEncoder();
        gifEncoder.start(os);
        gifEncoder.setQuality(10);
        gifEncoder.setDelay(RandomUtils.nextInt((int)150, (int)250));
        gifEncoder.setRepeat(0);
        char[] rands = code.toCharArray();
        Color[] fontColors = new Color[rands.length];
        for (i = 0; i < rands.length; ++i) {
            fontColors[i] = this.getRandomColor(0, 255, readDifficulty);
        }
        for (i = 0; i < rands.length; ++i) {
            BufferedImage frame = this.graphicsImage(fontColors, rands, i, readDifficulty);
            gifEncoder.addFrame(frame);
            frame.flush();
        }
        gifEncoder.finish();
    }

    private BufferedImage graphicsImage(Color[] fontColors, char[] codes, int frameIndex, ReadDifficulty readDifficulty) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.width, this.height);
        g2d.setFont(this.font);
        for (int codeIndex = 0; codeIndex < codes.length; ++codeIndex) {
            int y;
            int x;
            AlphaComposite ac = AlphaComposite.getInstance(3, this.getOpacity(codes, frameIndex, codeIndex, readDifficulty));
            g2d.setComposite(ac);
            g2d.setColor(fontColors[codeIndex]);
            if (readDifficulty != ReadDifficulty.EASY) {
                g2d.drawOval(RandomUtils.nextInt((int)0, (int)this.width), RandomUtils.nextInt((int)0, (int)this.height), this.randomOvalWidth(), this.randomOvalWidth());
            }
            switch (readDifficulty) {
                case EASY: {
                    x = this.font.getSize() * codeIndex + this.font.getSize() / 8;
                    y = this.font.getSize() - this.font.getSize() / 8;
                    break;
                }
                case HARD: {
                    x = RandomUtils.nextInt((int)0, (int)(this.font.getSize() / 2)) + this.font.getSize() * codeIndex;
                    y = RandomUtils.nextInt((int)(this.font.getSize() - this.font.getSize() / 2), (int)(this.font.getSize() + this.font.getSize() / 3));
                    break;
                }
                default: {
                    x = RandomUtils.nextInt((int)0, (int)(this.font.getSize() / 4)) + this.font.getSize() * codeIndex - this.font.getSize() / 8;
                    y = RandomUtils.nextInt((int)(this.font.getSize() - this.font.getSize() / 4), (int)(this.font.getSize() + this.font.getSize() / 6));
                }
            }
            if (readDifficulty != ReadDifficulty.EASY) {
                g2d.draw3DRect(x - this.font.getSize(), y - this.font.getSize(), this.randomOvalWidth(), this.randomOvalWidth(), false);
            }
            g2d.drawString(String.valueOf(codes[codeIndex]), x, y);
        }
        g2d.dispose();
        return image;
    }

    private int randomOvalWidth() {
        return RandomUtils.nextInt((int)(this.font.getSize() / 8), (int)(this.font.getSize() / 2));
    }

    private float getOpacity(char[] codes, int frameIndex, int codeIndex, ReadDifficulty readDifficulty) {
        if (frameIndex == codeIndex) {
            return 0.0f;
        }
        if (readDifficulty == ReadDifficulty.EASY) {
            return 1.0f;
        }
        int num = frameIndex + codeIndex;
        float r = 1.0f / (float)codes.length;
        float s = (float)codes.length * r;
        return num > codes.length ? (float)num * r - s : (float)num * r;
    }

    private Color getRandomColor(int min, int max, ReadDifficulty readDifficulty) {
        if ((min = Math.max(0, Math.min(min, 255))) > (max = Math.max(0, Math.min(max, 255)))) {
            min = 0;
            max = 255;
        }
        return new Color(readDifficulty == ReadDifficulty.EASY ? 0 : min + RandomUtils.nextInt((int)0, (int)(max - min)), readDifficulty == ReadDifficulty.EASY ? 0 : min + RandomUtils.nextInt((int)0, (int)(max - min)), readDifficulty == ReadDifficulty.EASY ? 0 : min + RandomUtils.nextInt((int)0, (int)(max - min)));
    }

    private static Font getDefaultFont() {
        if (DEFAULT_FONT == null || DEFAULT_FONT.get() == null) {
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font prettyFont = null;
            HashSet<String> useableFonts = new HashSet<String>();
            for (String font : e.getAvailableFontFamilyNames()) {
                String fontName = font.toLowerCase();
                if (!fontName.contains("microsoft")) continue;
                if (fontName.contains("yahei")) {
                    prettyFont = new Font(font, 1, 50);
                    break;
                }
                useableFonts.add(font);
            }
            if (prettyFont == null) {
                prettyFont = !useableFonts.isEmpty() ? new Font((String)useableFonts.iterator().next(), 1, 50) : new Font("\u5b8b\u4f53", 1, 50);
            }
            log.info("Use '{}' for {}", prettyFont, (Object)GifAuthCodeGenerator.class.getSimpleName());
            DEFAULT_FONT = new SoftReference<Font>(prettyFont);
        }
        return DEFAULT_FONT.get();
    }
}

