/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.common.utils.text;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CsvUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String[]> read(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            List<String[]> list = CsvUtils.read(inputStream);
            return list;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static List<String[]> read(InputStream inputStream) {
        String cvsSplitBy = ",";
        ArrayList result = Lists.newArrayList();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                result.add(line.split(cvsSplitBy));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void write(List<String[]> data, File file) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            CsvUtils.write(data, fileOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(List<String[]> data, OutputStream os) {
        byte[] commonCsvHead = new byte[]{-17, -69, -65};
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(os, "UTF-8");
            PrintWriter fileWriter = new PrintWriter(outputStreamWriter);
            fileWriter.write(new String(commonCsvHead));
            for (Object[] objectArray : data) {
                fileWriter.write(StringUtils.join((Object[])objectArray, (String)","));
                fileWriter.write("\n");
                fileWriter.flush();
            }
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

