/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.framework.ms.config;

import cn.wine.framework.base.core.eureka.EurekaRegistryFetchTimer;
import cn.wine.framework.ms.config.DefaultAnalyseAutoConfig;
import cn.wine.framework.ms.config.SwaggerAnalyseAutoConfig;
import cn.wine.framework.ms.core.EurekaStatusChangedListener;
import cn.wine.framework.ms.core.IEndpointStripPrefixAnalyst;
import cn.wine.framework.ms.core.IFrameworkAuthApi;
import cn.wine.framework.ms.core.MicroServiceApiReporter;
import cn.wine.framework.ms.core.impl.EndpointStripPrefixAnalystImpl;
import cn.wine.framework.ms.core.impl.FrameworkAuthApiImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

@Import(value={SwaggerAnalyseAutoConfig.class, DefaultAnalyseAutoConfig.class})
@ComponentScan(value={"cn.wine.framework.ms.api.backend"})
@EnableFeignClients(value={"cn.wine.framework.gateway.sdk.feign", "cn.wine.framework.ms.feign"})
@EnableScheduling
public class FrameworkMicroServiceAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(FrameworkMicroServiceAutoConfig.class);

    @Bean
    MicroServiceApiReporter getMicroServiceOpenapiReporter() {
        return new MicroServiceApiReporter();
    }

    @Bean
    EurekaStatusChangedListener getEurekaStatusChangedListener() {
        return new EurekaStatusChangedListener();
    }

    @Bean
    IEndpointStripPrefixAnalyst getEndpointStripPrefixAnalyst() {
        return new EndpointStripPrefixAnalystImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaRegistryFetchTimer.class})
    EurekaRegistryFetchTimer getEurekaRegistryFetchTimer() {
        return new EurekaRegistryFetchTimer();
    }

    @ConditionalOnProperty(value={"wine.project.framework-secret-key"})
    @Bean
    IFrameworkAuthApi getFrameworkAuthApi() {
        return new FrameworkAuthApiImpl();
    }
}

