/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.framework.ms.core;

import cn.wine.framework.base.core.eureka.EurekaRegistryFetchTimer;
import cn.wine.framework.ms.core.MicroServiceApiReporter;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class EurekaStatusChangedListener {
    private static final Logger log = LoggerFactory.getLogger(EurekaStatusChangedListener.class);
    @Autowired
    private MicroServiceApiReporter microServiceApiReporter;
    @Autowired
    private EurekaRegistryFetchTimer eurekaRegistryFetchTimer;
    private TimerTask reportTimeTask;

    @PostConstruct
    public void setup() {
        this.reportTimeTask = new TimerTask(){

            @Override
            public void run() {
                EurekaStatusChangedListener.this.microServiceApiReporter.reportRequestMappingInfoToGatewayIfNecessary();
            }
        };
        this.eurekaRegistryFetchTimer.addTask(this.reportTimeTask);
    }

    @Scheduled(cron="0 0/30 * * * ? ")
    public void timerOfReportRequestMappingInfoToGateway() {
        if (log.isInfoEnabled()) {
            log.info("Attempt to report request mapping info to gateway.");
        }
        try {
            this.microServiceApiReporter.reportNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

