/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.framework.ms.core;

import cn.wine.common.utils.JsonUtils;
import cn.wine.common.utils.ValueUtils;
import cn.wine.common.utils.security.MD5Utils;
import cn.wine.framework.base.annotation.HiddenApi;
import cn.wine.framework.base.annotation.RoutePath;
import cn.wine.framework.base.core.RestTemplateFactory;
import cn.wine.framework.base.enums.ApiTypeEnum;
import cn.wine.framework.base.vo.RequestMappingInfoReportReqVO;
import cn.wine.framework.base.vo.RequestMappingInfoVO;
import cn.wine.framework.ms.core.IEndpointDescriptionAnalyst;
import cn.wine.framework.ms.core.IEndpointStripPrefixAnalyst;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class MicroServiceApiReporter {
    private static final Logger log = LoggerFactory.getLogger(MicroServiceApiReporter.class);
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired
    private EurekaClient eurekaClient;
    @Value(value="${wine.framework.route.stripPrefix:}")
    private String stripPrefix;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${spring.application.description:}")
    private String applicationDescription;
    @Value(value="${wine.framework.openapi-gateway.report-uri:/endpoint/api/register}")
    private String openapiGatewayRegisterUri;
    @Value(value="${wine.framework.gateway.id:example-gateway}")
    private String gatewayServiceId;
    @Value(value="${wine.framework.openapi-gateway.id:openapi-gateway}")
    @Deprecated
    private String openapiGatewayServiceId;
    @Autowired
    private IEndpointDescriptionAnalyst endpointDescriptionAnalyst;
    @Autowired
    private IEndpointStripPrefixAnalyst stripPrefixAnalyst;
    @Autowired(required=false)
    private RestTemplate restTemplate = RestTemplateFactory.buildHttpClientRestTemplate();
    private String previousGatewayListDigest;

    public void reportNow() {
        this.previousGatewayListDigest = null;
        this.reportRequestMappingInfoToGatewayIfNecessary();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void reportRequestMappingInfoToGatewayIfNecessary() {
        Application application = this.eurekaClient.getApplication(ValueUtils.getValue((String)this.gatewayServiceId, (String)this.openapiGatewayServiceId));
        if (application == null) {
            this.previousGatewayListDigest = null;
            return;
        }
        List openapiServiceInstances = application.getInstances();
        if (CollectionUtils.isEmpty((Collection)openapiServiceInstances)) {
            log.info("No service[{}] found, terminate openapi report.", (Object)ValueUtils.getValue((String)this.gatewayServiceId, (String)this.openapiGatewayServiceId));
            this.previousGatewayListDigest = null;
            return;
        }
        String gatewayList = StringUtils.join((Object[])new List[]{openapiServiceInstances.stream().filter(p -> p.getStatus() == InstanceInfo.InstanceStatus.UP).sorted(Comparator.comparing(InstanceInfo::getHomePageUrl)).map(InstanceInfo::getHomePageUrl).collect(Collectors.toList())});
        String digest = MD5Utils.instance().digest(gatewayList);
        if (Objects.equals(this.previousGatewayListDigest, digest)) {
            return;
        }
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        if (log.isTraceEnabled()) {
            log.trace("There has {} mapping need to check.", (Object)handlerMethods.size());
        }
        if (MapUtils.isEmpty((Map)handlerMethods)) {
            return;
        }
        List<RequestMappingInfoVO> requestMappingInfos = this.extractRequestMappingInfo(handlerMethods, ApiTypeEnum.OPENAPI, ApiTypeEnum.PUBLIC_API, ApiTypeEnum.MANAGE, ApiTypeEnum.REST_API);
        if (log.isDebugEnabled()) {
            log.debug("Try to report openapi mapping[{}] to gateway", requestMappingInfos);
        }
        for (InstanceInfo openapiServiceInstance : openapiServiceInstances) {
            if (openapiServiceInstance.getStatus() != InstanceInfo.InstanceStatus.UP) continue;
            String reportTargetUri = openapiServiceInstance.getHomePageUrl() + (openapiServiceInstance.getHomePageUrl().endsWith("/") && this.openapiGatewayRegisterUri.startsWith("/") ? this.openapiGatewayRegisterUri.substring(1) : this.openapiGatewayRegisterUri);
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Try to report to {}", (Object)reportTargetUri);
                }
                RequestMappingInfoReportReqVO reportReqVO = new RequestMappingInfoReportReqVO(this.applicationName, this.stripPrefix, ValueUtils.getValue((String)this.applicationDescription, (String)this.applicationName), requestMappingInfos);
                String requestData = JsonUtils.obj2Json((Object)reportReqVO);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                HttpEntity formEntity = new HttpEntity((Object)requestData, (MultiValueMap)headers);
                String reportResult = (String)this.restTemplate.postForObject(reportTargetUri, (Object)formEntity, String.class, new Object[0]);
                if (!log.isDebugEnabled()) continue;
                log.debug("Report response {}", (Object)reportResult);
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) continue;
                log.info("Report openapi mapping {} to {} failed.", new Object[]{requestMappingInfos, reportTargetUri, e});
            }
        }
        this.previousGatewayListDigest = digest;
    }

    private List<RequestMappingInfoVO> extractRequestMappingInfo(Map<RequestMappingInfo, HandlerMethod> handlerMethods, ApiTypeEnum ... apiTypes) {
        ArrayList mappingInfoVOList = Lists.newArrayList();
        for (ApiTypeEnum apiType : apiTypes) {
            List<Map.Entry<RequestMappingInfo, HandlerMethod>> apiRequestMappingInfos = this.getApiRequestMappingInfos(handlerMethods, apiType.getAnnotation());
            if (log.isTraceEnabled()) {
                log.debug("There has {} {} mapping.", (Object)apiRequestMappingInfos.size(), (Object)apiType);
            }
            if (!CollectionUtils.isNotEmpty(apiRequestMappingInfos)) continue;
            for (Map.Entry<RequestMappingInfo, HandlerMethod> openapiRequestMappingInfo : apiRequestMappingInfos) {
                RequestMappingInfoVO requestMappingInfoVO;
                log.debug("Request info:{}", openapiRequestMappingInfo);
                HandlerMethod method = openapiRequestMappingInfo.getValue();
                String description = this.endpointDescriptionAnalyst.getDescription(method);
                String[] stripPrefixes = this.stripPrefixAnalyst.getStripPrefix(method, apiType);
                String[] routePaths = this.getRoutePath(method);
                if (this.hasNotBlankValue(stripPrefixes)) {
                    for (String stripPrefix : stripPrefixes) {
                        if (this.hasNotBlankValue(routePaths)) {
                            for (String routePath : routePaths) {
                                RequestMappingInfoVO requestMappingInfoVO2 = RequestMappingInfoVO.builder().stripPrefix(stripPrefix).apiType(apiType).uri(Sets.newTreeSet((Iterable)openapiRequestMappingInfo.getKey().getPatternsCondition().getPatterns())).httpMethod(Sets.newTreeSet((Iterable)openapiRequestMappingInfo.getKey().getMethodsCondition().getMethods())).routePath(routePath).description(description).build();
                                mappingInfoVOList.add(requestMappingInfoVO2);
                            }
                            continue;
                        }
                        requestMappingInfoVO = RequestMappingInfoVO.builder().stripPrefix(stripPrefix).apiType(apiType).uri(Sets.newTreeSet((Iterable)openapiRequestMappingInfo.getKey().getPatternsCondition().getPatterns())).httpMethod(Sets.newTreeSet((Iterable)openapiRequestMappingInfo.getKey().getMethodsCondition().getMethods())).description(description).build();
                        mappingInfoVOList.add(requestMappingInfoVO);
                    }
                    continue;
                }
                if (this.hasNotBlankValue(routePaths)) {
                    for (String routePath : routePaths) {
                        requestMappingInfoVO = RequestMappingInfoVO.builder().apiType(apiType).uri(Sets.newTreeSet((Iterable)openapiRequestMappingInfo.getKey().getPatternsCondition().getPatterns())).httpMethod(Sets.newTreeSet((Iterable)openapiRequestMappingInfo.getKey().getMethodsCondition().getMethods())).routePath(routePath).description(description).build();
                        mappingInfoVOList.add(requestMappingInfoVO);
                    }
                    continue;
                }
                RequestMappingInfoVO requestMappingInfoVO3 = RequestMappingInfoVO.builder().apiType(apiType).uri(Sets.newTreeSet((Iterable)openapiRequestMappingInfo.getKey().getPatternsCondition().getPatterns())).httpMethod(Sets.newTreeSet((Iterable)openapiRequestMappingInfo.getKey().getMethodsCondition().getMethods())).description(description).build();
                mappingInfoVOList.add(requestMappingInfoVO3);
            }
        }
        return mappingInfoVOList;
    }

    private boolean hasNotBlankValue(String[] data) {
        if (ArrayUtils.isEmpty((Object[])data)) {
            return false;
        }
        boolean hasCorrectValue = false;
        for (String value : data) {
            hasCorrectValue = hasCorrectValue || StringUtils.isNotBlank((CharSequence)value);
        }
        return hasCorrectValue;
    }

    private String[] getRoutePath(HandlerMethod handlerMethod) {
        RoutePath routePath = (RoutePath)handlerMethod.getMethodAnnotation(RoutePath.class);
        return routePath == null ? new String[]{} : routePath.value();
    }

    private List<Map.Entry<RequestMappingInfo, HandlerMethod>> getApiRequestMappingInfos(Map<RequestMappingInfo, HandlerMethod> handlerMethods, Class<? extends Annotation> apiTypeClass) {
        return handlerMethods.entrySet().stream().filter(p -> ((HandlerMethod)p.getValue()).getBeanType().getAnnotation(HiddenApi.class) == null && ((HandlerMethod)p.getValue()).getMethod().getAnnotation(HiddenApi.class) == null).filter(p -> ((HandlerMethod)p.getValue()).getBeanType().getAnnotation(apiTypeClass) != null || ((HandlerMethod)p.getValue()).getMethod().getAnnotation(apiTypeClass) != null).collect(Collectors.toList());
    }
}

