/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.framework.ms.core;

import cn.wine.common.exception.BusinessSilentException;
import cn.wine.common.exception.CommonExceptions;
import cn.wine.common.exception.ExceptionType;
import cn.wine.common.utils.GzipUtils;
import cn.wine.common.utils.JsonUtils;
import cn.wine.framework.base.vo.security.GrantedPrincipal;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SecurityContextHolder {
    private static final Logger log = LoggerFactory.getLogger(SecurityContextHolder.class);
    private static final ThreadLocal<Pair<String, GrantedPrincipal>> principalThreadLocalCache = new ThreadLocal();

    public static GrantedPrincipal getGrantedPrincipal() {
        HttpRequest currentRequest = SecurityContextHolder.getCurrentRequest();
        if (currentRequest == null) {
            log.warn("\u975eHttpRequest\u8bf7\u6c42\uff0c\u8bf7\u4ece\u5f53\u524d\u903b\u8f91\u4ee3\u7801\u7684\u81ea\u5b9a\u4e49\u53c2\u6570\u4e2d\u83b7\u53d6");
            return null;
        }
        String grantedPrincipalJson = currentRequest.getHeaders().getFirst("X-Auth-Principal");
        if (StringUtils.isBlank((CharSequence)grantedPrincipalJson)) {
            log.warn("\u7528\u6237\u672a\u767b\u5f55\u6216\u4e0d\u662f\u901a\u8fc7gateway\u53d1\u8d77\u7684\u8bf7\u6c42");
            return null;
        }
        Pair<String, GrantedPrincipal> grantedPrincipalPair = principalThreadLocalCache.get();
        if (grantedPrincipalPair == null || !Objects.equals(grantedPrincipalPair.getKey(), grantedPrincipalJson)) {
            GrantedPrincipal grantedPrincipal;
            try {
                if (grantedPrincipalJson.startsWith("{") && grantedPrincipalJson.endsWith("}")) {
                    grantedPrincipal = (GrantedPrincipal)JsonUtils.json2Obj((String)grantedPrincipalJson, GrantedPrincipal.class);
                } else {
                    String rawGrantedPrincipalJson = new String(GzipUtils.decompress((byte[])Base64.getDecoder().decode(grantedPrincipalJson)), StandardCharsets.UTF_8);
                    grantedPrincipal = (GrantedPrincipal)JsonUtils.json2Obj((String)rawGrantedPrincipalJson, GrantedPrincipal.class);
                }
            }
            catch (Exception e) {
                throw new BusinessSilentException((ExceptionType)CommonExceptions.PARAM_ERROR, String.format("\u65e0\u6548\u7684 header[%s]:%s", "X-Auth-Principal", grantedPrincipalJson));
            }
            principalThreadLocalCache.set((Pair<String, GrantedPrincipal>)Pair.of((Object)grantedPrincipalJson, (Object)grantedPrincipal));
            return grantedPrincipal;
        }
        return (GrantedPrincipal)grantedPrincipalPair.getValue();
    }

    public static String getClientIdOfCurrentRequest() {
        GrantedPrincipal grantedPrincipal = SecurityContextHolder.getGrantedPrincipal();
        if (grantedPrincipal != null) {
            return grantedPrincipal.getClientId();
        }
        HttpRequest currentRequest = SecurityContextHolder.getCurrentRequest();
        return currentRequest == null ? null : currentRequest.getHeaders().getFirst("X-Auth-Client");
    }

    protected static HttpRequest getCurrentRequest() {
        try {
            RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
            if (requestAttributes instanceof ServletRequestAttributes) {
                return new ServletServerHttpRequest(((ServletRequestAttributes)requestAttributes).getRequest());
            }
            return (HttpRequest)requestAttributes;
        }
        catch (Exception e) {
            return null;
        }
    }
}

