/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.framework.ms.core.impl;

import cn.wine.common.exception.CommonExceptions;
import cn.wine.common.exception.ExceptionType;
import cn.wine.common.utils.AssertUtils;
import cn.wine.common.utils.JsonUtils;
import cn.wine.common.vo.JsonResult;
import cn.wine.framework.base.config.properties.ProjectConfigBean;
import cn.wine.framework.base.enums.ApiTypeEnum;
import cn.wine.framework.base.vo.security.GrantedPrincipal;
import cn.wine.framework.base.vo.security.JwtGrantedResultVO;
import cn.wine.framework.ms.core.IFrameworkAuthApi;
import cn.wine.framework.ms.feign.FrameworkAuthFeignClient;
import java.util.Date;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;

public class FrameworkAuthApiImpl
implements IFrameworkAuthApi {
    @Autowired
    private FrameworkAuthFeignClient frameworkAuthFeignClient;
    @Autowired
    private ProjectConfigBean projectConfigBean;

    @Override
    public JsonResult<JwtGrantedResultVO> generateAccessToken(GrantedPrincipal reqVO) {
        return this.generateAccessToken(reqVO, false, null);
    }

    @Override
    public JsonResult<JwtGrantedResultVO> generateAccessTokenAndRefreshToken(GrantedPrincipal reqVO, Date refreshTokenExpireTime) {
        return this.generateAccessToken(reqVO, true, refreshTokenExpireTime);
    }

    @Override
    public JsonResult<JwtGrantedResultVO> refreshAccessToken(ApiTypeEnum apiType, String accessToken, String refreshToken) {
        AssertUtils.notNull((Object)this.projectConfigBean.getFrameworkSecretKey(), (ExceptionType)CommonExceptions.SERVER_ERROR, (String)"\u672a\u914d\u7f6e\u9879\u76ee\u64cd\u4f5c\u5bc6\u94a5'wine.project.frameworkSecretKey'");
        AssertUtils.hasText((String)accessToken, (ExceptionType)CommonExceptions.PARAM_ERROR, (String)"accessToken\u4e3a\u7a7a");
        AssertUtils.hasText((String)refreshToken, (ExceptionType)CommonExceptions.PARAM_ERROR, (String)"refreshToken\u4e3a\u7a7a");
        String requestData = accessToken + refreshToken;
        Pair noiseStringAndSign = this.projectConfigBean.generateNoiseStringAndSign(requestData);
        return this.frameworkAuthFeignClient.refreshAccessToken(apiType, accessToken, refreshToken, (String)noiseStringAndSign.getLeft(), (String)noiseStringAndSign.getRight());
    }

    private JsonResult<JwtGrantedResultVO> generateAccessToken(GrantedPrincipal reqVO, Boolean generateRefreshToken, Date refreshTokenExpireTime) {
        AssertUtils.notNull((Object)this.projectConfigBean.getFrameworkSecretKey(), (ExceptionType)CommonExceptions.SERVER_ERROR, (String)"\u672a\u914d\u7f6e\u9879\u76ee\u64cd\u4f5c\u5bc6\u94a5'wine.project.frameworkSecretKey'");
        String requestData = JsonUtils.obj2Json((Object)reqVO);
        Pair noiseStringAndSign = this.projectConfigBean.generateNoiseStringAndSign(requestData);
        return this.frameworkAuthFeignClient.generateAccessToken(reqVO, generateRefreshToken, refreshTokenExpireTime, (String)noiseStringAndSign.getLeft(), (String)noiseStringAndSign.getRight());
    }
}

