/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.base.redis.config;

import cn.wine.base.redis.config.properties.RedissonProperties;
import cn.wine.base.redis.lock.DistributedLocker;
import cn.wine.base.redis.lock.RedissonDistributedLocker;
import cn.wine.base.redis.util.RedissLockUtil;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"redisson.address"})
@ConditionalOnClass(value={Config.class, RedissonProperties.class})
@EnableConfigurationProperties(value={RedissonProperties.class})
@Configuration
public class RedissonAutoConfiguration {
    @Autowired
    private RedissonProperties redssionProperties;

    @Bean
    @ConditionalOnProperty(name={"redisson.master-name"})
    RedissonClient redissonSentinel() {
        Config config = new Config();
        config.setLockWatchdogTimeout(this.redssionProperties.getLockWatchdogTimeout());
        SentinelServersConfig serverConfig = (SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setDatabase(this.redssionProperties.getDatabase()).addSentinelAddress(this.redssionProperties.getSentinelAddresses()).setMasterName(this.redssionProperties.getMasterName()).setTimeout(this.redssionProperties.getTimeout())).setMasterConnectionPoolSize(this.redssionProperties.getMasterConnectionPoolSize())).setSlaveConnectionPoolSize(this.redssionProperties.getSlaveConnectionPoolSize());
        if (StringUtils.isNotBlank((CharSequence)this.redssionProperties.getPassword())) {
            serverConfig.setPassword(this.redssionProperties.getPassword());
        }
        return Redisson.create((Config)config);
    }

    @Bean
    @ConditionalOnProperty(name={"redisson.address"})
    RedissonClient redissonSingle() {
        Config config = new Config();
        config.setLockWatchdogTimeout(this.redssionProperties.getLockWatchdogTimeout());
        SingleServerConfig serverConfig = ((SingleServerConfig)config.useSingleServer().setDatabase(this.redssionProperties.getDatabase()).setAddress(this.redssionProperties.getAddress()).setTimeout(this.redssionProperties.getTimeout())).setConnectionPoolSize(this.redssionProperties.getConnectionPoolSize()).setConnectionMinimumIdleSize(this.redssionProperties.getConnectionMinimumIdleSize());
        if (StringUtils.isNotBlank((CharSequence)this.redssionProperties.getPassword())) {
            serverConfig.setPassword(this.redssionProperties.getPassword());
        }
        return Redisson.create((Config)config);
    }

    @Bean
    DistributedLocker distributedLocker(RedissonClient redissonClient) {
        RedissonDistributedLocker locker = new RedissonDistributedLocker();
        locker.setRedissonClient(redissonClient);
        RedissLockUtil.setLocker(locker);
        return locker;
    }
}

