/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.base.redis.dao;

import cn.wine.base.redis.ShardedJedisCurdCommonRedisDao;
import cn.wine.base.redis.bean.BaseRedisObject;
import cn.wine.base.redis.util.RedisUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;

public class CrudRedisDao<T extends BaseRedisObject<I>, I extends Serializable>
extends ShardedJedisCurdCommonRedisDao<T, I> {
    protected List<Long> bytesSet2LongList(Collection<byte[]> set) {
        return set == null ? Collections.emptyList() : set.stream().map(RedisUtil::byteArrayToLong).collect(Collectors.toList());
    }

    protected <TARGET extends Collection<Long>> TARGET bytesSet2TargetCollection(Collection<byte[]> set, TARGET target) {
        Assert.notNull(target, (String)"target must be not null");
        if (set == null) {
            return target;
        }
        set.forEach(bs -> target.add(RedisUtil.byteArrayToLong(bs)));
        return target;
    }

    protected boolean zadd(String key, Date timestamp, Integer id) {
        return this.zadd(key, timestamp.getTime(), RedisUtil.toByteArray(id));
    }

    protected boolean zadd(String key, Date timestamp, Long id) {
        return this.zadd(key, timestamp.getTime(), RedisUtil.toByteArray(id));
    }

    protected boolean zadd(String key, Date timestamp, String str) {
        return this.zadd(key, timestamp.getTime(), RedisUtil.toByteArray(str));
    }

    protected List<Long> findIdListFromSortedSetRevrange(String key, Integer page, Integer size) {
        long start = (long)Math.max(page, 0) * (long)size.intValue();
        long end = ((long)Math.max(page, 0) + 1L) * (long)size.intValue() - 1L;
        Set<byte[]> set = this.zrevrange(key, start, end);
        return this.bytesSet2LongList(set);
    }

    protected void lpushToList(String listKey, I id) {
        this.lpush(listKey, new byte[][]{RedisUtil.toByteArray(id)});
    }

    protected List<T> rpopFromList(String listKey, int size) {
        long nowSize = Math.min((long)size, this.llen(listKey));
        List<Object> list = this.pipeRpop(listKey.getBytes(), nowSize);
        Set<byte[]> idSet = list.stream().map(o -> (byte[])o).collect(Collectors.toSet());
        return this.findByIds(idSet);
    }

    protected List<Long> pipeLlen(List<String> keys) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            keys.forEach(arg_0 -> ((ShardedJedisPipeline)jedisPipeline).llen(arg_0));
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
    }

    protected void pipeExpireAt(List<String> keys, Long expireAtMills) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline pipelined = jedis.pipelined();
            keys.forEach(key -> pipelined.expireAt(key, expireAtMills.longValue()));
            pipelined.syncAndReturnAll();
        }
    }
}

