/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.base.redis.trans;

import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class PropertyDescriptorExtends {
    private PropertyDescriptor propertyDescriptor;
    private final Class<?> propertyType;
    private final Method readMethod;
    private final Method writeMethod;
    private final String name;
    private final Field propertyField;
    private final Class<?> beanClass;
    private final Map<Class, Object> annotationMapping = Maps.newHashMap();

    public PropertyDescriptorExtends(PropertyDescriptor pd, Class<?> beanClass) {
        this.beanClass = beanClass;
        this.propertyDescriptor = pd;
        this.propertyType = pd.getPropertyType();
        this.readMethod = pd.getReadMethod();
        this.writeMethod = pd.getWriteMethod();
        this.name = pd.getName();
        this.propertyField = ReflectionUtils.findField(beanClass, (String)this.name);
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public String getName() {
        return this.name;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    public <A extends Annotation> A findAnnotation(Class<A> annoClass) {
        Object cached = this.annotationMapping.get(annoClass);
        if (cached == null) {
            Annotation anno = null;
            if (this.propertyField != null) {
                anno = AnnotationUtils.findAnnotation((AnnotatedElement)this.propertyField, annoClass);
            }
            if (anno == null && this.readMethod != null) {
                anno = AnnotationUtils.findAnnotation((Method)this.readMethod, annoClass);
            }
            if (anno == null && this.writeMethod != null) {
                anno = AnnotationUtils.findAnnotation((Method)this.writeMethod, annoClass);
            }
            this.annotationMapping.put(annoClass, anno == null ? Void.TYPE : anno);
            return (A)anno;
        }
        if (cached == Void.TYPE) {
            return null;
        }
        return (A)((Annotation)cached);
    }
}

