/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.base.redis.trans.impl;

import cn.wine.base.redis.trans.ConvertorMatcher;
import cn.wine.base.redis.trans.ConvertorRegistry;
import cn.wine.base.redis.trans.ValueConvertor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class DefaultConvertorRegistry
implements ConvertorRegistry {
    private Map<Class, ValueConvertor> level1Container = Maps.newHashMap();
    private List<Bucket> level2Container = Lists.newArrayList();

    @Override
    public <V> void registerConvertor(ConvertorMatcher matcher, ValueConvertor<V> convertor) {
        this.level2Container.add(new Bucket(matcher, convertor));
    }

    @Override
    public <V> void registerConvertor(Class<V> clazz, ValueConvertor<V> convertor) {
        this.level1Container.put(clazz, convertor);
    }

    @Override
    public ValueConvertor<Object> findConvertor(Class clazz) {
        ValueConvertor vc = this.level1Container.get(clazz);
        if (vc == null) {
            for (Bucket b : this.level2Container) {
                if (!b.convertorMatcher.isMatch(clazz)) continue;
                vc = b.valueConvertor;
                break;
            }
        }
        return vc;
    }

    @Override
    public boolean isSupportedPropertyType(Class clazz) {
        return this.findConvertor(clazz) != null;
    }

    private static class Bucket {
        private ValueConvertor valueConvertor;
        private ConvertorMatcher convertorMatcher;

        Bucket(ConvertorMatcher convertorMatcher, ValueConvertor valueConvertor) {
            this.valueConvertor = valueConvertor;
            this.convertorMatcher = convertorMatcher;
        }
    }
}

