/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.base.redis.trans.impl;

import cn.wine.base.redis.trans.BeanRegistry;
import cn.wine.base.redis.trans.ConvertorMatcher;
import cn.wine.base.redis.trans.ConvertorRegistry;
import cn.wine.base.redis.trans.DataTransformer;
import cn.wine.base.redis.trans.RedisObject;
import cn.wine.base.redis.trans.Translator;
import cn.wine.base.redis.trans.ValueConvertor;
import cn.wine.base.redis.trans.impl.DefaultBeanRegistry;
import cn.wine.base.redis.trans.impl.DefaultConvertorRegistry;
import cn.wine.base.redis.trans.impl.DefaultDataTransformer;
import cn.wine.base.redis.trans.impl.DefaultTranslator;
import cn.wine.base.redis.trans.impl.convertor.BasicConvertor;
import cn.wine.base.redis.trans.impl.convertor.BeanConvertor;
import cn.wine.base.redis.trans.impl.convertor.EnumConvertor;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

public class TranslatorBuilder {
    private DataTransformer dataTransformer;
    private List<Bucket> convertorBuckets = Lists.newArrayList();
    private BeanRegistry beanRegistry;
    private ConvertorRegistry convertorRegistry;
    private static Translator defaultTranslator;

    public static TranslatorBuilder createBuilder() {
        return new TranslatorBuilder().addDefaultConvertor();
    }

    public static synchronized Translator getDefaultTranslatorSingleton() {
        if (defaultTranslator == null) {
            defaultTranslator = TranslatorBuilder.createBuilder().build();
        }
        return defaultTranslator;
    }

    public TranslatorBuilder addValueConvertor(Class clazz, ValueConvertor valueConvertor) {
        this.convertorBuckets.add(new Bucket(clazz, valueConvertor));
        return this;
    }

    public TranslatorBuilder addValueConvertor(ConvertorMatcher convertorMatcher, ValueConvertor valueConvertor) {
        this.convertorBuckets.add(new Bucket(convertorMatcher, valueConvertor));
        return this;
    }

    public <T extends Translator> Translator build() {
        DefaultTranslator dt = new DefaultTranslator();
        if (this.convertorRegistry == null) {
            this.convertorRegistry = new DefaultConvertorRegistry();
        }
        if (this.beanRegistry == null) {
            DefaultBeanRegistry beanRegistry0 = new DefaultBeanRegistry();
            beanRegistry0.setConvertorRegistry(this.convertorRegistry);
            this.beanRegistry = beanRegistry0;
        }
        if (this.dataTransformer == null) {
            this.dataTransformer = new DefaultDataTransformer();
        }
        this.addValueConvertor(RedisObject.class, (ValueConvertor)new BeanConvertor(this.convertorRegistry, this.beanRegistry));
        for (Bucket convertorBucket : this.convertorBuckets) {
            if (convertorBucket.clazz != null) {
                this.convertorRegistry.registerConvertor(convertorBucket.clazz, convertorBucket.valueConvertor);
                continue;
            }
            this.convertorRegistry.registerConvertor(convertorBucket.convertorMatcher, convertorBucket.valueConvertor);
        }
        dt.setBeanRegistry(this.beanRegistry);
        dt.setConvertorRegistry(this.convertorRegistry);
        dt.setDataTransformer(this.dataTransformer);
        return dt;
    }

    private TranslatorBuilder addDefaultConvertor() {
        this.addValueConvertor(Boolean.class, BasicConvertor.withBoolean).addValueConvertor(Boolean.TYPE, BasicConvertor.withBoolean).addValueConvertor(Byte.class, BasicConvertor.withByte).addValueConvertor(Byte.TYPE, BasicConvertor.withByte).addValueConvertor(Short.class, BasicConvertor.withShort).addValueConvertor(Short.TYPE, BasicConvertor.withShort).addValueConvertor(Integer.class, BasicConvertor.withInteger).addValueConvertor(Integer.TYPE, BasicConvertor.withInteger).addValueConvertor(Long.class, BasicConvertor.withLong).addValueConvertor(Long.TYPE, BasicConvertor.withLong).addValueConvertor(Character.class, BasicConvertor.withCharacter).addValueConvertor(Character.TYPE, BasicConvertor.withCharacter).addValueConvertor(Double.class, BasicConvertor.withDouble).addValueConvertor(Double.TYPE, BasicConvertor.withDouble).addValueConvertor(Float.class, BasicConvertor.withFloat).addValueConvertor(Float.TYPE, BasicConvertor.withFloat).addValueConvertor(BigDecimal.class, BasicConvertor.withBigDecimal).addValueConvertor(String.class, BasicConvertor.withString).addValueConvertor(java.util.Date.class, BasicConvertor.withDate).addValueConvertor(Date.class, BasicConvertor.withSqlDate).addValueConvertor(Timestamp.class, BasicConvertor.withTimestamp).addValueConvertor(Time.class, BasicConvertor.withSqlTime).addValueConvertor(EnumConvertor.MARCHER, new EnumConvertor()).addValueConvertor(BeanConvertor.MATCHER, (ValueConvertor)new BeanConvertor(this.convertorRegistry, this.beanRegistry)).addValueConvertor(LocalDateTime.class, BasicConvertor.withLocalDateTime).addValueConvertor(LocalTime.class, BasicConvertor.withLocalTime).addValueConvertor(LocalDate.class, BasicConvertor.withLocalDate);
        return this;
    }

    private static class Bucket {
        private Class clazz;
        private ValueConvertor valueConvertor;
        private ConvertorMatcher convertorMatcher;

        Bucket(Class clazz, ValueConvertor valueConvertor) {
            this.clazz = clazz;
            this.valueConvertor = valueConvertor;
        }

        Bucket(ConvertorMatcher convertorMatcher, ValueConvertor valueConvertor) {
            this.valueConvertor = valueConvertor;
            this.convertorMatcher = convertorMatcher;
        }
    }
}

