/*
 * Decompiled with CFR 0.152.
 */
package cn.wine.base.redis.util;

import cn.wine.base.redis.spi.ShardedJedisRedis;
import cn.wine.base.redis.util.RedisUtil;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.ShardedJedis;

public class SimpleDataRedisDao
extends ShardedJedisRedis {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getset(String key, String newVal) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            String string = jedis.getSet(key, newVal);
            return string;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    protected List<Long> bytesSet2LongList(Collection<byte[]> set) {
        if (set == null) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>(set.size());
        for (byte[] bs : set) {
            result.add(RedisUtil.byteArrayToLong(bs));
        }
        return result;
    }

    protected Set<String> bytesSet2StringSet(Collection<byte[]> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        for (byte[] bs : set) {
            result.add(RedisUtil.byteArrayToStr(bs));
        }
        return result;
    }

    protected Long saddBatch(String key, String ... members) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.sadd(key, members);
            return l;
        }
    }

    protected Long sremBatch(String key, String ... members) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.srem(key, members);
            return l;
        }
    }
}

